/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.mixin.fogofwar2;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.solegendary.reignofnether.fogofwar2.FogManager;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelBlockRenderer.class}, priority=1200)
public abstract class OptimizedModelBlockRendererMixin {
    @Shadow
    @Final
    private BlockColors f_110995_;

    @Inject(method={"putQuadData"}, at={@At(value="HEAD")}, cancellable=true)
    private void applyFogOfWarShading(BlockAndTintGetter pLevel, BlockState pState, BlockPos pPos, VertexConsumer pConsumer, PoseStack.Pose pPose, BakedQuad pQuad, float pBrightness0, float pBrightness1, float pBrightness2, float pBrightness3, int pLightmap0, int pLightmap1, int pLightmap2, int pLightmap3, int pPackedOverlay, CallbackInfo ci) {
        float blue;
        float green;
        float red;
        boolean allBrightnesses1;
        if (!FogManager.isEnabled()) {
            return;
        }
        boolean bl = allBrightnesses1 = pBrightness0 == pBrightness1 && pBrightness1 == pBrightness2 && pBrightness2 == pBrightness3 && pBrightness3 == 1.0f;
        if (!allBrightnesses1) {
            return;
        }
        float fogBrightness = FogManager.getPositionBrightness(pPos);
        if (fogBrightness >= 1.0f) {
            return;
        }
        ci.cancel();
        if (pQuad.m_111304_()) {
            int tintColor = this.f_110995_.m_92577_(pState, pLevel, pPos, pQuad.m_111305_());
            red = (float)(tintColor >> 16 & 0xFF) / 255.0f;
            green = (float)(tintColor >> 8 & 0xFF) / 255.0f;
            blue = (float)(tintColor & 0xFF) / 255.0f;
        } else {
            red = 1.0f;
            green = 1.0f;
            blue = 1.0f;
        }
        float[] modifiedBrightness = new float[]{pBrightness0 * fogBrightness, pBrightness1 * fogBrightness, pBrightness2 * fogBrightness, pBrightness3 * fogBrightness};
        pConsumer.m_85995_(pPose, pQuad, modifiedBrightness, red, green, blue, new int[]{pLightmap0, pLightmap1, pLightmap2, pLightmap3}, pPackedOverlay, true);
    }
}

