/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.orthoview;

import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.minimap.MinimapClientEvents;
import com.solegendary.reignofnether.orthoview.CameraBounds;
import com.solegendary.reignofnether.orthoview.CameraCollision;
import com.solegendary.reignofnether.orthoview.CameraShake;
import com.solegendary.reignofnether.orthoview.CameraTransitions;
import com.solegendary.reignofnether.orthoview.OrthoviewErrorHandler;
import com.solegendary.reignofnether.orthoview.TerrainFollowing;
import com.solegendary.reignofnether.orthoview.VisibilityCulling;
import com.solegendary.reignofnether.player.PlayerServerboundPacket;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyMath;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class CameraManager {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final float ZOOM_MIN = 10.0f;
    private static final float ZOOM_MAX = 90.0f;
    private static final float CAMROTY_MAX = -20.0f;
    private static final float CAMROTY_MIN = -90.0f;
    private static final float ZOOM_DEFAULT = 30.0f;
    private static final float CAMROTX_DEFAULT = 135.0f;
    private static final float CAMROTY_DEFAULT = -45.0f;
    private static final int FORCE_PAN_TICKS_MAX = 20;
    private static final int FORCE_ROT_FRAMES_MAX = 20;
    private static final int SMOOTH_PAN_DURATION = 30;
    private static final int SMOOTH_ZOOM_DURATION = 15;
    private static final int SMOOTH_ROT_DURATION = 25;
    private static float zoom = 30.0f;
    private static float camRotX = 135.0f;
    private static float camRotY = -45.0f;
    private static float camRotAdjX = 0.0f;
    private static float camRotAdjY = 0.0f;
    private static float panSensitivityMult = 1.0f;
    public static final float MAX_PAN_SENSITIVITY = 3.0f;
    private static Vec3 lastCameraPosition = Vec3.f_82478_;
    private static long lastPositionUpdateTime = 0L;
    private static final long VELOCITY_CALCULATION_INTERVAL = 100L;
    private static int forcePanTicksLeft = 0;
    private static float forcePanTargetX = 0.0f;
    private static float forcePanTargetZ = 0.0f;
    private static float forcePanOriginalX = 0.0f;
    private static float forcePanOriginalZ = 0.0f;
    private static float forcePanOriginalZoom = 0.0f;
    private static int forceRotFramesLeft = 0;
    private static float forceRotTargetX = 0.0f;
    private static float forceRotOriginalX = 0.0f;
    private static int cameraLockTicksLeft = 0;
    private static boolean cameraLocked = false;
    private static boolean smoothPanActive = false;
    private static int smoothPanTicksLeft = 0;
    private static float smoothPanStartX = 0.0f;
    private static float smoothPanStartZ = 0.0f;
    private static float smoothPanTargetX = 0.0f;
    private static float smoothPanTargetZ = 0.0f;
    private static CameraTransitions.EasingType smoothPanEasing = CameraTransitions.EasingType.EASE_OUT_CUBIC;
    private static boolean smoothZoomActive = false;
    private static int smoothZoomTicksLeft = 0;
    private static float smoothZoomStart = 0.0f;
    private static float smoothZoomTarget = 0.0f;
    private static CameraTransitions.EasingType smoothZoomEasing = CameraTransitions.EasingType.EASE_IN_OUT_QUAD;
    private static boolean smoothRotActive = false;
    private static int smoothRotTicksLeft = 0;
    private static float smoothRotStart = 0.0f;
    private static float smoothRotTarget = 0.0f;
    private static CameraTransitions.EasingType smoothRotEasing = CameraTransitions.EasingType.EASE_IN_OUT_CUBIC;
    public static double orthoviewPlayerBaseY = 100.0;
    public static double orthoviewPlayerMaxY = 160.0;
    private static double minOrthoviewY = 0.0;
    private Vec3 lastCameraPos = Vec3.f_82478_;
    private static Vec3 cameraVelocity = Vec3.f_82478_;

    public static void reset() {
        zoom = 30.0f;
        camRotX = 135.0f;
        camRotY = -45.0f;
        camRotAdjX = 0.0f;
        camRotAdjY = 0.0f;
        forcePanTicksLeft = 0;
        forceRotFramesLeft = 0;
        cameraLockTicksLeft = 0;
        cameraLocked = false;
        smoothPanActive = false;
        smoothPanTicksLeft = 0;
        smoothZoomActive = false;
        smoothZoomTicksLeft = 0;
        smoothRotActive = false;
        smoothRotTicksLeft = 0;
        CameraCollision.clearCache();
        VisibilityCulling.clearCache();
    }

    public static float getZoom() {
        return zoom;
    }

    public static float getCamRotX() {
        return -camRotX - camRotAdjX;
    }

    public static float getCamRotY() {
        return -camRotY - camRotAdjY;
    }

    public static boolean isCameraLocked() {
        return cameraLockTicksLeft > 0 || cameraLocked;
    }

    public static void lockCam() {
        cameraLocked = true;
    }

    public static void unlockCam() {
        cameraLocked = false;
    }

    public static void rotateCam(float x, float y) {
        if (CameraManager.isCameraLocked()) {
            return;
        }
        if ((camRotX += x) >= 360.0f) {
            camRotX -= 360.0f;
        }
        if (camRotX <= -360.0f) {
            camRotX += 360.0f;
        }
    }

    public static void zoomCam(float zoomAdj) {
        if (CameraManager.isCameraLocked()) {
            return;
        }
        float newZoom = zoom + zoomAdj;
        zoom = Math.max(10.0f, Math.min(90.0f, newZoom));
    }

    public static void smoothZoomCam(float zoomAdj) {
        if (CameraManager.isCameraLocked()) {
            return;
        }
        float targetZoom = zoom + zoomAdj;
        CameraManager.smoothZoomTo(targetZoom, CameraTransitions.CameraMovementType.ZOOM);
    }

    public static void panCam(float x, float y, float z) {
        OrthoviewErrorHandler.safeExecute(() -> {
            if (CameraManager.MC.f_91074_ != null) {
                Vec2 XZRotated = MyMath.rotateCoords(x, z, -camRotX - camRotAdjX);
                float shakeX = CameraShake.getShakeX();
                float shakeY = CameraShake.getShakeY();
                float shakeZ = CameraShake.getShakeZ();
                Vec3 intendedMovement = new Vec3((double)(XZRotated.f_82470_ + shakeX), (double)(y + shakeY), (double)(XZRotated.f_82471_ + shakeZ));
                Vec3 boundedMovement = CameraBounds.applyCameraBounds(CameraManager.MC.f_91074_.m_20182_(), intendedMovement);
                Vec3 safeMovement = CameraCollision.checkCameraCollision(CameraManager.MC.f_91074_.m_20182_(), boundedMovement);
                CameraManager.MC.f_91074_.m_6478_(MoverType.SELF, safeMovement);
            }
        }, OrthoviewErrorHandler.ErrorType.CAMERA_MOVEMENT_FAILED, "camera panning");
    }

    public static void forceMoveCam(int x, int z, int cameraLockTicks) {
        if (CameraManager.MC.f_91074_ != null) {
            forcePanTicksLeft = 20;
            forcePanTargetX = x;
            forcePanTargetZ = z;
            cameraLockTicksLeft = 20 + cameraLockTicks;
            forcePanOriginalX = CameraManager.MC.f_91074_.m_20097_().m_123341_();
            forcePanOriginalZ = CameraManager.MC.f_91074_.m_20097_().m_123343_();
            forcePanOriginalZoom = zoom;
        }
    }

    public static void forceMoveCam(Vec3i pos, int cameraLockTicks) {
        CameraManager.forceMoveCam(pos.m_123341_(), pos.m_123343_(), cameraLockTicks);
    }

    public static void fixedRotateCam(boolean clockwise) {
        if (forceRotFramesLeft <= 0) {
            camRotAdjX = 0.0f;
            int roundedRotX = Math.round(CameraManager.getCamRotX() / 90.0f) * 90 + 45;
            forceRotTargetX = (float)roundedRotX > CameraManager.getCamRotX() && clockwise ? (float)roundedRotX : ((float)roundedRotX < CameraManager.getCamRotX() && !clockwise ? (float)(roundedRotX - 90) : (clockwise ? (float)roundedRotX : (float)(roundedRotX - 90)));
            if (forceRotTargetX == CameraManager.getCamRotX() && clockwise) {
                forceRotTargetX += 90.0f;
            } else if (forceRotTargetX == CameraManager.getCamRotX()) {
                forceRotTargetX -= 90.0f;
            }
            forceRotOriginalX = CameraManager.getCamRotX();
            forceRotFramesLeft = 20;
        }
    }

    public static void centreCameraOnPos(BlockPos bp) {
        CameraManager.centreCameraOnPos(new Vec3((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_()));
    }

    public static void centreCameraOnPos(Vec3 pos) {
        if (CameraManager.MC.f_91074_ == null) {
            return;
        }
        MinimapClientEvents.setMapCentre(pos.f_82479_, pos.f_82481_);
        Vec2 XZRotated = MyMath.rotateCoords(0.0f, -20.0f, CameraManager.getCamRotX());
        float offset = (float)(Math.sqrt(CameraManager.getZoom()) / Math.sqrt(90.0));
        int yDiff = (int)(CameraManager.MC.f_91074_.m_20186_() - pos.f_82480_) - 40;
        Vec2 XZRotatedOffset = MyMath.rotateCoords(0.0f, -(offset * 35.0f) - (float)yDiff, -camRotX - camRotAdjX);
        PlayerServerboundPacket.teleportPlayer(pos.f_82479_ + (double)XZRotated.f_82470_ + (double)XZRotatedOffset.f_82470_, CameraManager.MC.f_91074_.m_20186_(), pos.f_82481_ + (double)XZRotated.f_82471_ + (double)XZRotatedOffset.f_82471_);
    }

    public static void smoothCenterCameraOnPos(BlockPos bp, CameraTransitions.CameraMovementType movementType) {
        CameraManager.smoothCenterCameraOnPos(new Vec3((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_()), movementType);
    }

    public static float getEdgeCamPanSensitivity() {
        return (float)(Math.sqrt(CameraManager.getZoom()) / Math.sqrt(90.0)) * panSensitivityMult;
    }

    public static float getPanSensitivityMult() {
        return panSensitivityMult;
    }

    public static void adjustPanSensitivityMult(boolean increase) {
        if (increase && (float)Math.round(panSensitivityMult * 10.0f) < 30.0f) {
            panSensitivityMult += 0.1f;
        } else if (!increase && Math.round(panSensitivityMult * 10.0f) > 1) {
            panSensitivityMult -= 0.1f;
        }
    }

    public static void setMinOrthoviewY(double value) {
        minOrthoviewY = value;
        if (CameraManager.MC.f_91073_ != null && CameraManager.MC.f_91074_ != null && CameraManager.MC.f_91074_.m_20186_() < value + 15.0) {
            CameraManager.MC.f_91074_.m_6478_(MoverType.SELF, new Vec3(0.0, minOrthoviewY - CameraManager.MC.f_91074_.m_20186_() + 15.0, 0.0));
        }
    }

    public static void smoothPanTo(float targetX, float targetZ, CameraTransitions.CameraMovementType movementType) {
        if (CameraManager.MC.f_91074_ == null) {
            return;
        }
        smoothPanActive = true;
        smoothPanTicksLeft = 30;
        smoothPanStartX = (float)CameraManager.MC.f_91074_.m_20185_();
        smoothPanStartZ = (float)CameraManager.MC.f_91074_.m_20189_();
        smoothPanTargetX = targetX;
        smoothPanTargetZ = targetZ;
        smoothPanEasing = CameraTransitions.getRecommendedEasing(movementType);
    }

    public static void smoothZoomTo(float targetZoom, CameraTransitions.CameraMovementType movementType) {
        smoothZoomActive = true;
        smoothZoomTicksLeft = 15;
        smoothZoomStart = zoom;
        smoothZoomTarget = Math.max(10.0f, Math.min(90.0f, targetZoom));
        smoothZoomEasing = CameraTransitions.getRecommendedEasing(movementType);
    }

    public static void smoothRotateTo(float targetRotX, CameraTransitions.CameraMovementType movementType) {
        smoothRotActive = true;
        smoothRotTicksLeft = 25;
        smoothRotStart = camRotX;
        smoothRotTarget = targetRotX;
        smoothRotEasing = CameraTransitions.getRecommendedEasing(movementType);
    }

    public static void smoothCenterCameraOnPos(Vec3 pos, CameraTransitions.CameraMovementType movementType) {
        if (CameraManager.MC.f_91074_ == null) {
            return;
        }
        MinimapClientEvents.setMapCentre(pos.f_82479_, pos.f_82481_);
        Vec2 XZRotated = MyMath.rotateCoords(0.0f, -20.0f, CameraManager.getCamRotX());
        float offset = (float)(Math.sqrt(CameraManager.getZoom()) / Math.sqrt(90.0));
        int yDiff = (int)(CameraManager.MC.f_91074_.m_20186_() - pos.f_82480_) - 40;
        Vec2 XZRotatedOffset = MyMath.rotateCoords(0.0f, -(offset * 35.0f) - (float)yDiff, -camRotX - camRotAdjX);
        float targetX = (float)(pos.f_82479_ + (double)XZRotated.f_82470_ + (double)XZRotatedOffset.f_82470_);
        float targetZ = (float)(pos.f_82481_ + (double)XZRotated.f_82471_ + (double)XZRotatedOffset.f_82471_);
        CameraManager.smoothPanTo(targetX, targetZ, movementType);
    }

    public static void updateOrthoviewY() {
        OrthoviewErrorHandler.safeExecute(() -> {
            if (CameraManager.MC.f_91074_ != null && CameraManager.MC.f_91073_ != null) {
                Vec3 playerPos = CameraManager.MC.f_91074_.m_20182_();
                Vec3 cameraVelocity = CameraManager.calculateCameraVelocity(playerPos);
                double predictedHeight = TerrainFollowing.predictHeight(playerPos, cameraVelocity);
                double optimalHeight = TerrainFollowing.calculateOptimalHeight(playerPos);
                double minimumHeight = TerrainFollowing.getMinimumHeight(playerPos);
                double targetHeight = cameraVelocity.m_82556_() > 0.01 ? predictedHeight : optimalHeight;
                orthoviewPlayerBaseY = Math.max(targetHeight, minOrthoviewY);
                orthoviewPlayerMaxY = Math.max(minimumHeight + 60.0, orthoviewPlayerBaseY + 30.0);
            }
        }, OrthoviewErrorHandler.ErrorType.COORDINATE_CALCULATION_ERROR, "orthoview Y update");
    }

    public static void updateCamera() {
        if (!OrthoviewErrorHandler.validateOrthoviewState()) {
            forcePanTicksLeft = 0;
            smoothPanTicksLeft = 0;
            smoothZoomTicksLeft = 0;
            smoothRotTicksLeft = 0;
            return;
        }
        OrthoviewErrorHandler.checkRecoveryMode();
        if (cameraLockTicksLeft > 0) {
            --cameraLockTicksLeft;
        }
        if (smoothPanActive && smoothPanTicksLeft > 0) {
            OrthoviewErrorHandler.safeExecute(() -> {
                float progress = 1.0f - (float)smoothPanTicksLeft / 30.0f;
                float[] pos = CameraTransitions.lerp2D(smoothPanStartX, smoothPanStartZ, smoothPanTargetX, smoothPanTargetZ, progress, smoothPanEasing);
                float deltaX = pos[0] - (float)CameraManager.MC.f_91074_.m_20185_();
                float deltaZ = pos[1] - (float)CameraManager.MC.f_91074_.m_20189_();
                Vec3 intendedMovement = new Vec3((double)deltaX, 0.0, (double)deltaZ);
                Vec3 safeMovement = CameraCollision.checkCameraCollision(CameraManager.MC.f_91074_.m_20182_(), intendedMovement);
                CameraManager.MC.f_91074_.m_6478_(MoverType.SELF, safeMovement);
                if (--smoothPanTicksLeft <= 0) {
                    smoothPanActive = false;
                }
            }, OrthoviewErrorHandler.ErrorType.SMOOTH_TRANSITION_ERROR, "smooth pan update");
        }
        if (smoothZoomActive && smoothZoomTicksLeft > 0) {
            OrthoviewErrorHandler.safeExecute(() -> {
                float progress = 1.0f - (float)smoothZoomTicksLeft / 15.0f;
                zoom = CameraTransitions.lerp(smoothZoomStart, smoothZoomTarget, progress, smoothZoomEasing);
                if (--smoothZoomTicksLeft <= 0) {
                    smoothZoomActive = false;
                }
            }, OrthoviewErrorHandler.ErrorType.SMOOTH_TRANSITION_ERROR, "smooth zoom update");
        }
        if (smoothRotActive && smoothRotTicksLeft > 0) {
            OrthoviewErrorHandler.safeExecute(() -> {
                float progress = 1.0f - (float)smoothRotTicksLeft / 25.0f;
                camRotX = CameraTransitions.lerp(smoothRotStart, smoothRotTarget, progress, smoothRotEasing);
                if (--smoothRotTicksLeft <= 0) {
                    smoothRotActive = false;
                }
            }, OrthoviewErrorHandler.ErrorType.SMOOTH_TRANSITION_ERROR, "smooth rotation update");
        }
        if (!smoothPanActive) {
            OrthoviewErrorHandler.safeExecute(() -> {
                Vec3 playerPos = CameraManager.MC.f_91074_.m_20182_();
                double currentY = CameraManager.MC.f_91074_.m_20186_();
                if (CameraCollision.isCameraInCollision(playerPos)) {
                    Vec3 safePosition = CameraCollision.getSafeCameraPosition(playerPos);
                    Vec3 correctionMovement = safePosition.m_82546_(playerPos);
                    if (correctionMovement.m_82556_() > 0.01) {
                        CameraManager.MC.f_91074_.m_6478_(MoverType.SELF, correctionMovement.m_82490_(0.3));
                    }
                } else if (TerrainFollowing.shouldUseAggressiveFollowing(playerPos)) {
                    if (currentY < orthoviewPlayerBaseY - 2.0) {
                        CameraManager.panCam(0.0f, 2.0f, 0.0f);
                    } else if (currentY > orthoviewPlayerMaxY + 2.0) {
                        CameraManager.panCam(0.0f, -2.0f, 0.0f);
                    }
                } else {
                    if (MiscUtil.isGroundBlock((Level)CameraManager.MC.f_91073_, CameraManager.MC.f_91074_.m_20183_().m_7918_(0, -5, 0)) && currentY <= orthoviewPlayerMaxY) {
                        CameraManager.panCam(0.0f, 1.0f, 0.0f);
                    }
                    if (!MiscUtil.isGroundBlock((Level)CameraManager.MC.f_91073_, CameraManager.MC.f_91074_.m_20183_().m_7918_(0, -6, 0)) && currentY >= orthoviewPlayerBaseY) {
                        CameraManager.panCam(0.0f, -1.0f, 0.0f);
                    }
                }
            }, OrthoviewErrorHandler.ErrorType.CAMERA_MOVEMENT_FAILED, "terrain following movement");
        }
        if (forcePanTicksLeft > 0 && !smoothPanActive) {
            float xDiff = (forcePanTargetX - forcePanOriginalX) / 20.0f;
            float zDiff = (forcePanTargetZ - forcePanOriginalZ) / 20.0f;
            float zoomDiff = (30.0f - forcePanOriginalZoom) / 20.0f;
            zoom += zoomDiff;
            CameraManager.MC.f_91074_.m_6478_(MoverType.SELF, new Vec3((double)xDiff, 0.0, (double)zDiff));
            --forcePanTicksLeft;
        }
        CameraManager.updateOrthoviewY();
    }

    public static void updateRotation() {
        if (forceRotFramesLeft > 0) {
            float xDiff = (forceRotTargetX - forceRotOriginalX) / 20.0f;
            CameraManager.rotateCam(-xDiff, 0.0f);
            if (--forceRotFramesLeft <= 0) {
                camRotX = -forceRotTargetX;
                CameraManager.rotateCam(0.0f, 0.0f);
            }
        }
    }

    public static void applyRotationToPlayer() {
        if (CameraManager.MC.f_91074_ != null) {
            CameraManager.MC.f_91074_.m_146926_(-camRotY - camRotAdjY);
            CameraManager.MC.f_91074_.m_146922_(-camRotX - camRotAdjX);
        }
    }

    public static void setCamRotAdj(float adjX, float adjY) {
        camRotAdjX = adjX;
        camRotAdjY = adjY;
    }

    public static void commitRotationAdjustments() {
        CameraManager.rotateCam(camRotAdjX, camRotAdjY);
        camRotAdjX = 0.0f;
        camRotAdjY = 0.0f;
    }

    public void updateCameraPosition(Vec3 newPos) {
        cameraVelocity = newPos.m_82546_(this.lastCameraPos);
        this.lastCameraPos = newPos;
    }

    public static Vec3 getCameraVelocity() {
        return cameraVelocity;
    }

    public static void setTerrainFollowingSmooth(boolean enabled) {
        TerrainFollowing.setHeightTransitionsEnabled(enabled);
    }

    public static void clearTerrainCache() {
        TerrainFollowing.clearCache();
    }

    public static String getTerrainFollowingStats() {
        return TerrainFollowing.getCacheStatistics();
    }

    public static void setCameraBounds(double minX, double maxX, double minZ, double maxZ) {
        CameraBounds.setXZBounds(minX, maxX, minZ, maxZ);
        CameraBounds.setBoundaryMode(CameraBounds.BoundaryMode.BOTH);
    }

    public static void setCameraBoundaryMode(CameraBounds.BoundaryMode mode) {
        CameraBounds.setBoundaryMode(mode);
    }

    public static void enableSoftBoundaries(double margin) {
        CameraBounds.setSoftBoundaries(true, margin);
    }

    public static void disableSoftBoundaries() {
        CameraBounds.setSoftBoundaries(false, 0.0);
    }

    public static void resetCameraBounds() {
        CameraBounds.resetBounds();
    }

    public static String getCameraBoundsStatus() {
        return CameraBounds.getBoundaryStatus();
    }

    public static boolean isCameraNearBoundary() {
        if (CameraManager.MC.f_91074_ == null) {
            return false;
        }
        return CameraBounds.isInDangerZone(CameraManager.MC.f_91074_.m_20182_());
    }

    public static void setCollisionSmoothing(boolean enabled) {
        CameraCollision.setSmoothCollisionEnabled(enabled);
    }

    public static void setBuildingCollision(boolean enabled) {
        CameraCollision.setBuildingCollisionEnabled(enabled);
    }

    public static void setTerrainCollision(boolean enabled) {
        CameraCollision.setTerrainCollisionEnabled(enabled);
    }

    public static void setCollisionPushbackStrength(double strength) {
        CameraCollision.setCollisionPushbackStrength(strength);
    }

    public static void clearCollisionCache() {
        CameraCollision.clearCache();
    }

    public static String getCollisionStatistics() {
        return CameraCollision.getCollisionStatistics();
    }

    public static boolean isCameraInCollision() {
        if (CameraManager.MC.f_91074_ == null) {
            return false;
        }
        return CameraCollision.isCameraInCollision(CameraManager.MC.f_91074_.m_20182_());
    }

    public static void moveCameraToSafePosition() {
        if (CameraManager.MC.f_91074_ == null) {
            return;
        }
        Vec3 safePosition = CameraCollision.getSafeCameraPosition(CameraManager.MC.f_91074_.m_20182_());
        Vec3 movement = safePosition.m_82546_(CameraManager.MC.f_91074_.m_20182_());
        if (movement.m_82556_() > 0.01) {
            CameraManager.MC.f_91074_.m_6478_(MoverType.SELF, movement);
        }
    }

    public static void setCameraShakeEnabled(boolean enabled) {
        CameraShake.setShakeEnabled(enabled);
    }

    public static void setCameraShakeIntensity(float multiplier) {
        CameraShake.setGlobalShakeMultiplier(multiplier);
    }

    public static void setMaxCameraShakeIntensity(float maxIntensity) {
        CameraShake.setMaxShakeIntensity(maxIntensity);
    }

    public static void setCameraShakeMaxDistance(double distance) {
        CameraShake.setMaxShakeDistance(distance);
    }

    public static void clearCameraShake() {
        CameraShake.clearAllShakes();
    }

    public static boolean isCameraShaking() {
        return CameraShake.hasActiveShakes();
    }

    public static float getCameraShakeIntensity() {
        return CameraShake.getTotalShakeIntensity();
    }

    public static String getCameraShakeStatistics() {
        return CameraShake.getShakeStatistics();
    }

    public static void addExplosionShake(Vec3 position, float power) {
        CameraShake.explosionAt(position, power);
    }

    public static void addCombatShake(Vec3 position) {
        CameraShake.combatHit(position);
    }

    public static void addBuildingDestroyedShake(Vec3 position) {
        CameraShake.buildingDestroyed(position);
    }

    public static void setRenderDistance(double distance) {
        VisibilityCulling.setRenderDistance(distance);
    }

    public static void setEntityCullDistance(double distance) {
        VisibilityCulling.setEntityCullDistance(distance);
    }

    public static void setBuildingCullDistance(double distance) {
        VisibilityCulling.setBuildingCullDistance(distance);
    }

    public static void setParticleCullDistance(double distance) {
        VisibilityCulling.setParticleCullDistance(distance);
    }

    public static void setDistanceCullingEnabled(boolean enabled) {
        VisibilityCulling.setDistanceCullingEnabled(enabled);
    }

    public static void setFrustumCullingEnabled(boolean enabled) {
        VisibilityCulling.setFrustumCullingEnabled(enabled);
    }

    public static void setFogOfWarCullingEnabled(boolean enabled) {
        VisibilityCulling.setFogOfWarCullingEnabled(enabled);
    }

    public static void setChunkCullingEnabled(boolean enabled) {
        VisibilityCulling.setChunkCullingEnabled(enabled);
    }

    public static void setLevelOfDetailEnabled(boolean enabled) {
        VisibilityCulling.setLevelOfDetailEnabled(enabled);
    }

    public static void setDetailDistances(double high, double medium, double low) {
        VisibilityCulling.setDetailDistances(high, medium, low);
    }

    public static void clearVisibilityCullingCache() {
        VisibilityCulling.clearCache();
    }

    public static String getVisibilityCullingStatistics() {
        return VisibilityCulling.getCullingStatistics();
    }

    public static double getRenderDistance() {
        return VisibilityCulling.getRenderDistance();
    }

    public static boolean isVisibilityCullingEnabled() {
        return VisibilityCulling.isCullingEnabled();
    }

    public static List<VisibilityCulling.BuildingRenderInfo> getVisibleBuildings() {
        return VisibilityCulling.getVisibleBuildings();
    }

    public static List<VisibilityCulling.EntityRenderInfo> getVisibleEntities(List<Entity> entities) {
        return VisibilityCulling.getVisibleEntities(entities);
    }

    public static boolean shouldRenderAnyBuildings() {
        return VisibilityCulling.shouldRenderAnyBuildings();
    }

    public static boolean shouldRenderObject(Vec3 position, double objectRadius) {
        return VisibilityCulling.shouldRenderObject(position, objectRadius);
    }

    public static VisibilityCulling.CullingResult checkBuildingVisibility(BuildingPlacement building) {
        return VisibilityCulling.checkBuildingVisibility(building);
    }

    public static VisibilityCulling.CullingResult checkEntityVisibility(Entity entity) {
        return VisibilityCulling.checkEntityVisibility(entity);
    }

    public static boolean shouldRenderChunk(ChunkPos chunkPos) {
        return VisibilityCulling.shouldRenderChunk(chunkPos);
    }

    public static boolean shouldRenderParticles(Vec3 particlePos) {
        return VisibilityCulling.shouldRenderParticles(particlePos);
    }

    public static List<ChunkPos> getVisibleChunks() {
        return VisibilityCulling.getVisibleChunks();
    }

    public static VisibilityCulling.DetailLevel getDetailLevelForDistance(double distance) {
        return VisibilityCulling.getDetailLevelForDistance(distance);
    }

    public static int getVisibleChunkCount() {
        return VisibilityCulling.getVisibleChunkCount();
    }

    public static Map<ChunkPos, Boolean> shouldRenderChunks(List<ChunkPos> chunks) {
        return VisibilityCulling.shouldRenderChunks(chunks);
    }

    public static VisibilityCulling.CullingStatistics getCullingPerformanceStats() {
        return VisibilityCulling.getCullingPerformanceStats();
    }

    public static void forceRefreshVisibilityCaches() {
        VisibilityCulling.forceRefreshAllCaches();
    }

    private static Vec3 calculateCameraVelocity(Vec3 currentPosition) {
        return OrthoviewErrorHandler.safeExecute(() -> {
            long currentTime = System.currentTimeMillis();
            if (lastPositionUpdateTime == 0L) {
                lastCameraPosition = currentPosition;
                lastPositionUpdateTime = currentTime;
                return Vec3.f_82478_;
            }
            long timeDiff = currentTime - lastPositionUpdateTime;
            if (timeDiff < 100L) {
                return Vec3.f_82478_;
            }
            Vec3 positionDiff = currentPosition.m_82546_(lastCameraPosition);
            double timeInSeconds = (double)timeDiff / 1000.0;
            Vec3 velocity = positionDiff.m_82490_(1.0 / timeInSeconds);
            lastCameraPosition = currentPosition;
            lastPositionUpdateTime = currentTime;
            return velocity;
        }, Vec3.f_82478_, OrthoviewErrorHandler.ErrorType.COORDINATE_CALCULATION_ERROR, "camera velocity calculation");
    }
}

