/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.orthoview;

import com.solegendary.reignofnether.fogofwar2.FogManager;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.orthoview.OrthoviewErrorHandler;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;

public class LeavesHidingManager {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final ConcurrentHashMap<ChunkPos, Boolean> chunkVisibilityCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<BlockPos, Boolean> leavesVisibilityCache = new ConcurrentHashMap();
    private static int lastUpdateTick = 0;
    private static final int CACHE_INVALIDATION_INTERVAL = 20;
    private static final int CURSOR_HIDE_RADIUS = 10;
    private static final int UNIT_HIDE_RADIUS = 8;

    public static boolean shouldHideLeaves(BlockPos pos, BlockState state) {
        return OrthoviewErrorHandler.safeExecute(() -> {
            if (!OrthoviewClientEvents.isEnabled() || !LeavesHidingManager.isLeavesBlock(state)) {
                return false;
            }
            OrthoviewClientEvents.LeafHideMethod method = OrthoviewClientEvents.hideLeavesMethod;
            switch (method) {
                case NONE: {
                    return false;
                }
                case ALL: {
                    return true;
                }
                case AROUND_UNITS_AND_CURSOR: {
                    return LeavesHidingManager.shouldHideAroundUnitsAndCursor(pos);
                }
            }
            return false;
        }, false, OrthoviewErrorHandler.ErrorType.LEAVES_HIDING_ERROR, "leaves hiding calculation");
    }

    private static boolean shouldHideAroundUnitsAndCursor(BlockPos pos) {
        Boolean cached = leavesVisibilityCache.get(pos);
        if (cached != null && LeavesHidingManager.MC.f_91073_.m_46467_() - (long)lastUpdateTick < 20L) {
            return cached;
        }
        boolean shouldHide = LeavesHidingManager.calculateShouldHide(pos);
        leavesVisibilityCache.put(pos, shouldHide);
        return shouldHide;
    }

    private static boolean calculateShouldHide(BlockPos pos) {
        if (LeavesHidingManager.MC.f_91073_ == null || LeavesHidingManager.MC.f_91074_ == null) {
            return false;
        }
        if (!LeavesHidingManager.isPositionVisible(pos)) {
            return false;
        }
        if (LeavesHidingManager.shouldHideAroundCursor(pos)) {
            return true;
        }
        return LeavesHidingManager.shouldHideAroundUnits(pos);
    }

    private static boolean isPositionVisible(BlockPos pos) {
        if (!FogManager.isEnabled()) {
            return true;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        Boolean cached = chunkVisibilityCache.get(chunkPos);
        if (cached != null) {
            return cached;
        }
        boolean visible = FogManager.isChunkVisible(chunkPos);
        chunkVisibilityCache.put(chunkPos, visible);
        return visible;
    }

    private static boolean shouldHideAroundCursor(BlockPos pos) {
        if (LeavesHidingManager.MC.f_91067_ == null) {
            return false;
        }
        BlockPos cursorPos = LeavesHidingManager.getCursorWorldPosition();
        if (cursorPos == null) {
            return false;
        }
        double distance = pos.m_123331_((Vec3i)cursorPos);
        return distance <= 100.0;
    }

    private static boolean shouldHideAroundUnits(BlockPos pos) {
        if (LeavesHidingManager.MC.f_91074_ == null) {
            return false;
        }
        return UnitClientEvents.getAllUnits().stream().filter(entity -> entity instanceof Unit).map(entity -> (Unit)entity).filter(unit -> unit.getOwnerName().equals(LeavesHidingManager.MC.f_91074_.m_7755_().getString())).anyMatch(unit -> {
            BlockPos unitPos = ((LivingEntity)unit).m_20183_();
            double distance = pos.m_123331_((Vec3i)unitPos);
            return distance <= 64.0;
        });
    }

    private static BlockPos getCursorWorldPosition() {
        if (LeavesHidingManager.MC.f_91074_ == null || LeavesHidingManager.MC.f_91073_ == null) {
            return null;
        }
        return LeavesHidingManager.MC.f_91074_.m_20183_();
    }

    private static boolean isLeavesBlock(BlockState state) {
        return state.m_60734_() instanceof LeavesBlock || state.m_60713_(Blocks.f_152470_) || state.m_60713_(Blocks.f_152471_);
    }

    public static void invalidateCache() {
        chunkVisibilityCache.clear();
        leavesVisibilityCache.clear();
        lastUpdateTick = (int)(LeavesHidingManager.MC.f_91073_ != null ? LeavesHidingManager.MC.f_91073_.m_46467_() : 0L);
    }

    public static void tick() {
        if (LeavesHidingManager.MC.f_91073_ == null) {
            return;
        }
        long currentTick = LeavesHidingManager.MC.f_91073_.m_46467_();
        if (currentTick % 20L == 0L) {
            chunkVisibilityCache.clear();
            if (leavesVisibilityCache.size() > 1000) {
                leavesVisibilityCache.clear();
            }
            lastUpdateTick = (int)currentTick;
        }
    }

    public static void onFogUpdate() {
        LeavesHidingManager.invalidateCache();
    }

    public static void onUnitsChanged() {
        leavesVisibilityCache.clear();
    }
}

