/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.orthoview;

import com.solegendary.reignofnether.orthoview.CameraManager;
import com.solegendary.reignofnether.orthoview.OrthoviewErrorHandler;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class TerrainFollowing {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final int BASE_SAMPLE_RADIUS = 10;
    private static final int EXTENDED_SAMPLE_RADIUS = 20;
    private static final int MIN_SAMPLE_POINTS = 16;
    private static final int EXTENDED_SAMPLE_POINTS = 36;
    private static final float BASE_HEIGHT_OFFSET = 35.0f;
    private static final float MAX_HEIGHT_OFFSET = 120.0f;
    private static final float HEIGHT_SMOOTHING_FACTOR = 0.15f;
    private static final float TERRAIN_VARIANCE_THRESHOLD = 12.0f;
    private static final float STEEP_SLOPE_THRESHOLD = 0.5f;
    private static final ConcurrentHashMap<ChunkCoordinate, HeightData> heightCache = new ConcurrentHashMap();
    private static final int CACHE_EXPIRY_TICKS = 60;
    private static long lastCacheCleanup = 0L;
    private static float targetHeight = 0.0f;
    private static float currentHeight = 0.0f;
    private static boolean heightTransitionActive = false;
    private static final float HEIGHT_TRANSITION_SPEED = 0.18f;
    private static final int LOOKAHEAD_DISTANCE = 12;
    private static final float STEEP_TERRAIN_HEIGHT_BONUS = 15.0f;
    private static float lastAverageHeight = -1.0f;

    public static double calculateOptimalHeight(Vec3 cameraPos) {
        return OrthoviewErrorHandler.safeExecute(() -> {
            if (TerrainFollowing.MC.f_91073_ == null) {
                return CameraManager.orthoviewPlayerBaseY;
            }
            ClientLevel level = TerrainFollowing.MC.f_91073_;
            Vec3 velocity = CameraManager.getCameraVelocity();
            BlockPos centerPos = new BlockPos((int)cameraPos.f_82479_, (int)cameraPos.f_82480_, (int)cameraPos.f_82481_);
            HeightData heightData = TerrainFollowing.getHeightDataDynamic(centerPos, velocity);
            HeightData predictedData = TerrainFollowing.multiStepDirectionalLookahead(cameraPos, velocity, centerPos);
            HeightData effectiveData = TerrainFollowing.chooseBestHeightData(heightData, predictedData);
            float avgSlope = TerrainFollowing.calculateAverageSlope((Level)level, centerPos, 10);
            float baseHeight = effectiveData.averageHeight + 35.0f;
            float additionalHeight = TerrainFollowing.calculateAdditionalHeight(effectiveData);
            if (TerrainFollowing.isRapidElevationChange(effectiveData)) {
                additionalHeight += 8.0f;
            }
            if (avgSlope > 4.0f) {
                additionalHeight += Math.min(avgSlope * 3.0f, 18.0f);
            }
            if (TerrainFollowing.isSteepTerrain(effectiveData)) {
                additionalHeight += 15.0f;
            }
            targetHeight = baseHeight + additionalHeight;
            if (heightTransitionActive) {
                float adaptiveSpeed = TerrainFollowing.calculateAdaptiveTransitionSpeed(currentHeight, targetHeight, effectiveData);
                currentHeight = TerrainFollowing.smoothTransition(currentHeight, targetHeight, adaptiveSpeed);
                return currentHeight;
            }
            currentHeight = targetHeight;
            return targetHeight;
        }, CameraManager.orthoviewPlayerBaseY, OrthoviewErrorHandler.ErrorType.COORDINATE_CALCULATION_ERROR, "terrain height calculation");
    }

    private static HeightData getHeightData(BlockPos centerPos) {
        ChunkCoordinate coord = new ChunkCoordinate(centerPos.m_123341_() >> 4, centerPos.m_123343_() >> 4);
        HeightData cached = heightCache.get(coord);
        if (cached != null && !cached.isExpired()) {
            return cached;
        }
        HeightData newData = TerrainFollowing.calculateHeightData(centerPos);
        heightCache.put(coord, newData);
        if (System.currentTimeMillis() - lastCacheCleanup > 5000L) {
            TerrainFollowing.cleanupCache();
            lastCacheCleanup = System.currentTimeMillis();
        }
        return newData;
    }

    private static HeightData calculateHeightData(BlockPos centerPos) {
        ClientLevel level = TerrainFollowing.MC.f_91073_;
        if (level == null) {
            return new HeightData(centerPos.m_123342_(), centerPos.m_123342_(), centerPos.m_123342_(), 0.0f, false);
        }
        HeightSample baseSample = TerrainFollowing.sampleHeights((Level)level, centerPos, 10, 16);
        boolean needsExtendedSampling = baseSample.variance > 12.0f || baseSample.hasWater || baseSample.hasLava;
        HeightSample finalSample = needsExtendedSampling ? TerrainFollowing.sampleHeights((Level)level, centerPos, 20, 36) : baseSample;
        return new HeightData(finalSample.averageHeight, finalSample.maxHeight, finalSample.minHeight, finalSample.variance, needsExtendedSampling);
    }

    private static HeightSample sampleHeights(Level level, BlockPos center, int radius, int targetSamples) {
        float totalHeight = 0.0f;
        float maxHeight = Float.MIN_VALUE;
        float minHeight = Float.MAX_VALUE;
        int validSamples = 0;
        boolean hasWater = false;
        boolean hasLava = false;
        int step = Math.max(1, radius * 2 / (int)Math.sqrt(targetSamples));
        for (int x = -radius; x <= radius; x += step) {
            for (int z = -radius; z <= radius; z += step) {
                int worldZ;
                int height;
                if (x * x + z * z > radius * radius) continue;
                int worldX = center.m_123341_() + x;
                BlockPos surfacePos = new BlockPos(worldX, height = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, worldX, worldZ = center.m_123343_() + z), worldZ);
                if (level.m_6425_(surfacePos).m_76170_()) {
                    if (level.m_6425_(surfacePos).m_76152_().toString().contains("water")) {
                        hasWater = true;
                    } else if (level.m_6425_(surfacePos).m_76152_().toString().contains("lava")) {
                        hasLava = true;
                        height += 5;
                    }
                }
                totalHeight += (float)height;
                maxHeight = Math.max(maxHeight, (float)height);
                minHeight = Math.min(minHeight, (float)height);
                ++validSamples;
            }
        }
        if (validSamples == 0) {
            return new HeightSample(center.m_123342_(), center.m_123342_(), center.m_123342_(), 0.0f, false, false);
        }
        float averageHeight = totalHeight / (float)validSamples;
        float variance = maxHeight - minHeight;
        return new HeightSample(averageHeight, maxHeight, minHeight, variance, hasWater, hasLava);
    }

    private static float calculateAdditionalHeight(HeightData heightData) {
        float heightRange;
        float additionalHeight = 0.0f;
        float varianceMultiplier = Math.min(heightData.variance / 12.0f, 2.5f);
        additionalHeight += varianceMultiplier * 18.0f;
        if (heightData.hasComplexTerrain) {
            additionalHeight += 25.0f;
        }
        if ((heightRange = heightData.maxHeight - heightData.minHeight) > 25.0f) {
            additionalHeight += Math.min(heightRange * 0.4f, 35.0f);
        }
        float zoomFactor = CameraManager.getZoom() / 30.0f;
        return Math.min(additionalHeight *= zoomFactor, 85.0f);
    }

    private static float smoothTransition(float current, float target, float speed) {
        float difference = target - current;
        float change = difference * speed;
        if (Math.abs(change) < 0.15f && Math.abs(difference) < 1.2f) {
            return target;
        }
        return current + change;
    }

    public static void setHeightTransitionsEnabled(boolean enabled) {
        heightTransitionActive = enabled;
        if (!enabled) {
            currentHeight = targetHeight;
        }
    }

    public static double getMinimumHeight(Vec3 cameraPos) {
        return OrthoviewErrorHandler.safeExecute(() -> {
            if (TerrainFollowing.MC.f_91073_ == null) {
                return CameraManager.orthoviewPlayerBaseY;
            }
            BlockPos centerPos = new BlockPos((int)cameraPos.f_82479_, (int)cameraPos.f_82480_, (int)cameraPos.f_82481_);
            HeightData heightData = TerrainFollowing.getHeightData(centerPos);
            return heightData.maxHeight + 10.0f;
        }, CameraManager.orthoviewPlayerBaseY, OrthoviewErrorHandler.ErrorType.COORDINATE_CALCULATION_ERROR, "minimum height calculation");
    }

    public static double predictHeight(Vec3 currentPos, Vec3 velocity) {
        if (velocity.m_82556_() < 0.01) {
            return TerrainFollowing.calculateOptimalHeight(currentPos);
        }
        Vec3 futurePos = currentPos.m_82549_(velocity.m_82490_(5.0));
        return TerrainFollowing.calculateOptimalHeight(futurePos);
    }

    private static void cleanupCache() {
        heightCache.entrySet().removeIf(entry -> ((HeightData)entry.getValue()).isExpired());
    }

    public static void clearCache() {
        heightCache.clear();
    }

    public static String getCacheStatistics() {
        return String.format("Terrain Cache: %d entries, %d expired", heightCache.size(), (int)heightCache.values().stream().filter(HeightData::isExpired).count());
    }

    public static boolean shouldUseAggressiveFollowing(Vec3 cameraPos) {
        return OrthoviewErrorHandler.safeExecute(() -> {
            BlockPos centerPos = new BlockPos((int)cameraPos.f_82479_, (int)cameraPos.f_82480_, (int)cameraPos.f_82481_);
            HeightData heightData = TerrainFollowing.getHeightData(centerPos);
            return heightData.hasComplexTerrain || heightData.variance > 12.0f;
        }, false, OrthoviewErrorHandler.ErrorType.COORDINATE_CALCULATION_ERROR, "aggressive following check");
    }

    private static HeightData getLookaheadHeightData(Vec3 cameraPos, BlockPos centerPos) {
        BlockPos lookaheadPos = centerPos.m_7918_(12, 0, 0);
        HeightData eastData = TerrainFollowing.getHeightData(lookaheadPos);
        lookaheadPos = centerPos.m_7918_(-12, 0, 0);
        HeightData westData = TerrainFollowing.getHeightData(lookaheadPos);
        lookaheadPos = centerPos.m_7918_(0, 0, 12);
        HeightData southData = TerrainFollowing.getHeightData(lookaheadPos);
        lookaheadPos = centerPos.m_7918_(0, 0, -12);
        HeightData northData = TerrainFollowing.getHeightData(lookaheadPos);
        HeightData best = eastData;
        if (westData.maxHeight > best.maxHeight || westData.hasComplexTerrain && !best.hasComplexTerrain) {
            best = westData;
        }
        if (southData.maxHeight > best.maxHeight || southData.hasComplexTerrain && !best.hasComplexTerrain) {
            best = southData;
        }
        if (northData.maxHeight > best.maxHeight || northData.hasComplexTerrain && !best.hasComplexTerrain) {
            best = northData;
        }
        return best;
    }

    private static HeightData chooseBestHeightData(HeightData current, HeightData lookahead) {
        float heightDifference = lookahead.maxHeight - current.maxHeight;
        if (heightDifference > 15.0f || lookahead.hasComplexTerrain && !current.hasComplexTerrain || lookahead.variance > current.variance * 1.4f) {
            return lookahead;
        }
        return current;
    }

    private static boolean isSteepTerrain(HeightData heightData) {
        float heightRange = heightData.maxHeight - heightData.minHeight;
        return heightRange > 25.0f || heightData.variance > 15.599999f;
    }

    private static float calculateAdaptiveTransitionSpeed(float currentHeight, float targetHeight, HeightData heightData) {
        float heightDifference = Math.abs(targetHeight - currentHeight);
        float baseSpeed = 0.18f;
        if (TerrainFollowing.isSteepTerrain(heightData)) {
            baseSpeed *= 2.2f;
        }
        if (heightDifference > 60.0f) {
            baseSpeed *= 3.0f;
        } else if (heightDifference > 30.0f) {
            baseSpeed *= 2.0f;
        } else if (heightDifference > 15.0f) {
            baseSpeed *= 1.4f;
        }
        return Math.min(baseSpeed, 0.45f);
    }

    private static HeightData getHeightDataDynamic(BlockPos centerPos, Vec3 velocity) {
        int expiryTicks;
        ChunkCoordinate coord = new ChunkCoordinate(centerPos.m_123341_() >> 4, centerPos.m_123343_() >> 4);
        HeightData cached = heightCache.get(coord);
        if (cached != null && !cached.isExpired()) {
            return cached;
        }
        HeightData newData = TerrainFollowing.calculateHeightData(centerPos);
        heightCache.put(coord, newData);
        int n = expiryTicks = velocity.m_82556_() > 0.09 || newData.variance > 12.0f ? 20 : 60;
        if (System.currentTimeMillis() - lastCacheCleanup > (long)(expiryTicks * 50)) {
            TerrainFollowing.cleanupCache();
            lastCacheCleanup = System.currentTimeMillis();
        }
        return newData;
    }

    private static HeightData multiStepDirectionalLookahead(Vec3 cameraPos, Vec3 velocity, BlockPos centerPos) {
        if (velocity.m_82556_() < 0.01) {
            return TerrainFollowing.getLookaheadHeightData(cameraPos, centerPos);
        }
        HeightData combined = TerrainFollowing.getHeightData(centerPos);
        for (int step = 1; step <= 3; ++step) {
            Vec3 future = cameraPos.m_82549_(velocity.m_82490_((double)(step * 4)));
            BlockPos pos = new BlockPos((int)future.f_82479_, (int)future.f_82480_, (int)future.f_82481_);
            combined = TerrainFollowing.chooseBestHeightData(combined, TerrainFollowing.getHeightData(pos));
        }
        return combined;
    }

    private static boolean isRapidElevationChange(HeightData heightData) {
        if (lastAverageHeight < 0.0f) {
            lastAverageHeight = heightData.averageHeight;
            return false;
        }
        float delta = Math.abs(heightData.averageHeight - lastAverageHeight);
        lastAverageHeight = heightData.averageHeight;
        return delta > 3.5f;
    }

    private static float calculateAverageSlope(Level level, BlockPos center, int radius) {
        float totalSlope = 0.0f;
        int count = 0;
        int baseHeight = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, center.m_123341_(), center.m_123343_());
        for (int dx = -radius; dx <= radius; dx += 2) {
            for (int dz = -radius; dz <= radius; dz += 2) {
                int h2 = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, center.m_123341_() + dx, center.m_123343_() + dz);
                totalSlope += (float)Math.abs(h2 - baseHeight);
                ++count;
            }
        }
        return count > 0 ? totalSlope / (float)count : 0.0f;
    }

    private static class ChunkCoordinate {
        final int x;
        final int z;

        ChunkCoordinate(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ChunkCoordinate)) {
                return false;
            }
            ChunkCoordinate coord = (ChunkCoordinate)obj;
            return this.x == coord.x && this.z == coord.z;
        }

        public int hashCode() {
            return this.x * 31 + this.z;
        }
    }

    private static class HeightData {
        final float averageHeight;
        final float maxHeight;
        final float minHeight;
        final float variance;
        final long timestamp;
        final boolean hasComplexTerrain;

        HeightData(float avgHeight, float maxHeight, float minHeight, float variance, boolean complex) {
            this.averageHeight = avgHeight;
            this.maxHeight = maxHeight;
            this.minHeight = minHeight;
            this.variance = variance;
            this.hasComplexTerrain = complex;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 3000L;
        }
    }

    private static class HeightSample {
        final float averageHeight;
        final float maxHeight;
        final float minHeight;
        final float variance;
        final boolean hasWater;
        final boolean hasLava;

        HeightSample(float avg, float max, float min, float variance, boolean water, boolean lava) {
            this.averageHeight = avg;
            this.maxHeight = max;
            this.minHeight = min;
            this.variance = variance;
            this.hasWater = water;
            this.hasLava = lava;
        }
    }
}

