/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.player;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.buildings.neutral.Beacon;
import com.solegendary.reignofnether.building.buildings.placements.BeaconPlacement;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientboundPacket;
import com.solegendary.reignofnether.fogofwar.FogOfWarServerEvents;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.util.Faction;
import java.util.Collections;
import net.minecraft.server.level.ServerPlayer;

public class RTSPlayer {
    public String name;
    public int id;
    public int ticksWithoutCapitol = 0;
    public Faction faction;
    public int beaconOwnerTicks = 0;

    private RTSPlayer(ServerPlayer player, Faction faction) {
        this.name = player.m_7755_().getString();
        this.id = player.m_19879_();
        this.faction = faction;
    }

    private RTSPlayer(String name, Faction faction) {
        ReignOfNether.LOGGER.info("DEBUG: RTSPlayer bot constructor for '{}' with faction {}", (Object)name, (Object)faction);
        int minId = 0;
        if (!PlayerServerEvents.rtsPlayers.isEmpty()) {
            minId = Collections.min(PlayerServerEvents.rtsPlayers.stream().map(r -> r.id).toList());
            ReignOfNether.LOGGER.info("DEBUG: Found minimum existing ID: {}", (Object)minId);
        } else {
            ReignOfNether.LOGGER.info("DEBUG: No existing RTS players, starting with minId=0");
        }
        this.id = minId >= 0 ? -1 : minId - 1;
        this.faction = faction;
        this.name = name;
        ReignOfNether.LOGGER.info("DEBUG: RTSPlayer bot constructor completed - ID: {}, Name: '{}', Faction: {}", (Object)this.id, (Object)this.name, (Object)this.faction);
    }

    private RTSPlayer(String name, int id, int ticksWithoutCapitol, Faction faction, int beaconOwnerTicks) {
        this.name = name;
        this.id = id;
        this.ticksWithoutCapitol = ticksWithoutCapitol;
        this.faction = faction;
        this.beaconOwnerTicks = beaconOwnerTicks;
    }

    public static RTSPlayer getFromSave(String name, int id, int ticksWithoutCapitol, Faction faction, int beaconOwnerTicks) {
        return new RTSPlayer(name, id, ticksWithoutCapitol, faction, beaconOwnerTicks);
    }

    public static RTSPlayer getNewPlayer(ServerPlayer player, Faction faction) {
        return new RTSPlayer(player, faction);
    }

    public static RTSPlayer getNewBot(String name, Faction faction) {
        ReignOfNether.LOGGER.info("DEBUG: RTSPlayer.getNewBot starting for '{}' with faction {}", (Object)name, (Object)faction);
        RTSPlayer player = new RTSPlayer(name, faction);
        ReignOfNether.LOGGER.info("DEBUG: RTSPlayer.getNewBot created with ID: {} for '{}'", (Object)player.id, (Object)name);
        return player;
    }

    public boolean isBot() {
        return this.id < 0;
    }

    public void tick() {
        int numBuildingsOwned = BuildingServerEvents.getBuildings().stream().filter(b -> b.ownerName.equals(this.name)).toList().size();
        int numCapitolsOwned = BuildingServerEvents.getBuildings().stream().filter(b -> b.ownerName.equals(this.name) && b.isCapitol).toList().size();
        if (numBuildingsOwned > 0 && numCapitolsOwned == 0) {
            if (this.ticksWithoutCapitol < 1200) {
                ++this.ticksWithoutCapitol;
                if (this.ticksWithoutCapitol == 1200) {
                    if (FogOfWarServerEvents.isEnabled()) {
                        PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.revealed", false, this.name);
                    }
                    FogOfWarClientboundPacket.revealOrHidePlayer(true, this.name);
                }
            }
        } else {
            this.ticksWithoutCapitol = 0;
        }
        for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
            if (!(building instanceof BeaconPlacement)) continue;
            BeaconPlacement beacon = (BeaconPlacement)building;
            if (!beacon.isBuilt || !building.ownerName.equals(this.name) || beacon.getUpgradeLevel() != 5) continue;
            ++this.beaconOwnerTicks;
            if (this.beaconOwnerTicks != Beacon.getTicksToWin(beacon.getLevel()) / 4 && this.beaconOwnerTicks != Beacon.getTicksToWin(beacon.getLevel()) / 2 && this.beaconOwnerTicks != Beacon.getTicksToWin(beacon.getLevel()) * 3 / 4 && this.beaconOwnerTicks != Beacon.getTicksToWin(beacon.getLevel()) - 1200) continue;
            beacon.sendWarning("time_warning");
        }
    }

    public boolean isRevealed() {
        return this.ticksWithoutCapitol >= 1200;
    }
}

