/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.registrars;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.building.production.dynamic.DynamicProductionItem;
import com.solegendary.reignofnether.building.production.dynamic.DynamicProductionProperties;
import com.solegendary.reignofnether.building.production.dynamic.DynamicProductionRegistry;
import com.solegendary.reignofnether.building.production.dynamic.ProductionType;
import com.solegendary.reignofnether.faction.FactionRegistry;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceRegistry;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceType;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class DefaultProductionRegistrar {
    private static boolean initialized = false;

    public static void initialize() {
        if (initialized) {
            ReignOfNether.LOGGER.warn("DefaultProductionRegistrar already initialized, skipping duplicate initialization");
            return;
        }
        ReignOfNether.LOGGER.info("Initializing default production registrations...");
        DefaultProductionRegistrar.registerVillagerProductions();
        DefaultProductionRegistrar.registerMonsterProductions();
        DefaultProductionRegistrar.registerPiglinProductions();
        initialized = true;
        ReignOfNether.LOGGER.info("Default production registrations completed");
    }

    private static void registerVillagerProductions() {
        FactionType villagers = FactionRegistry.getFaction(new ResourceLocation("reignofnether", "villagers"));
        if (villagers == null) {
            return;
        }
        DynamicResourceType wood = DynamicResourceRegistry.getResourceType(new ResourceLocation("reignofnether", "wood"));
        DynamicResourceType food = DynamicResourceRegistry.getResourceType(new ResourceLocation("reignofnether", "food"));
        DynamicResourceType ore = DynamicResourceRegistry.getResourceType(new ResourceLocation("reignofnether", "ore"));
        DynamicResourceType knowledge = DynamicResourceRegistry.getResourceType(new ResourceLocation("reignofnether", "knowledge"));
        if (wood != null && food != null) {
            DynamicProductionRegistry.register(new DynamicProductionItem(new ResourceLocation("reignofnether", "villager_worker"), "Villager Worker", villagers, ProductionType.UNIT, new ItemStack((ItemLike)Items.f_42601_, 1), Map.of(food, 50, wood, 25), DynamicProductionProperties.builder().productionTime(1200).queueLimit(5).requiresWorkers(false).countsTowardPopulation(true).build(), List.of()));
        }
        if (knowledge != null && ore != null) {
            DynamicProductionRegistry.register(new DynamicProductionItem(new ResourceLocation("reignofnether", "advanced_smithing"), "Advanced Smithing", villagers, ProductionType.RESEARCH, new ItemStack((ItemLike)Items.f_42388_, 1), Map.of(knowledge, 100, ore, 150), DynamicProductionProperties.builder().productionTime(2400).queueLimit(1).requiresWorkers(true).visibleToEnemies(false).build(), List.of()));
        }
        if (wood != null && ore != null) {
            DynamicProductionRegistry.register(new DynamicProductionItem(new ResourceLocation("reignofnether", "iron_armor_set"), "Iron Armor Set", villagers, ProductionType.EQUIPMENT, new ItemStack((ItemLike)Items.f_42469_, 1), Map.of(ore, 80, wood, 20), DynamicProductionProperties.builder().productionTime(800).queueLimit(3).requiresWorkers(true).batchProduction(false).build(), List.of()));
        }
    }

    private static void registerMonsterProductions() {
        FactionType monsters = FactionRegistry.getFaction(new ResourceLocation("reignofnether", "monsters"));
        if (monsters == null) {
            return;
        }
        DynamicResourceType bone = DynamicResourceRegistry.getResourceType(new ResourceLocation("reignofnether", "bone"));
        DynamicResourceType darkness = DynamicResourceRegistry.getResourceType(new ResourceLocation("reignofnether", "darkness"));
        DynamicResourceType slime = DynamicResourceRegistry.getResourceType(new ResourceLocation("reignofnether", "slime"));
        if (bone != null && darkness != null) {
            DynamicProductionRegistry.register(new DynamicProductionItem(new ResourceLocation("reignofnether", "zombie_warrior"), "Zombie Warrior", monsters, ProductionType.UNIT, new ItemStack((ItemLike)Items.f_42608_, 1), Map.of(bone, 30, darkness, 20), DynamicProductionProperties.builder().productionTime(600).queueLimit(10).requiresWorkers(false).countsTowardPopulation(true).build(), List.of()));
        }
        if (darkness != null && bone != null) {
            DynamicProductionRegistry.register(new DynamicProductionItem(new ResourceLocation("reignofnether", "necromancy"), "Necromancy", monsters, ProductionType.RESEARCH, new ItemStack((ItemLike)Items.f_42679_, 1), Map.of(darkness, 200, bone, 100), DynamicProductionProperties.builder().productionTime(3600).queueLimit(1).requiresWorkers(false).visibleToEnemies(false).requiresFactionTech(true).build(), List.of()));
        }
        if (slime != null) {
            DynamicProductionRegistry.register(new DynamicProductionItem(new ResourceLocation("reignofnether", "slime_block"), "Slime Block", monsters, ProductionType.BUILDING, new ItemStack((ItemLike)Items.f_42204_, 4), Map.of(slime, 20), DynamicProductionProperties.builder().productionTime(400).queueLimit(8).requiresWorkers(true).batchProduction(true).batchSize(4).build(), List.of()));
        }
    }

    private static void registerPiglinProductions() {
        FactionType piglins = FactionRegistry.getFaction(new ResourceLocation("reignofnether", "piglins"));
        if (piglins == null) {
            return;
        }
        DynamicResourceType gold = DynamicResourceRegistry.getResourceType(new ResourceLocation("reignofnether", "gold"));
        DynamicResourceType netherWart = DynamicResourceRegistry.getResourceType(new ResourceLocation("reignofnether", "nether_wart"));
        DynamicResourceType soulEnergy = DynamicResourceRegistry.getResourceType(new ResourceLocation("reignofnether", "soul_energy"));
        if (gold != null && soulEnergy != null) {
            DynamicProductionRegistry.register(new DynamicProductionItem(new ResourceLocation("reignofnether", "piglin_brute"), "Piglin Brute", piglins, ProductionType.UNIT, new ItemStack((ItemLike)Items.f_42632_, 1), Map.of(gold, 80, soulEnergy, 40), DynamicProductionProperties.builder().productionTime(1800).queueLimit(3).requiresWorkers(false).countsTowardPopulation(true).build(), List.of()));
        }
        if (netherWart != null && soulEnergy != null) {
            DynamicProductionRegistry.register(new DynamicProductionItem(new ResourceLocation("reignofnether", "nether_wart_harvest"), "Nether Wart Harvest", piglins, ProductionType.RESOURCE_PROCESSING, new ItemStack((ItemLike)Items.f_42588_, 8), Map.of(soulEnergy, 10), DynamicProductionProperties.builder().productionTime(600).queueLimit(5).requiresWorkers(true).batchProduction(true).batchSize(8).renewable(true).build(), List.of()));
        }
        if (gold != null) {
            DynamicProductionRegistry.register(new DynamicProductionItem(new ResourceLocation("reignofnether", "golden_weapons"), "Golden Weapons", piglins, ProductionType.EQUIPMENT, new ItemStack((ItemLike)Items.f_42430_, 1), Map.of(gold, 60), DynamicProductionProperties.builder().productionTime(1000).queueLimit(4).requiresWorkers(true).factionEfficiencyBonus(1.2f).build(), List.of()));
        }
        if (soulEnergy != null && gold != null) {
            DynamicProductionRegistry.register(new DynamicProductionItem(new ResourceLocation("reignofnether", "portal_mastery"), "Portal Mastery", piglins, ProductionType.RESEARCH, new ItemStack((ItemLike)Items.f_41999_, 1), Map.of(soulEnergy, 300, gold, 200), DynamicProductionProperties.builder().productionTime(4800).queueLimit(1).requiresWorkers(false).visibleToEnemies(false).requiresFactionTech(true).build(), List.of()));
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }
}

