/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.registrars;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.faction.FactionRegistry;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceProperties;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceRegistry;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceType;
import com.solegendary.reignofnether.resources.dynamic.ResourceCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;

public class DefaultResourceRegistrar {
    private static boolean initialized = false;

    public static void initialize() {
        if (initialized) {
            ReignOfNether.LOGGER.warn("DefaultResourceRegistrar already initialized, skipping duplicate initialization");
            return;
        }
        ReignOfNether.LOGGER.info("Initializing default resource registrations...");
        DefaultResourceRegistrar.registerUniversalResources();
        DefaultResourceRegistrar.registerVillagerResources();
        DefaultResourceRegistrar.registerMonsterResources();
        DefaultResourceRegistrar.registerPiglinResources();
        initialized = true;
        ReignOfNether.LOGGER.info("Default resource registrations completed");
    }

    private static void registerUniversalResources() {
        DynamicResourceRegistry.register(new DynamicResourceType(new ResourceLocation("reignofnether", "wood"), "Wood", Items.f_41837_, null, ResourceCategory.BASIC, DynamicResourceProperties.builder().baseValue(10).tradeable(true).renewable(true).requiresWorkers(true).visibleToEnemies(true).stackSize(64).build()));
        DynamicResourceRegistry.register(new DynamicResourceType(new ResourceLocation("reignofnether", "food"), "Food", Items.f_42406_, null, ResourceCategory.BASIC, DynamicResourceProperties.builder().baseValue(5).tradeable(true).renewable(true).requiresWorkers(true).visibleToEnemies(true).stackSize(64).build()));
        DynamicResourceRegistry.register(new DynamicResourceType(new ResourceLocation("reignofnether", "ore"), "Ore", Items.f_42416_, null, ResourceCategory.ADVANCED, DynamicResourceProperties.builder().baseValue(20).tradeable(true).renewable(false).requiresWorkers(true).visibleToEnemies(true).stackSize(64).build()));
    }

    private static void registerVillagerResources() {
        FactionType villagers = FactionRegistry.getFaction(new ResourceLocation("reignofnether", "villagers"));
        if (villagers == null) {
            return;
        }
        DynamicResourceRegistry.register(new DynamicResourceType(new ResourceLocation("reignofnether", "emerald"), "Emerald", Items.f_42616_, villagers, ResourceCategory.ADVANCED, DynamicResourceProperties.builder().baseValue(50).tradeable(true).renewable(false).requiresWorkers(false).visibleToEnemies(true).stackSize(64).build()));
        DynamicResourceRegistry.register(new DynamicResourceType(new ResourceLocation("reignofnether", "knowledge"), "Knowledge", Items.f_42517_, villagers, ResourceCategory.ENERGY, DynamicResourceProperties.builder().baseValue(30).tradeable(false).renewable(true).requiresWorkers(true).visibleToEnemies(false).stackSize(16).build()));
    }

    private static void registerMonsterResources() {
        FactionType monsters = FactionRegistry.getFaction(new ResourceLocation("reignofnether", "monsters"));
        if (monsters == null) {
            return;
        }
        DynamicResourceRegistry.register(new DynamicResourceType(new ResourceLocation("reignofnether", "bone"), "Bone", Items.f_42500_, monsters, ResourceCategory.BASIC, DynamicResourceProperties.builder().baseValue(8).tradeable(true).renewable(true).requiresWorkers(false).visibleToEnemies(true).stackSize(64).build()));
        DynamicResourceRegistry.register(new DynamicResourceType(new ResourceLocation("reignofnether", "darkness"), "Darkness", Items.f_42413_, monsters, ResourceCategory.ENERGY, DynamicResourceProperties.builder().baseValue(25).tradeable(false).renewable(true).requiresWorkers(false).visibleToEnemies(false).stackSize(16).build()));
        DynamicResourceRegistry.register(new DynamicResourceType(new ResourceLocation("reignofnether", "slime"), "Slime", Items.f_42518_, monsters, ResourceCategory.SPECIAL, DynamicResourceProperties.builder().baseValue(15).tradeable(true).renewable(true).requiresWorkers(true).visibleToEnemies(true).stackSize(64).build()));
    }

    private static void registerPiglinResources() {
        FactionType piglins = FactionRegistry.getFaction(new ResourceLocation("reignofnether", "piglins"));
        if (piglins == null) {
            return;
        }
        DynamicResourceRegistry.register(new DynamicResourceType(new ResourceLocation("reignofnether", "gold"), "Gold", Items.f_42417_, piglins, ResourceCategory.ADVANCED, DynamicResourceProperties.builder().baseValue(40).tradeable(true).renewable(false).requiresWorkers(true).visibleToEnemies(true).stackSize(64).build()));
        DynamicResourceRegistry.register(new DynamicResourceType(new ResourceLocation("reignofnether", "nether_wart"), "Nether Wart", Items.f_42588_, piglins, ResourceCategory.BASIC, DynamicResourceProperties.builder().baseValue(12).tradeable(true).renewable(true).requiresWorkers(true).visibleToEnemies(true).stackSize(64).build()));
        DynamicResourceRegistry.register(new DynamicResourceType(new ResourceLocation("reignofnether", "soul_energy"), "Soul Energy", Items.f_42049_, piglins, ResourceCategory.ENERGY, DynamicResourceProperties.builder().baseValue(35).tradeable(false).renewable(true).requiresWorkers(false).visibleToEnemies(false).stackSize(16).build()));
    }

    public static boolean isInitialized() {
        return initialized;
    }
}

