/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.registrars;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.faction.FactionRegistry;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.UnitProperties;
import com.solegendary.reignofnether.unit.UnitRegistry;
import com.solegendary.reignofnether.unit.UnitType;
import com.solegendary.reignofnether.unit.units.monsters.CreeperUnit;
import com.solegendary.reignofnether.unit.units.monsters.DrownedUnit;
import com.solegendary.reignofnether.unit.units.monsters.HuskUnit;
import com.solegendary.reignofnether.unit.units.monsters.NecromancerUnit;
import com.solegendary.reignofnether.unit.units.monsters.SilverfishUnit;
import com.solegendary.reignofnether.unit.units.monsters.SkeletonUnit;
import com.solegendary.reignofnether.unit.units.monsters.SlimeUnit;
import com.solegendary.reignofnether.unit.units.monsters.SpiderUnit;
import com.solegendary.reignofnether.unit.units.monsters.StrayUnit;
import com.solegendary.reignofnether.unit.units.monsters.WardenUnit;
import com.solegendary.reignofnether.unit.units.monsters.ZoglinUnit;
import com.solegendary.reignofnether.unit.units.monsters.ZombiePiglinUnit;
import com.solegendary.reignofnether.unit.units.monsters.ZombieUnit;
import com.solegendary.reignofnether.unit.units.monsters.ZombieVillagerUnit;
import com.solegendary.reignofnether.unit.units.neutral.EndermanUnit;
import com.solegendary.reignofnether.unit.units.neutral.GrizzlyBearUnit;
import com.solegendary.reignofnether.unit.units.neutral.KillerRabbitUnit;
import com.solegendary.reignofnether.unit.units.neutral.LlamaUnit;
import com.solegendary.reignofnether.unit.units.neutral.PandaUnit;
import com.solegendary.reignofnether.unit.units.neutral.PolarBearUnit;
import com.solegendary.reignofnether.unit.units.neutral.WolfUnit;
import com.solegendary.reignofnether.unit.units.piglins.BlazeUnit;
import com.solegendary.reignofnether.unit.units.piglins.BruteUnit;
import com.solegendary.reignofnether.unit.units.piglins.GhastUnit;
import com.solegendary.reignofnether.unit.units.piglins.GruntUnit;
import com.solegendary.reignofnether.unit.units.piglins.HeadhunterUnit;
import com.solegendary.reignofnether.unit.units.piglins.HoglinUnit;
import com.solegendary.reignofnether.unit.units.piglins.MagmaCubeUnit;
import com.solegendary.reignofnether.unit.units.piglins.PiglinMerchantUnit;
import com.solegendary.reignofnether.unit.units.piglins.WitherSkeletonUnit;
import com.solegendary.reignofnether.unit.units.villagers.EvokerUnit;
import com.solegendary.reignofnether.unit.units.villagers.IronGolemUnit;
import com.solegendary.reignofnether.unit.units.villagers.MilitiaUnit;
import com.solegendary.reignofnether.unit.units.villagers.PillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.RavagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.RoyalGuardUnit;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VindicatorUnit;
import com.solegendary.reignofnether.unit.units.villagers.WitchUnit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class DynamicEntityRegistrar {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"reignofnether");
    private static final int UNIT_CLIENT_TRACKING_RANGE = 100;
    private static final List<UnitRegistration<?>> pendingRegistrations = new ArrayList();

    public static void initialize() {
        ReignOfNether.LOGGER.info("Initializing dynamic entity registration system...");
        FactionRegistry.initializeDefaultFactions();
        DynamicEntityRegistrar.registerDefaultUnits();
        ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        ReignOfNether.LOGGER.info("Dynamic entity registration system initialized");
    }

    private static void registerDefaultUnits() {
        ReignOfNether.LOGGER.info("Registering default units...");
        FactionType villagers = FactionRegistry.getVillagers();
        FactionType monsters = FactionRegistry.getMonsters();
        FactionType piglins = FactionRegistry.getPiglins();
        FactionType none = FactionRegistry.getNone();
        DynamicEntityRegistrar.registerUnit("villager_unit", "Villager", VillagerUnit.class, villagers, ResourceCosts.VILLAGER, UnitProperties.builder().worker(true).populationProvided(1).build());
        DynamicEntityRegistrar.registerUnit("militia_unit", "Militia", MilitiaUnit.class, villagers, ResourceCosts.MILITIA, UnitProperties.builder().attacker(true).build());
        DynamicEntityRegistrar.registerUnit("vindicator_unit", "Vindicator", VindicatorUnit.class, villagers, ResourceCosts.VINDICATOR, UnitProperties.builder().attacker(true).build());
        DynamicEntityRegistrar.registerUnit("pillager_unit", "Pillager", PillagerUnit.class, villagers, ResourceCosts.PILLAGER, UnitProperties.builder().attacker(true).ranged(true).attackRange(8).build());
        DynamicEntityRegistrar.registerUnit("iron_golem_unit", "Iron Golem", IronGolemUnit.class, villagers, ResourceCosts.IRON_GOLEM, UnitProperties.builder().attacker(true).populationCost(2).canClimbLadders(false).build());
        DynamicEntityRegistrar.registerUnit("witch_unit", "Witch", WitchUnit.class, villagers, ResourceCosts.WITCH, UnitProperties.builder().attacker(true).ranged(true).hasSpecialAbilities(true).build());
        DynamicEntityRegistrar.registerUnit("evoker_unit", "Evoker", EvokerUnit.class, villagers, ResourceCosts.EVOKER, UnitProperties.builder().attacker(true).ranged(true).hasSpecialAbilities(true).build());
        DynamicEntityRegistrar.registerUnit("ravager_unit", "Ravager", RavagerUnit.class, villagers, ResourceCosts.RAVAGER, UnitProperties.builder().attacker(true).populationCost(3).canClimbLadders(false).canDestroyTerrain(true).build());
        DynamicEntityRegistrar.registerUnit("royal_guard_unit", "Royal Guard", RoyalGuardUnit.class, villagers, ResourceCosts.ROYAL_GUARD, UnitProperties.builder().hero(true).attacker(true).canBeRevived(true).hasSpecialAbilities(true).build());
        DynamicEntityRegistrar.registerUnit("zombie_unit", "Zombie", ZombieUnit.class, monsters, ResourceCosts.ZOMBIE, UnitProperties.builder().attacker(true).build());
        DynamicEntityRegistrar.registerUnit("zombie_villager_unit", "Zombie Villager", ZombieVillagerUnit.class, monsters, ResourceCosts.ZOMBIE_VILLAGER, UnitProperties.builder().attacker(true).build());
        DynamicEntityRegistrar.registerUnit("husk_unit", "Husk", HuskUnit.class, monsters, ResourceCosts.HUSK, UnitProperties.builder().attacker(true).build());
        DynamicEntityRegistrar.registerUnit("drowned_unit", "Drowned", DrownedUnit.class, monsters, ResourceCosts.DROWNED, UnitProperties.builder().attacker(true).ranged(true).canSwim(true).build());
        DynamicEntityRegistrar.registerUnit("skeleton_unit", "Skeleton", SkeletonUnit.class, monsters, ResourceCosts.SKELETON, UnitProperties.builder().attacker(true).ranged(true).attackRange(15).build());
        DynamicEntityRegistrar.registerUnit("stray_unit", "Stray", StrayUnit.class, monsters, ResourceCosts.STRAY, UnitProperties.builder().attacker(true).ranged(true).attackRange(15).build());
        DynamicEntityRegistrar.registerUnit("spider_unit", "Spider", SpiderUnit.class, monsters, ResourceCosts.SPIDER, UnitProperties.builder().attacker(true).canClimbLadders(false).build());
        DynamicEntityRegistrar.registerUnit("creeper_unit", "Creeper", CreeperUnit.class, monsters, ResourceCosts.CREEPER, UnitProperties.builder().attacker(true).hasSpecialAbilities(true).build());
        DynamicEntityRegistrar.registerUnit("slime_unit", "Slime", SlimeUnit.class, monsters, ResourceCosts.SLIME, UnitProperties.builder().attacker(true).canClimbLadders(false).build());
        DynamicEntityRegistrar.registerUnit("silverfish_unit", "Silverfish", SilverfishUnit.class, monsters, ResourceCosts.ZOMBIE, UnitProperties.builder().attacker(true).moveSpeedMultiplier(1.3f).build());
        DynamicEntityRegistrar.registerUnit("warden_unit", "Warden", WardenUnit.class, monsters, ResourceCosts.WARDEN, UnitProperties.builder().attacker(true).populationCost(4).hasSpecialAbilities(true).canClimbLadders(false).build());
        DynamicEntityRegistrar.registerUnit("necromancer_unit", "Necromancer", NecromancerUnit.class, monsters, ResourceCosts.NECROMANCER, UnitProperties.builder().hero(true).attacker(true).ranged(true).canBeRevived(true).hasSpecialAbilities(true).build());
        DynamicEntityRegistrar.registerUnit("grunt_unit", "Grunt", GruntUnit.class, piglins, ResourceCosts.GRUNT, UnitProperties.builder().worker(true).attacker(true).build());
        DynamicEntityRegistrar.registerUnit("brute_unit", "Brute", BruteUnit.class, piglins, ResourceCosts.BRUTE, UnitProperties.builder().attacker(true).populationCost(2).hasSpecialAbilities(true).build());
        DynamicEntityRegistrar.registerUnit("headhunter_unit", "Headhunter", HeadhunterUnit.class, piglins, ResourceCosts.HEADHUNTER, UnitProperties.builder().attacker(true).ranged(true).attackRange(10).build());
        DynamicEntityRegistrar.registerUnit("hoglin_unit", "Hoglin", HoglinUnit.class, piglins, ResourceCosts.HOGLIN, UnitProperties.builder().attacker(true).populationCost(2).canMount(true).build());
        DynamicEntityRegistrar.registerUnit("blaze_unit", "Blaze", BlazeUnit.class, piglins, ResourceCosts.BLAZE, UnitProperties.builder().attacker(true).ranged(true).flying(true).hasSpecialAbilities(true).build());
        DynamicEntityRegistrar.registerUnit("wither_skeleton_unit", "Wither Skeleton", WitherSkeletonUnit.class, piglins, ResourceCosts.WITHER_SKELETON, UnitProperties.builder().attacker(true).build());
        DynamicEntityRegistrar.registerUnit("magma_cube_unit", "Magma Cube", MagmaCubeUnit.class, piglins, ResourceCosts.MAGMA_CUBE, UnitProperties.builder().attacker(true).canClimbLadders(false).build());
        DynamicEntityRegistrar.registerUnit("ghast_unit", "Ghast", GhastUnit.class, piglins, ResourceCosts.GHAST, UnitProperties.builder().attacker(true).ranged(true).flying(true).populationCost(3).canClimbLadders(false).build());
        DynamicEntityRegistrar.registerUnit("zombie_piglin_unit", "Zombie Piglin", ZombiePiglinUnit.class, piglins, ResourceCosts.ZOMBIE_PIGLIN, UnitProperties.builder().attacker(true).build());
        DynamicEntityRegistrar.registerUnit("zoglin_unit", "Zoglin", ZoglinUnit.class, piglins, ResourceCosts.ZOGLIN, UnitProperties.builder().attacker(true).populationCost(2).build());
        DynamicEntityRegistrar.registerUnit("piglin_merchant_unit", "Piglin Merchant", PiglinMerchantUnit.class, piglins, ResourceCosts.PIGLIN_MERCHANT, UnitProperties.builder().hero(true).worker(true).canBeRevived(true).hasSpecialAbilities(true).build());
        DynamicEntityRegistrar.registerUnit("enderman_unit", "Enderman", EndermanUnit.class, none, ResourceCosts.ENDERMAN, UnitProperties.builder().attacker(true).hasSpecialAbilities(true).build());
        DynamicEntityRegistrar.registerUnit("polar_bear_unit", "Polar Bear", PolarBearUnit.class, none, ResourceCosts.POLAR_BEAR, UnitProperties.builder().attacker(true).build());
        DynamicEntityRegistrar.registerUnit("grizzly_bear_unit", "Grizzly Bear", GrizzlyBearUnit.class, none, ResourceCosts.GRIZZLY_BEAR, UnitProperties.builder().attacker(true).build());
        DynamicEntityRegistrar.registerUnit("panda_unit", "Panda", PandaUnit.class, none, ResourceCosts.PANDA, UnitProperties.builder().attacker(true).build());
        DynamicEntityRegistrar.registerUnit("wolf_unit", "Wolf", WolfUnit.class, none, ResourceCosts.WOLF, UnitProperties.builder().attacker(true).build());
        DynamicEntityRegistrar.registerUnit("killer_rabbit_unit", "Killer Rabbit", KillerRabbitUnit.class, none, ResourceCosts.ZOMBIE, UnitProperties.builder().attacker(true).moveSpeedMultiplier(1.5f).build());
        DynamicEntityRegistrar.registerUnit("llama_unit", "Llama", LlamaUnit.class, none, ResourceCosts.LLAMA, UnitProperties.builder().attacker(true).ranged(true).build());
        ReignOfNether.LOGGER.info("Registered {} default units", (Object)pendingRegistrations.size());
    }

    public static <T extends LivingEntity> void registerUnit(String name, String displayName, Class<T> unitClass, FactionType faction, Object cost, UnitProperties properties) {
        ResourceLocation id = new ResourceLocation("reignofnether", name);
        RegistryObject entityTypeRegistry = ENTITIES.register(name, () -> {
            EntityType<?> baseType = DynamicEntityRegistrar.getBaseEntityType(unitClass);
            return EntityType.Builder.m_20704_((entityType, level) -> {
                try {
                    return (LivingEntity)unitClass.getConstructor(EntityType.class, Level.class).newInstance(entityType, level);
                }
                catch (Exception e) {
                    ReignOfNether.LOGGER.error("Failed to create unit instance for {}: {}", (Object)name, (Object)e.getMessage());
                    return null;
                }
            }, (MobCategory)MobCategory.CREATURE).m_20699_(baseType.m_20678_(), baseType.m_20679_()).m_20702_(100).m_20712_(id.toString());
        });
        UnitType unitType = new UnitType(id, displayName, () -> ((RegistryObject)entityTypeRegistry).get(), faction, cost instanceof ResourceCost ? (ResourceCost)cost : null, properties, unitClass);
        pendingRegistrations.add(new UnitRegistration(unitType, entityTypeRegistry));
    }

    public static void completeRegistrations() {
        ReignOfNether.LOGGER.info("Completing unit registrations...");
        for (UnitRegistration<?> registration : pendingRegistrations) {
            UnitRegistry.register(registration.unitType);
        }
        pendingRegistrations.clear();
        ReignOfNether.LOGGER.info("Unit registrations completed");
    }

    private static EntityType<?> getBaseEntityType(Class<?> unitClass) {
        if (ZombieUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20501_;
        }
        if (SkeletonUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20524_;
        }
        if (SpiderUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20479_;
        }
        if (CreeperUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20558_;
        }
        if (SlimeUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20526_;
        }
        if (VillagerUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20492_;
        }
        if (VindicatorUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20493_;
        }
        if (PillagerUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20513_;
        }
        if (IronGolemUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20460_;
        }
        if (WitchUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20495_;
        }
        if (EvokerUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20568_;
        }
        if (RavagerUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20518_;
        }
        if (GruntUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20511_;
        }
        if (BruteUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20512_;
        }
        if (HoglinUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20456_;
        }
        if (BlazeUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20551_;
        }
        if (WitherSkeletonUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20497_;
        }
        if (MagmaCubeUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20468_;
        }
        if (GhastUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20453_;
        }
        if (EndermanUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20566_;
        }
        if (PolarBearUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20514_;
        }
        if (PandaUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20507_;
        }
        if (WolfUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20499_;
        }
        if (LlamaUnit.class.isAssignableFrom(unitClass)) {
            return EntityType.f_20466_;
        }
        return EntityType.f_20501_;
    }

    private static class UnitRegistration<T extends LivingEntity> {
        final UnitType<T> unitType;
        final RegistryObject<EntityType<T>> entityTypeRegistry;

        UnitRegistration(UnitType<T> unitType, RegistryObject<EntityType<T>> entityTypeRegistry) {
            this.unitType = unitType;
            this.entityTypeRegistry = entityTypeRegistry;
        }
    }

    public static class DynamicUnitRegistrationEvent
    extends Event {
        public <T extends LivingEntity> void registerUnit(String name, String displayName, Class<T> unitClass, FactionType faction, Object cost, UnitProperties properties) {
            DynamicEntityRegistrar.registerUnit(name, displayName, unitClass, faction, cost, properties);
        }
    }
}

