/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.research.researchItems;

import com.solegendary.reignofnether.building.BuildingClientboundPacket;
import com.solegendary.reignofnether.building.BuildingServerboundPacket;
import com.solegendary.reignofnether.building.buildings.placements.PortalPlacement;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ProductionItem;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ResearchPortalForMilitary
extends ProductionItem {
    public static final String itemName = "Military Portal";
    public static final ResourceCost cost = ResourceCosts.RESEARCH_MILITARY_PORTAL;

    public ResearchPortalForMilitary() {
        super(cost);
        this.onComplete = (level, placement) -> {
            if (placement instanceof PortalPlacement) {
                PortalPlacement portal = (PortalPlacement)placement;
                if (!level.m_5776_()) {
                    portal.changeStructure(PortalPlacement.PortalType.MILITARY);
                    BuildingClientboundPacket.changePortal(placement.originPos, PortalPlacement.PortalType.MILITARY);
                }
            }
        };
    }

    @Override
    public String getItemName() {
        return itemName;
    }

    @Override
    public Button getStartButton(ProductionPlacement prodBuilding, Keybinding hotkey) {
        return new Button(itemName, 14, new ResourceLocation("minecraft", "textures/block/red_glazed_terracotta.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame_bronze.png"), hotkey, () -> false, () -> {
            PortalPlacement portal;
            return prodBuilding.productionQueue.size() > 0 || prodBuilding instanceof PortalPlacement && (portal = (PortalPlacement)prodBuilding).getUpgradeLevel() > 0;
        }, () -> true, () -> {
            if (prodBuilding.productionQueue.isEmpty()) {
                BuildingServerboundPacket.startProduction(prodBuilding.originPos, ProductionItems.RESEARCH_PORTAL_FOR_MILITARY);
            }
        }, null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.military_portal", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedTime(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.military_portal.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.military_portal.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)));
    }

    @Override
    public Button getCancelButton(ProductionPlacement prodBuilding, boolean first) {
        return new Button(itemName, 14, new ResourceLocation("minecraft", "textures/block/red_glazed_terracotta.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame_bronze.png"), null, () -> false, () -> false, () -> true, () -> BuildingServerboundPacket.cancelProduction(prodBuilding.minCorner, ProductionItems.RESEARCH_PORTAL_FOR_MILITARY, first), null, null);
    }
}

