/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.resources;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ActiveProduction;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.registrars.BlockRegistrar;
import com.solegendary.reignofnether.registrars.GameRuleRegistrar;
import com.solegendary.reignofnether.resources.BlockUtils;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientboundPacket;
import com.solegendary.reignofnether.resources.ResourcesSaveData;
import com.solegendary.reignofnether.sandbox.SandboxServer;
import com.solegendary.reignofnether.tutorial.TutorialServerEvents;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ResourcesServerEvents {
    public static ArrayList<Resources> resourcesList = new ArrayList();
    public static final int STARTING_FOOD_TUTORIAL = 750;
    public static final int STARTING_WOOD_TUTORIAL = 850;
    public static final int STARTING_ORE_TUTORIAL = 250;
    public static final int STARTING_FOOD_SANDBOX = 999999;
    public static final int STARTING_WOOD_SANDBOX = 999999;
    public static final int STARTING_ORE_SANDBOX = 999999;
    public static final int STARTING_FOOD = 100;
    public static final int STARTING_WOOD = 450;
    public static final int STARTING_ORE = 250;
    public static final float NEUTRAL_UNIT_BOUNTY_PERCENT = 0.25f;
    public static final float NEUTRAL_BUILDING_BOUNTY_PERCENT = 0.25f;
    private static final int SAVE_TICKS_MAX = 600;
    private static int saveTicks = 0;
    private static final Random random = new Random();
    private static final Map<Block, Block> FALLING_LOGS = new HashMap<Block, Block>();

    public static void saveResources(ServerLevel serverLevel) {
        if (serverLevel == null) {
            return;
        }
        ResourcesSaveData data = ResourcesSaveData.getInstance((LevelAccessor)serverLevel);
        data.resources.clear();
        resourcesList.forEach(r -> {
            int unitFood = 0;
            int unitWood = 0;
            int unitOre = 0;
            for (LivingEntity le : UnitServerEvents.getAllUnits()) {
                Unit u;
                if (!(le instanceof Unit) || !(u = (Unit)le).getOwnerName().equals(r.ownerName)) continue;
                Resources unitRes = Resources.getTotalResourcesFromItems(u.getItems());
                unitFood += unitRes.food;
                unitWood += unitRes.wood;
                unitOre += unitRes.ore;
            }
            int prodFood = 0;
            int prodWood = 0;
            int prodOre = 0;
            for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
                if (!(building instanceof ProductionPlacement)) continue;
                ProductionPlacement pBuilding = (ProductionPlacement)building;
                for (ActiveProduction item : pBuilding.productionQueue) {
                    prodFood += item.item.getCost((boolean)false, (String)pBuilding.ownerName).food;
                    prodWood += item.item.getCost((boolean)false, (String)pBuilding.ownerName).wood;
                    prodOre += item.item.getCost((boolean)false, (String)pBuilding.ownerName).ore;
                }
            }
            data.resources.add(new Resources(r.ownerName, r.food + r.foodToAdd + unitFood + prodFood, r.wood + r.woodToAdd + unitWood + prodWood, r.ore + r.oreToAdd + unitOre + prodOre));
        });
        data.save();
        serverLevel.m_8895_().m_78151_();
    }

    @SubscribeEvent
    public static void loadResources(ServerStartedEvent evt) {
        ServerLevel level = evt.getServer().m_129880_(Level.f_46428_);
        if (level != null) {
            ResourcesSaveData data = ResourcesSaveData.getInstance((LevelAccessor)level);
            resourcesList.clear();
            resourcesList.addAll(data.resources);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent evt) {
        ServerLevel level;
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (++saveTicks >= 600 && (level = evt.getServer().m_129880_(Level.f_46428_)) != null) {
            ResourcesServerEvents.saveResources(level);
            saveTicks = 0;
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent evt) {
        ServerLevel level = evt.getServer().m_129880_(Level.f_46428_);
        if (level != null) {
            ResourcesServerEvents.saveResources(level);
        }
    }

    public static void resetResources(String playerName) {
        for (Resources resources : resourcesList) {
            if (!resources.ownerName.equals(playerName)) continue;
            if (TutorialServerEvents.isEnabled()) {
                resources.food = 750;
                resources.wood = 850;
                resources.ore = 250;
            } else if (SandboxServer.isSandboxPlayer(playerName)) {
                resources.food = 999999;
                resources.wood = 999999;
                resources.ore = 999999;
            } else {
                resources.food = 100;
                resources.wood = 450;
                resources.ore = 250;
            }
            ResourcesClientboundPacket.syncResources(resourcesList);
            break;
        }
    }

    public static void addSubtractResources(Resources resourcesToAdd) {
        for (Resources resources : resourcesList) {
            if (!resources.ownerName.equals(resourcesToAdd.ownerName)) continue;
            resources.changeInstantly(resourcesToAdd.food, resourcesToAdd.wood, resourcesToAdd.ore);
            ResourcesClientboundPacket.addSubtractResources(new Resources(resourcesToAdd.ownerName, resourcesToAdd.food, resourcesToAdd.wood, resourcesToAdd.ore));
        }
    }

    public static boolean canAfford(String ownerName, ResourceName resourceName, int cost) {
        if (cost <= 0) {
            return true;
        }
        for (Resources resources : resourcesList) {
            if (!resources.ownerName.equals(ownerName)) continue;
            switch (resourceName) {
                case FOOD: {
                    return resources.food >= cost;
                }
                case WOOD: {
                    return resources.wood >= cost;
                }
                case ORE: {
                    return resources.ore >= cost;
                }
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        String playerName = evt.getEntity().m_7755_().getString();
        ResourcesClientboundPacket.syncResources(resourcesList);
    }

    public static void assignResources(String playerName) {
        Resources resources;
        ReignOfNether.LOGGER.info("DEBUG: ResourcesServerEvents.assignResources starting for '{}'", (Object)playerName);
        ReignOfNether.LOGGER.info("DEBUG: Current resourcesList size: {}", (Object)resourcesList.size());
        resourcesList.removeIf(r -> r.ownerName.equals(playerName));
        ReignOfNether.LOGGER.info("DEBUG: Removed existing resources for '{}', new size: {}", (Object)playerName, (Object)resourcesList.size());
        if (TutorialServerEvents.isEnabled()) {
            resources = new Resources(playerName, 750, 850, 250);
            ReignOfNether.LOGGER.info("DEBUG: Created tutorial resources for '{}'", (Object)playerName);
        } else {
            resources = new Resources(playerName, 100, 450, 250);
            ReignOfNether.LOGGER.info("DEBUG: Created standard resources for '{}'", (Object)playerName);
        }
        resourcesList.add(resources);
        ReignOfNether.LOGGER.info("DEBUG: Added resources for '{}', final size: {}", (Object)playerName, (Object)resourcesList.size());
        ReignOfNether.LOGGER.info("DEBUG: Resources for '{}': Food={}, Wood={}, Ore={}", (Object)playerName, (Object)resources.food, (Object)resources.wood, (Object)resources.ore);
        ResourcesClientboundPacket.syncResources(resourcesList);
        ReignOfNether.LOGGER.info("DEBUG: Resources synced to clients for '{}'", (Object)playerName);
    }

    @SubscribeEvent
    public static void onCropGrow(BlockEvent.CropGrowEvent.Pre evt) {
        if (BuildingUtils.isPosInsideAnyBuilding(evt.getLevel().m_5776_(), evt.getPos())) {
            evt.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onPlayerBlockBreak(BlockEvent.BreakEvent evt) {
        if (BuildingUtils.isPosInsideAnyBuilding(false, evt.getPos())) {
            evt.setCanceled(true);
            LevelAccessor levelAccessor = evt.getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)levelAccessor;
                serverLevel.m_46597_(evt.getPos(), Blocks.f_50016_.m_49966_());
            }
        }
        if (BlockUtils.isLogBlock(evt.getState()) && !BuildingUtils.isPosInsideAnyBuilding(false, evt.getPos())) {
            ResourcesServerEvents.fellAdjacentLogs(evt.getPos(), new ArrayList<BlockPos>(), (Level)evt.getLevel());
        }
    }

    public static void fellAdjacentLogs(BlockPos bp, ArrayList<BlockPos> bpsExcluded, Level level) {
        if (!((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRuleRegistrar.LOG_FALLING)).m_46223_()) {
            return;
        }
        BlockState bs = level.m_8055_(bp);
        List<BlockPos> bpsAdj = List.of(bp.m_122012_(), bp.m_122019_(), bp.m_122029_(), bp.m_122024_(), bp.m_7494_(), bp.m_7494_().m_122012_(), bp.m_7494_().m_122019_(), bp.m_7494_().m_122029_(), bp.m_7494_().m_122024_(), bp.m_122012_().m_122029_(), bp.m_122012_().m_122024_(), bp.m_122019_().m_122029_(), bp.m_122019_().m_122024_(), bp.m_7494_().m_122012_().m_122029_(), bp.m_7494_().m_122012_().m_122024_(), bp.m_7494_().m_122019_().m_122029_(), bp.m_7494_().m_122019_().m_122024_());
        for (BlockPos bpAdj : bpsAdj) {
            BlockState bsAdj = level.m_8055_(bpAdj);
            if (!BlockUtils.isLogBlock(bsAdj) || bpsExcluded.contains(bpAdj)) continue;
            Block fallingLogBlock = FALLING_LOGS.get(bsAdj.m_60734_());
            if (fallingLogBlock != null && !BuildingUtils.isPosInsideAnyBuilding(level.m_5776_(), bpAdj)) {
                if (bsAdj.m_61138_((Property)BlockStateProperties.f_61365_)) {
                    level.m_46597_(bpAdj, (BlockState)fallingLogBlock.m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)((Direction.Axis)bsAdj.m_61143_((Property)BlockStateProperties.f_61365_))));
                } else {
                    level.m_46597_(bpAdj, fallingLogBlock.m_49966_());
                }
                bpsExcluded.add(bpAdj);
                ResourcesServerEvents.fellAdjacentLogs(bpAdj, bpsExcluded, level);
            }
            bpsExcluded.add(bpAdj);
            ResourcesServerEvents.fellAdjacentLogs(bpAdj, bpsExcluded, level);
        }
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterCommandsEvent evt) {
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"sendfood").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(command -> ResourcesServerEvents.trySendingResources((CommandContext<CommandSourceStack>)command, ResourceName.FOOD)))));
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"sendwood").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(command -> ResourcesServerEvents.trySendingResources((CommandContext<CommandSourceStack>)command, ResourceName.WOOD)))));
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"sendore").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(command -> ResourcesServerEvents.trySendingResources((CommandContext<CommandSourceStack>)command, ResourceName.ORE)))));
    }

    public static int trySendingResources(CommandContext<CommandSourceStack> context, ResourceName resourceName) throws CommandSyntaxException {
        ServerPlayer sendingPlayer = ((CommandSourceStack)context.getSource()).m_230896_();
        ServerPlayer receivingPlayer = EntityArgument.m_91474_(context, (String)"player");
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        if (sendingPlayer == null) {
            return 0;
        }
        String sendingPlayerName = sendingPlayer.m_7755_().getString();
        String receivingPlayerName = receivingPlayer.m_7755_().getString();
        Resources res = null;
        for (Resources resources : resourcesList) {
            if (!resources.ownerName.equals(sendingPlayer.m_7755_().getString())) continue;
            res = resources;
        }
        if (res == null) {
            return 0;
        }
        if (sendingPlayerName.equals(receivingPlayerName)) {
            PlayerServerEvents.sendMessageToPlayer(sendingPlayerName, "server.resources.reignofnether.sending_to_self");
            return 0;
        }
        if (!PlayerServerEvents.isRTSPlayer(receivingPlayerName)) {
            PlayerServerEvents.sendMessageToPlayer(sendingPlayerName, "server.resources.reignofnether.not_rts_player");
            return 0;
        }
        if (!ResourcesServerEvents.canAfford(sendingPlayerName, resourceName, amount)) {
            ResourcesClientboundPacket.warnInsufficientResources(sendingPlayerName, resourceName == ResourceName.FOOD, resourceName == ResourceName.WOOD, resourceName == ResourceName.ORE);
            return 0;
        }
        ResourcesServerEvents.addSubtractResources(new Resources(sendingPlayerName, resourceName == ResourceName.FOOD ? -amount : 0, resourceName == ResourceName.WOOD ? -amount : 0, resourceName == ResourceName.ORE ? -amount : 0));
        ResourcesServerEvents.addSubtractResources(new Resources(receivingPlayerName, resourceName == ResourceName.FOOD ? amount : 0, resourceName == ResourceName.WOOD ? amount : 0, resourceName == ResourceName.ORE ? amount : 0));
        switch (resourceName) {
            case FOOD: {
                PlayerServerEvents.sendMessageToPlayer(sendingPlayerName, "server.resources.reignofnether.sent_food", false, amount, receivingPlayerName);
                PlayerServerEvents.sendMessageToPlayer(receivingPlayerName, "server.resources.reignofnether.received_food", false, amount, sendingPlayerName);
                break;
            }
            case WOOD: {
                PlayerServerEvents.sendMessageToPlayer(sendingPlayerName, "server.resources.reignofnether.sent_wood", false, amount, receivingPlayerName);
                PlayerServerEvents.sendMessageToPlayer(receivingPlayerName, "server.resources.reignofnether.received_wood", false, amount, sendingPlayerName);
                break;
            }
            case ORE: {
                PlayerServerEvents.sendMessageToPlayer(sendingPlayerName, "server.resources.reignofnether.sent_ore", false, amount, receivingPlayerName);
                PlayerServerEvents.sendMessageToPlayer(receivingPlayerName, "server.resources.reignofnether.received_ore", false, amount, sendingPlayerName);
            }
        }
        return 1;
    }

    static {
        FALLING_LOGS.put(Blocks.f_49999_, (Block)BlockRegistrar.FALLING_OAK_LOG.get());
        FALLING_LOGS.put(Blocks.f_50000_, (Block)BlockRegistrar.FALLING_SPRUCE_LOG.get());
        FALLING_LOGS.put(Blocks.f_50001_, (Block)BlockRegistrar.FALLING_BIRCH_LOG.get());
        FALLING_LOGS.put(Blocks.f_50002_, (Block)BlockRegistrar.FALLING_JUNGLE_LOG.get());
        FALLING_LOGS.put(Blocks.f_50003_, (Block)BlockRegistrar.FALLING_ACACIA_LOG.get());
        FALLING_LOGS.put(Blocks.f_50004_, (Block)BlockRegistrar.FALLING_DARK_OAK_LOG.get());
        FALLING_LOGS.put(Blocks.f_220832_, (Block)BlockRegistrar.FALLING_MANGROVE_LOG.get());
        FALLING_LOGS.put(Blocks.f_50011_, (Block)BlockRegistrar.FALLING_OAK_LOG.get());
        FALLING_LOGS.put(Blocks.f_50012_, (Block)BlockRegistrar.FALLING_SPRUCE_LOG.get());
        FALLING_LOGS.put(Blocks.f_50013_, (Block)BlockRegistrar.FALLING_BIRCH_LOG.get());
        FALLING_LOGS.put(Blocks.f_50014_, (Block)BlockRegistrar.FALLING_JUNGLE_LOG.get());
        FALLING_LOGS.put(Blocks.f_50015_, (Block)BlockRegistrar.FALLING_ACACIA_LOG.get());
        FALLING_LOGS.put(Blocks.f_50043_, (Block)BlockRegistrar.FALLING_DARK_OAK_LOG.get());
        FALLING_LOGS.put(Blocks.f_220836_, (Block)BlockRegistrar.FALLING_MANGROVE_LOG.get());
        FALLING_LOGS.put(Blocks.f_50686_, (Block)BlockRegistrar.FALLING_WARPED_STEM.get());
        FALLING_LOGS.put(Blocks.f_50688_, (Block)BlockRegistrar.FALLING_WARPED_STEM.get());
        FALLING_LOGS.put(Blocks.f_50695_, (Block)BlockRegistrar.FALLING_CRIMSON_STEM.get());
        FALLING_LOGS.put(Blocks.f_50697_, (Block)BlockRegistrar.FALLING_CRIMSON_STEM.get());
    }
}

