/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.resources.dynamic;

public class DynamicResourceProperties {
    private final int baseValue;
    private final float marketVolatility;
    private final boolean tradeable;
    private final int maxStackSize;
    private final float productionRate;
    private final boolean renewable;
    private final int depletionTime;
    private final boolean requiresWorkers;
    private final boolean requiresSpecialStorage;
    private final int decayRate;
    private final boolean stackable;
    private final boolean shareableBetweenFactions;
    private final float factionProductionBonus;
    private final boolean requiresFactionTechnology;
    private final boolean consumedOnUse;
    private final int transportCost;
    private final boolean visibleToEnemies;

    private DynamicResourceProperties(Builder builder) {
        this.baseValue = builder.baseValue;
        this.marketVolatility = builder.marketVolatility;
        this.tradeable = builder.tradeable;
        this.maxStackSize = builder.maxStackSize;
        this.productionRate = builder.productionRate;
        this.renewable = builder.renewable;
        this.depletionTime = builder.depletionTime;
        this.requiresWorkers = builder.requiresWorkers;
        this.requiresSpecialStorage = builder.requiresSpecialStorage;
        this.decayRate = builder.decayRate;
        this.stackable = builder.stackable;
        this.shareableBetweenFactions = builder.shareableBetweenFactions;
        this.factionProductionBonus = builder.factionProductionBonus;
        this.requiresFactionTechnology = builder.requiresFactionTechnology;
        this.consumedOnUse = builder.consumedOnUse;
        this.transportCost = builder.transportCost;
        this.visibleToEnemies = builder.visibleToEnemies;
    }

    public static DynamicResourceProperties defaultProperties() {
        return new Builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getBaseValue() {
        return this.baseValue;
    }

    public float getMarketVolatility() {
        return this.marketVolatility;
    }

    public boolean isTradeable() {
        return this.tradeable;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public float getProductionRate() {
        return this.productionRate;
    }

    public boolean isRenewable() {
        return this.renewable;
    }

    public int getDepletionTime() {
        return this.depletionTime;
    }

    public boolean requiresWorkers() {
        return this.requiresWorkers;
    }

    public boolean requiresSpecialStorage() {
        return this.requiresSpecialStorage;
    }

    public int getDecayRate() {
        return this.decayRate;
    }

    public boolean isStackable() {
        return this.stackable;
    }

    public boolean isShareableBetweenFactions() {
        return this.shareableBetweenFactions;
    }

    public float getFactionProductionBonus() {
        return this.factionProductionBonus;
    }

    public boolean requiresFactionTechnology() {
        return this.requiresFactionTechnology;
    }

    public boolean isConsumedOnUse() {
        return this.consumedOnUse;
    }

    public int getTransportCost() {
        return this.transportCost;
    }

    public boolean isVisibleToEnemies() {
        return this.visibleToEnemies;
    }

    public static class Builder {
        private int baseValue = 10;
        private float marketVolatility = 0.1f;
        private boolean tradeable = true;
        private int maxStackSize = 64;
        private float productionRate = 1.0f;
        private boolean renewable = true;
        private int depletionTime = -1;
        private boolean requiresWorkers = true;
        private boolean requiresSpecialStorage = false;
        private int decayRate = 0;
        private boolean stackable = true;
        private boolean shareableBetweenFactions = false;
        private float factionProductionBonus = 1.0f;
        private boolean requiresFactionTechnology = false;
        private boolean consumedOnUse = true;
        private int transportCost = 1;
        private boolean visibleToEnemies = true;

        public Builder baseValue(int value) {
            this.baseValue = value;
            return this;
        }

        public Builder marketVolatility(float volatility) {
            this.marketVolatility = volatility;
            return this;
        }

        public Builder tradeable(boolean tradeable) {
            this.tradeable = tradeable;
            return this;
        }

        public Builder maxStackSize(int size) {
            this.maxStackSize = size;
            return this;
        }

        public Builder stackSize(int size) {
            this.maxStackSize = size;
            return this;
        }

        public Builder productionRate(float rate) {
            this.productionRate = rate;
            return this;
        }

        public Builder renewable(boolean renewable) {
            this.renewable = renewable;
            return this;
        }

        public Builder depletionTime(int time) {
            this.depletionTime = time;
            return this;
        }

        public Builder requiresWorkers(boolean requires) {
            this.requiresWorkers = requires;
            return this;
        }

        public Builder requiresSpecialStorage(boolean requires) {
            this.requiresSpecialStorage = requires;
            return this;
        }

        public Builder decayRate(int rate) {
            this.decayRate = rate;
            return this;
        }

        public Builder stackable(boolean stackable) {
            this.stackable = stackable;
            return this;
        }

        public Builder shareableBetweenFactions(boolean shareable) {
            this.shareableBetweenFactions = shareable;
            return this;
        }

        public Builder factionProductionBonus(float bonus) {
            this.factionProductionBonus = bonus;
            return this;
        }

        public Builder requiresFactionTechnology(boolean requires) {
            this.requiresFactionTechnology = requires;
            return this;
        }

        public Builder consumedOnUse(boolean consumed) {
            this.consumedOnUse = consumed;
            return this;
        }

        public Builder transportCost(int cost) {
            this.transportCost = cost;
            return this;
        }

        public Builder visibleToEnemies(boolean visible) {
            this.visibleToEnemies = visible;
            return this;
        }

        public DynamicResourceProperties build() {
            return new DynamicResourceProperties(this);
        }
    }
}

