/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.resources.dynamic;

import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceProperties;
import com.solegendary.reignofnether.resources.dynamic.ResourceCategory;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DynamicResourceType {
    private final ResourceLocation id;
    private final String displayName;
    private final FactionType faction;
    private final ResourceCategory category;
    private final Supplier<Item> itemSupplier;
    private final DynamicResourceProperties properties;

    public DynamicResourceType(ResourceLocation id, String displayName, FactionType faction, ResourceCategory category, Supplier<Item> itemSupplier, DynamicResourceProperties properties) {
        this.id = id;
        this.displayName = displayName;
        this.faction = faction;
        this.category = category;
        this.itemSupplier = itemSupplier;
        this.properties = properties != null ? properties : DynamicResourceProperties.defaultProperties();
    }

    public DynamicResourceType(ResourceLocation id, String displayName, Item item, FactionType faction, ResourceCategory category, DynamicResourceProperties properties) {
        this(id, displayName, faction, category, () -> item, properties);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public FactionType getFaction() {
        return this.faction;
    }

    public ResourceCategory getCategory() {
        return this.category;
    }

    public Item getItem() {
        return this.itemSupplier.get();
    }

    public ItemStack createItemStack(int count) {
        return new ItemStack((ItemLike)this.getItem(), count);
    }

    public DynamicResourceProperties getProperties() {
        return this.properties;
    }

    public boolean matches(Item item) {
        return this.getItem() == item;
    }

    public boolean matches(ItemStack itemStack) {
        return !itemStack.m_41619_() && this.matches(itemStack.m_41720_());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DynamicResourceType that = (DynamicResourceType)obj;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "DynamicResourceType{id=" + this.id + ", displayName='" + this.displayName + "', faction=" + (this.faction != null ? this.faction.getDisplayName() : "null") + ", category=" + this.category + "}";
    }
}

