/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.time;

import com.mojang.datafixers.util.Pair;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.NightSource;
import com.solegendary.reignofnether.building.RangeIndicator;
import com.solegendary.reignofnether.guiscreen.TopdownGui;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.minimap.MinimapClientEvents;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import com.solegendary.reignofnether.registrars.SoundRegistrar;
import com.solegendary.reignofnether.sounds.FadeableMusicInstance;
import com.solegendary.reignofnether.sounds.SoundClientEvents;
import com.solegendary.reignofnether.survival.SurvivalClientEvents;
import com.solegendary.reignofnether.time.NightCircleMode;
import com.solegendary.reignofnether.time.TimeUtils;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialStage;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TimeClientEvents {
    private static int xPos = 0;
    private static int yPos = 0;
    private static final Minecraft MC = Minecraft.m_91087_();
    public static long targetClientTime = 0L;
    public static long serverTime = 0L;
    public static NightCircleMode nightCircleMode = NightCircleMode.NO_OVERLAPS;
    private static final Button CLOCK_BUTTON = new Button("Clock", 10, null, null, null, () -> false, () -> !OrthoviewClientEvents.isEnabled(), () -> true, null, null, null);
    private static int bloodMoonTicksLeft = 0;
    private static String bloodMoonOwner = "";
    private static final int NIGHT_SOURCES_UPDATE_TICKS_MAX = 50;
    private static int nightSourcesUpdateTicks = 50;
    public static ArrayList<Pair<BlockPos, Integer>> nightSourceOrigins = new ArrayList();
    public static final int VISIBLE_BORDER_ADJ = 2;

    public static boolean isBloodMoonActive() {
        return bloodMoonTicksLeft > 0;
    }

    private static Button getBloodMoonButton() {
        return new Button("Clock", 14, new ResourceLocation("reignofnether", "textures/hud/blood_moon.png"), null, null, () -> false, () -> !OrthoviewClientEvents.isEnabled() || !TimeClientEvents.isBloodMoonActive(), () -> true, null, null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.clock_warning1", (Object[])new Object[0]), Style.f_131099_.m_178520_(0xFF0000)), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.clock_warning2", (Object[])new Object[]{TimeUtils.getTimeStrFromTicks(bloodMoonTicksLeft)})), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.clock_warning3", (Object[])new Object[]{bloodMoonOwner.isBlank() ? "Nobody!" : bloodMoonOwner}))));
    }

    public static void setBloodMoonTicks(int tickDuration, String ownerName) {
        boolean newBloodMoon = tickDuration > 0 && bloodMoonTicksLeft <= 0;
        bloodMoonTicksLeft = tickDuration;
        bloodMoonOwner = ownerName;
        if (newBloodMoon) {
            SoundClientEvents.playFadeableMusicInstance(new FadeableMusicInstance((SoundEvent)SoundRegistrar.BLOOD_MOON_SONG.get()));
        } else if (tickDuration <= 0) {
            SoundClientEvents.stopFadeableMusicInstance();
        }
    }

    @SubscribeEvent
    public static void renderOverlay(RenderGuiOverlayEvent.Post evt) {
        if (!OrthoviewClientEvents.isEnabled() || MC.m_91104_() || !TutorialClientEvents.isAtOrPastStage(TutorialStage.MINIMAP_CLICK)) {
            return;
        }
        if (!TimeClientEvents.isBloodMoonActive()) {
            xPos = MC.m_91268_().m_85445_() - MinimapClientEvents.getMapGuiRadius() - 20 + 2;
            yPos = MC.m_91268_().m_85446_() - MinimapClientEvents.getMapGuiRadius() * 2 - 20 - 6;
            ItemRenderer itemrenderer = MC.m_91291_();
            evt.getGuiGraphics().m_280480_(new ItemStack((ItemLike)Items.f_42524_), xPos, yPos);
            evt.getGuiGraphics().m_280370_(TimeClientEvents.MC.f_91062_, new ItemStack((ItemLike)Items.f_42524_), xPos, yPos);
        }
    }

    @SubscribeEvent
    public static void onDrawScreen(ScreenEvent.Render.Post evt) {
        if (!OrthoviewClientEvents.isEnabled() || MC.m_91104_() || !TutorialClientEvents.isAtOrPastStage(TutorialStage.MINIMAP_CLICK)) {
            return;
        }
        xPos = MC.m_91268_().m_85445_() - MinimapClientEvents.getMapGuiRadius() - 20 + 2;
        yPos = MC.m_91268_().m_85446_() - MinimapClientEvents.getMapGuiRadius() * 2 - 20 - 6;
        Button bloodMoonButton = TimeClientEvents.getBloodMoonButton();
        if (!bloodMoonButton.isHidden.get().booleanValue() && evt.getScreen() instanceof TopdownGui) {
            bloodMoonButton.render(evt.getGuiGraphics(), xPos - 3, yPos - 3, evt.getMouseX(), evt.getMouseY());
            if (bloodMoonButton.isMouseOver(evt.getMouseX(), evt.getMouseY())) {
                bloodMoonButton.renderTooltip(evt.getGuiGraphics(), evt.getMouseX(), evt.getMouseY());
            }
        } else if (!TimeClientEvents.CLOCK_BUTTON.isHidden.get().booleanValue() && evt.getScreen() instanceof TopdownGui) {
            CLOCK_BUTTON.render(evt.getGuiGraphics(), xPos - 3, yPos - 3, evt.getMouseX(), evt.getMouseY());
        }
    }

    @SubscribeEvent
    public static void onMousePress(ScreenEvent.MouseButtonPressed.Post evt) {
        if (evt.getButton() == 0) {
            CLOCK_BUTTON.checkClicked((int)evt.getMouseX(), (int)evt.getMouseY(), true);
        } else if (evt.getButton() == 1) {
            CLOCK_BUTTON.checkClicked((int)evt.getMouseX(), (int)evt.getMouseY(), false);
        }
    }

    @SubscribeEvent
    public static void onDrawScreen(ScreenEvent.Render evt) {
        if (!TutorialClientEvents.isAtOrPastStage(TutorialStage.MINIMAP_CLICK)) {
            return;
        }
        int GUI_LENGTH = 16;
        if (!TimeClientEvents.isBloodMoonActive() && evt.getMouseX() > xPos && evt.getMouseX() <= xPos + 16 && evt.getMouseY() > yPos && evt.getMouseY() <= yPos + 16) {
            boolean isDay = TimeUtils.isDay(serverTime);
            String dayStr = " (%s)".formatted(I18n.m_118938_((String)(isDay ? "time.reignofnether.day" : "time.reignofnether.night"), (Object[])new Object[0]));
            String timeStr = TimeUtils.get12HourTimeStr(serverTime) + dayStr;
            FormattedCharSequence timeUntilStr = FormattedCharSequence.m_13714_((String)(isDay ? I18n.m_118938_((String)"time.reignofnether.time_until_night", (Object[])new Object[]{TimeUtils.getTimeUntilStr(serverTime, 12500L)}) : I18n.m_118938_((String)"time.reignofnether.time_until_day", (Object[])new Object[]{TimeUtils.getTimeUntilStr(serverTime, 500L)})), (Style)Style.f_131099_);
            ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
            if (targetClientTime != serverTime) {
                tooltip.add(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"time.reignofnether.time_is_distorted", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                tooltip.add(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"time.reignofnether.real_time", (Object[])new Object[]{timeStr}), (Style)Style.f_131099_));
            } else {
                tooltip.add(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"time.reignofnether.time", (Object[])new Object[]{timeStr}), (Style)Style.f_131099_));
            }
            tooltip.add(timeUntilStr);
            if (SurvivalClientEvents.isEnabled) {
                long timeOffset = -TimeUtils.getWaveSurvivalTimeModifier(SurvivalClientEvents.difficulty);
                tooltip.add(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"time.reignofnether.time_until_next_wave", (Object[])new Object[]{TimeUtils.getTimeUntilStrWithOffset(serverTime, 12500L, isDay ? 0L : timeOffset)}), (Style)Style.f_131099_));
            }
            if (PlayerClientEvents.isRTSPlayer && !SurvivalClientEvents.isEnabled) {
                FormattedCharSequence gameLengthStr = FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"time.reignofnether.game_time", (Object[])new Object[]{TimeUtils.getTimeStrFromTicks(PlayerClientEvents.rtsGameTicks)}), (Style)Style.f_131099_);
                tooltip.add(gameLengthStr);
            }
            MyRenderer.renderTooltip(evt.getGuiGraphics(), tooltip, evt.getMouseX(), evt.getMouseY());
        }
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent evt) {
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
            if (!(building instanceof RangeIndicator)) continue;
            RangeIndicator ri = (RangeIndicator)((Object)building);
            for (BlockPos bp : ri.getBorderBps()) {
                if (BuildingClientEvents.getSelectedBuildings().contains(building)) {
                    MyRenderer.drawBlockFace(evt.getPoseStack(), Direction.UP, bp, 0.0f, 0.8f, 0.0f, 0.3f);
                    continue;
                }
                if (ri.showOnlyWhenSelected()) continue;
                MyRenderer.drawBlockFace(evt.getPoseStack(), Direction.UP, bp, 0.0f, 0.0f, 0.0f, 0.6f);
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (--nightSourcesUpdateTicks <= 0) {
            nightSourcesUpdateTicks = 50;
            nightSourceOrigins.clear();
            for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
                if (!building.isExploredClientside || !(building instanceof NightSource)) continue;
                NightSource ns = (NightSource)((Object)building);
                nightSourceOrigins.add((Pair<BlockPos, Integer>)new Pair((Object)building.centrePos, (Object)(ns.getNightRange() - 2)));
            }
        }
    }

    public static String getNightCircleModeName() {
        return switch (nightCircleMode) {
            default -> throw new IncompatibleClassChangeError();
            case NightCircleMode.ALL -> I18n.m_118938_((String)"time.reignofnether.night_circle_mode_all", (Object[])new Object[0]);
            case NightCircleMode.NO_OVERLAPS -> I18n.m_118938_((String)"time.reignofnether.night_circle_mode_no_overlaps", (Object[])new Object[0]);
            case NightCircleMode.OFF -> I18n.m_118938_((String)"time.reignofnether.night_circle_mode_off", (Object[])new Object[0]);
        };
    }
}

