/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.time;

import com.solegendary.reignofnether.survival.WaveDifficulty;

public class TimeUtils {
    public static final long DAWN = 500L;
    public static final long DUSK = 12500L;

    public static long normaliseTime(long time) {
        return (time % 24000L + 24000L) % 24000L;
    }

    public static String get12HourTimeStr(long time) {
        long hours = (time / 1000L + 6L) % 24L;
        String ampm = hours >= 12L ? "pm" : "am";
        hours = hours % 12L == 0L ? 12L : hours % 12L;
        long minutes = time % 1000L * 60L / 1000L;
        return String.format("%d:%02d%s", hours, minutes, ampm);
    }

    public static String getTimeUntilStr(long currentTime, long targetTime) {
        if (currentTime > targetTime) {
            currentTime -= 24000L;
        }
        long timeDiff = targetTime - currentTime;
        return TimeUtils.formatTimeFromTicks(timeDiff);
    }

    public static String getTimeUntilStrWithOffset(long currentTime, long targetTime, long offset) {
        if (currentTime > targetTime) {
            currentTime -= 24000L;
        }
        long timeDiff = targetTime - currentTime + offset;
        return TimeUtils.formatTimeFromTicks(timeDiff);
    }

    public static long getWaveSurvivalTimeModifier(WaveDifficulty difficulty) {
        return switch (difficulty) {
            default -> 0L;
            case WaveDifficulty.EASY -> 3000L;
            case WaveDifficulty.MEDIUM -> 4800L;
            case WaveDifficulty.HARD -> 6600L;
            case WaveDifficulty.EXTREME -> 8400L;
        };
    }

    public static String getTimeStrFromTicks(long ticks) {
        return TimeUtils.formatTimeFromTicks(ticks);
    }

    public static boolean isDay(long time) {
        long normTime = TimeUtils.normaliseTime(time);
        return normTime > 500L && normTime <= 12500L;
    }

    private static String formatTimeFromTicks(long ticks) {
        int sec = (int)(ticks / 20L);
        int min = sec / 60;
        return min == 0 ? sec + "s" : min + "m" + (sec %= 60) + "s";
    }
}

