/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.unit.UnitType;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.eventbus.api.Event;

public class UnitRegistry {
    private static final Map<ResourceLocation, UnitType<?>> UNITS = new ConcurrentHashMap();
    private static final Map<EntityType<?>, UnitType<?>> UNITS_BY_ENTITY_TYPE = new ConcurrentHashMap();
    private static final Map<Class<?>, UnitType<?>> UNITS_BY_CLASS = new ConcurrentHashMap();
    private static final Map<ResourceLocation, List<UnitType<?>>> UNITS_BY_FACTION = new ConcurrentHashMap();
    private static final List<UnitType<?>> UNIT_LIST = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized <T extends LivingEntity> UnitType<T> register(UnitType<T> unitType) {
        if (unitType == null) {
            throw new IllegalArgumentException("UnitType cannot be null");
        }
        ResourceLocation id = unitType.getId();
        if (UNITS.containsKey(id)) {
            ReignOfNether.LOGGER.warn("Unit {} is already registered, skipping duplicate registration", (Object)id);
            return UNITS.get(id);
        }
        UNITS.put(id, unitType);
        UNITS_BY_ENTITY_TYPE.put(unitType.getEntityType(), unitType);
        UNITS_BY_CLASS.put(unitType.getUnitClass(), unitType);
        if (unitType.getFaction() != null) {
            UNITS_BY_FACTION.computeIfAbsent(unitType.getFaction().getId(), k -> new ArrayList()).add(unitType);
        }
        List<UnitType<?>> list = UNIT_LIST;
        synchronized (list) {
            UNIT_LIST.add(unitType);
        }
        ReignOfNether.LOGGER.info("Registered unit: {} ({}) for faction {}", (Object)unitType.getDisplayName(), (Object)id, (Object)(unitType.getFaction() != null ? unitType.getFaction().getDisplayName() : "None"));
        return unitType;
    }

    public static UnitType<?> getUnitType(ResourceLocation id) {
        return UNITS.get(id);
    }

    public static UnitType<?> getUnitType(EntityType<?> entityType) {
        return UNITS_BY_ENTITY_TYPE.get(entityType);
    }

    public static <T extends LivingEntity> UnitType<T> getUnitType(T entity) {
        if (entity == null) {
            return null;
        }
        UnitType<?> unitType = UNITS_BY_CLASS.get(entity.getClass());
        if (unitType != null) {
            return unitType;
        }
        unitType = UNITS_BY_ENTITY_TYPE.get(entity.m_6095_());
        if (unitType != null) {
            return unitType;
        }
        for (Map.Entry<Class<?>, UnitType<?>> entry : UNITS_BY_CLASS.entrySet()) {
            if (!entry.getKey().isInstance(entity)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static <T extends LivingEntity> UnitType<T> getUnitType(Class<T> unitClass) {
        return UNITS_BY_CLASS.get(unitClass);
    }

    public static List<UnitType<?>> getUnitsForFaction(FactionType faction) {
        if (faction == null) {
            return new ArrayList();
        }
        return new ArrayList(UNITS_BY_FACTION.getOrDefault(faction.getId(), Collections.emptyList()));
    }

    public static List<UnitType<?>> getUnitsForFaction(ResourceLocation factionId) {
        return new ArrayList(UNITS_BY_FACTION.getOrDefault(factionId, Collections.emptyList()));
    }

    public static List<UnitType<?>> getAllUnits() {
        return new ArrayList(UNIT_LIST);
    }

    public static Set<ResourceLocation> getAllUnitIds() {
        return new HashSet<ResourceLocation>(UNITS.keySet());
    }

    public static List<UnitType<?>> getWorkerUnits() {
        return UNIT_LIST.stream().filter(unit -> unit.getProperties().isWorker()).collect(Collectors.toList());
    }

    public static List<UnitType<?>> getAttackerUnits() {
        return UNIT_LIST.stream().filter(unit -> unit.getProperties().isAttacker()).collect(Collectors.toList());
    }

    public static List<UnitType<?>> getRangedUnits() {
        return UNIT_LIST.stream().filter(unit -> unit.getProperties().isRanged()).collect(Collectors.toList());
    }

    public static List<UnitType<?>> getFlyingUnits() {
        return UNIT_LIST.stream().filter(unit -> unit.getProperties().isFlying()).collect(Collectors.toList());
    }

    public static List<UnitType<?>> getHeroUnits() {
        return UNIT_LIST.stream().filter(unit -> unit.getProperties().isHero()).collect(Collectors.toList());
    }

    public static boolean isRegistered(ResourceLocation id) {
        return UNITS.containsKey(id);
    }

    public static boolean isRegistered(EntityType<?> entityType) {
        return UNITS_BY_ENTITY_TYPE.containsKey(entityType);
    }

    public static boolean isUnit(LivingEntity entity) {
        if (!(entity instanceof Unit)) {
            return false;
        }
        if (UNITS_BY_ENTITY_TYPE.containsKey(entity.m_6095_())) {
            return true;
        }
        return UNITS_BY_CLASS.containsKey(entity.getClass());
    }

    public static FactionType getFactionForEntity(LivingEntity entity) {
        if (entity instanceof Unit) {
            Unit unit = (Unit)entity;
            return unit.getFactionType();
        }
        return null;
    }

    public static synchronized void clear() {
        UNITS.clear();
        UNITS_BY_ENTITY_TYPE.clear();
        UNITS_BY_CLASS.clear();
        UNITS_BY_FACTION.clear();
        UNIT_LIST.clear();
    }

    public static class UnitRegistrationEvent
    extends Event {
        public <T extends LivingEntity> UnitType<T> registerUnit(UnitType<T> unitType) {
            return UnitRegistry.register(unitType);
        }
    }
}

