/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit;

import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.unit.UnitProperties;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class UnitType<T extends LivingEntity> {
    private final ResourceLocation id;
    private final String displayName;
    private final Supplier<EntityType<T>> entityTypeSupplier;
    private final FactionType faction;
    private final ResourceCost cost;
    private final UnitProperties properties;
    private final Class<T> unitClass;

    public UnitType(ResourceLocation id, String displayName, Supplier<EntityType<T>> entityTypeSupplier, FactionType faction, ResourceCost cost, UnitProperties properties, Class<T> unitClass) {
        this.id = id;
        this.displayName = displayName;
        this.entityTypeSupplier = entityTypeSupplier;
        this.faction = faction;
        this.cost = cost;
        this.properties = properties != null ? properties : UnitProperties.defaultProperties();
        this.unitClass = unitClass;
    }

    public UnitType(ResourceLocation id, String displayName, Supplier<EntityType<T>> entityTypeSupplier, FactionType faction, ResourceCost cost, Class<T> unitClass) {
        this(id, displayName, entityTypeSupplier, faction, cost, UnitProperties.defaultProperties(), unitClass);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public EntityType<T> getEntityType() {
        return this.entityTypeSupplier.get();
    }

    public FactionType getFaction() {
        return this.faction;
    }

    public ResourceCost getCost() {
        return this.cost;
    }

    public UnitProperties getProperties() {
        return this.properties;
    }

    public Class<T> getUnitClass() {
        return this.unitClass;
    }

    public boolean matches(LivingEntity entity) {
        return this.unitClass.isInstance(entity);
    }

    public boolean matches(EntityType<?> entityType) {
        return this.getEntityType().equals(entityType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnitType unitType = (UnitType)obj;
        return Objects.equals(this.id, unitType.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "UnitType{id=" + this.id + ", displayName='" + this.displayName + "', faction=" + (this.faction != null ? this.faction.getDisplayName() : "null") + "}";
    }
}

