/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.registrars.GameRuleRegistrar;
import com.solegendary.reignofnether.unit.goals.FlyingMoveToTargetGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;

public class ImprovedFlyingMoveToTargetGoal
extends FlyingMoveToTargetGoal {
    private static final double FLYING_SPEED = 1.0;
    private static final double ARRIVAL_DISTANCE = 2.0;
    private static final int RECALC_COOLDOWN = 20;
    private int recalcCooldown = 0;
    private Vec3 currentDirection = Vec3.f_82478_;
    private int stuckCounter = 0;
    private BlockPos lastPosition = null;

    public ImprovedFlyingMoveToTargetGoal(Mob mob, int reachRange) {
        super(mob, reachRange);
    }

    @Override
    public boolean m_8036_() {
        return this.moveTarget != null;
    }

    @Override
    public boolean m_8045_() {
        if (this.recalcCooldown > 0) {
            --this.recalcCooldown;
            return true;
        }
        if (this.moveTarget == null) {
            return false;
        }
        this.checkIfStuck();
        if (this.isAtDestination()) {
            if (!this.persistent && !((Unit)this.mob).getHoldPosition()) {
                this.moveTarget = null;
                this.mob.m_21566_().f_24981_ = MoveControl.Operation.WAIT;
            }
            return false;
        }
        if (this.stuckCounter > 40 || this.shouldRecalculateDirection()) {
            this.calculateDirection();
            this.stuckCounter = 0;
            this.recalcCooldown = 20;
        }
        return true;
    }

    @Override
    public void m_8056_() {
        if (this.moveTarget != null) {
            this.calculateDirection();
            this.setMoveDirection();
        } else {
            this.mob.m_21566_().f_24981_ = MoveControl.Operation.WAIT;
        }
    }

    public void m_8037_() {
        if (this.moveTarget != null && this.mob.m_21566_().f_24981_ == MoveControl.Operation.MOVE_TO) {
            this.setMoveDirection();
        }
    }

    @Override
    public boolean isAtDestination() {
        double arrivalDistanceSqr;
        if (this.moveTarget == null) {
            return true;
        }
        double distance = this.mob.m_20275_((double)this.moveTarget.m_123341_() + 0.5, (double)this.moveTarget.m_123342_() + 0.5, (double)this.moveTarget.m_123343_() + 0.5);
        return distance <= (arrivalDistanceSqr = Math.max(4.0, (double)(this.moveReachRange * this.moveReachRange)));
    }

    private void checkIfStuck() {
        BlockPos currentPos = this.mob.m_20097_();
        this.stuckCounter = this.lastPosition != null && this.lastPosition.equals((Object)currentPos) ? ++this.stuckCounter : 0;
        this.lastPosition = currentPos;
    }

    private boolean shouldRecalculateDirection() {
        Vec3 normalizedToTarget;
        if (this.currentDirection.equals((Object)Vec3.f_82478_)) {
            return true;
        }
        Vec3 currentToTarget = Vec3.m_82512_((Vec3i)this.moveTarget).m_82546_(this.mob.m_20182_());
        if (currentToTarget.m_82553_() < 1.0) {
            return false;
        }
        Vec3 normalizedCurrent = this.currentDirection.m_82541_();
        double dotProduct = normalizedCurrent.m_82526_(normalizedToTarget = currentToTarget.m_82541_());
        return dotProduct < 0.8;
    }

    private void calculateDirection() {
        if (this.moveTarget == null) {
            this.currentDirection = Vec3.f_82478_;
            return;
        }
        Vec3 start = this.mob.m_20182_();
        Vec3 goal = Vec3.m_82512_((Vec3i)this.moveTarget);
        Vec3 directDirection = goal.m_82546_(start);
        Vec3 avoidanceDirection = this.calculateObstacleAvoidance(start, directDirection);
        this.currentDirection = directDirection.m_82549_(avoidanceDirection).m_82541_();
    }

    private Vec3 calculateObstacleAvoidance(Vec3 start, Vec3 direction) {
        Vec3 avoidance = Vec3.f_82478_;
        double checkDistance = Math.min(direction.m_82553_(), 8.0);
        if (checkDistance < 2.0) {
            return avoidance;
        }
        Vec3 normalizedDir = direction.m_82541_();
        for (int i = 0; i < 8; ++i) {
            double angle = (double)i * Math.PI / 4.0;
            double cosAngle = Math.cos(angle);
            double sinAngle = Math.sin(angle);
            Vec3 perpendicular1 = new Vec3(-normalizedDir.f_82481_, 0.0, normalizedDir.f_82479_).m_82541_();
            Vec3 perpendicular2 = normalizedDir.m_82537_(perpendicular1).m_82541_();
            Vec3 sampleDirection = normalizedDir.m_82549_(perpendicular1.m_82490_(cosAngle * 0.5)).m_82549_(perpendicular2.m_82490_(sinAngle * 0.5)).m_82541_();
            if (!this.hasObstacleInDirection(start, sampleDirection, checkDistance * 0.5)) continue;
            avoidance = avoidance.m_82546_(sampleDirection.m_82490_(0.3));
        }
        return avoidance;
    }

    private boolean hasObstacleInDirection(Vec3 start, Vec3 direction, double distance) {
        int samples = (int)Math.ceil(distance / 2.0);
        for (int i = 1; i <= samples; ++i) {
            Vec3 samplePos = start.m_82549_(direction.m_82490_((double)i * 2.0));
            BlockPos blockPos = new BlockPos((int)samplePos.f_82479_, (int)samplePos.f_82480_, (int)samplePos.f_82481_);
            if (this.mob.m_9236_().m_8055_(blockPos).m_60795_()) continue;
            return true;
        }
        return false;
    }

    private void setMoveDirection() {
        if (this.moveTarget == null || this.currentDirection.equals((Object)Vec3.f_82478_)) {
            this.mob.m_21566_().f_24981_ = MoveControl.Operation.WAIT;
            return;
        }
        Vec3 currentPos = this.mob.m_20182_();
        Vec3 targetPos = currentPos.m_82549_(this.currentDirection.m_82490_(3.0));
        double maxHeight = ((GameRules.IntegerValue)this.mob.m_9236_().m_46469_().m_46170_(GameRuleRegistrar.FLYING_MAX_Y_LEVEL)).m_46288_();
        if (targetPos.f_82480_ > maxHeight) {
            targetPos = new Vec3(targetPos.f_82479_, maxHeight, targetPos.f_82481_);
        }
        this.mob.m_21563_().m_24946_((double)this.moveTarget.m_123341_(), (double)this.moveTarget.m_123342_(), (double)this.moveTarget.m_123343_());
        this.mob.m_21566_().m_6849_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 1.0);
    }

    @Override
    public void setMoveTarget(@Nullable BlockPos bp) {
        if (bp != null) {
            MiscUtil.addUnitCheckpoint((Unit)this.mob, bp, true);
            if (this.mob.m_9236_().m_8055_(bp).m_60795_()) {
                return;
            }
            BlockPos bpGround = bp;
            int y = 1;
            while (!MiscUtil.isGroundBlock(this.mob.m_9236_(), bpGround)) {
                bpGround = bp.m_7918_(0, -y, 0);
                if (++y <= 30) continue;
            }
            BlockPos targetBp = bpGround.m_7918_(0, 10, 0);
            double maxHeight = ((GameRules.IntegerValue)this.mob.m_9236_().m_46469_().m_46170_(GameRuleRegistrar.FLYING_MAX_Y_LEVEL)).m_46288_();
            if ((double)targetBp.m_123342_() > maxHeight) {
                targetBp = new BlockPos(targetBp.m_123341_(), (int)maxHeight, targetBp.m_123343_());
            }
            this.moveTarget = targetBp;
        } else {
            this.moveTarget = null;
            this.mob.m_21566_().f_24981_ = MoveControl.Operation.WAIT;
        }
        this.stuckCounter = 0;
        this.currentDirection = Vec3.f_82478_;
        this.m_8056_();
    }

    @Override
    public BlockPos getMoveTarget() {
        return this.moveTarget;
    }

    @Override
    public void stopMoving() {
        Object e;
        this.moveTarget = null;
        this.currentDirection = Vec3.f_82478_;
        this.stuckCounter = 0;
        this.mob.m_21566_().f_24981_ = MoveControl.Operation.WAIT;
        if (this.mob.m_20160_() && (e = this.mob.m_20197_().get(0)) instanceof Unit) {
            Unit unit = (Unit)e;
            unit.getMoveGoal().stopMoving();
        }
    }
}

