/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.pathfinding.AStarPathfinder;
import com.solegendary.reignofnether.unit.pathfinding.PathfindingCache;
import com.solegendary.reignofnether.unit.pathfinding.async.MultiThreadedPathfindingManager;
import com.solegendary.reignofnether.unit.pathfinding.async.PathfindingCallback;
import com.solegendary.reignofnether.unit.pathfinding.async.PathfindingTask;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.pathfinder.Path;

public class ImprovedMoveToTargetBlockGoal
extends MoveToTargetBlockGoal {
    private AStarPathfinder pathfinder;
    private final int IMPROVED_RECALC_COOLDOWN_MAX = 20;
    private int improvedRecalcCooldown = 0;
    private Path currentPath = null;
    private int pathIndex = 0;
    private int stuckCounter = 0;
    private static final int MAX_STUCK_TIME = 60;
    private BlockPos lastPosition = null;
    private CompletableFuture<Path> pendingPathfinding = null;
    private boolean useMultiThreaded = true;

    public ImprovedMoveToTargetBlockGoal(Mob mob, boolean persistent, int reachRange) {
        super(mob, persistent, reachRange);
        this.pathfinder = new AStarPathfinder(mob.m_9236_(), mob);
    }

    @Override
    public boolean isAtDestination() {
        if (this.moveTarget == null) {
            return true;
        }
        return this.mob.m_20097_().m_123331_((Vec3i)this.moveTarget) <= this.getMinDistToRecalculateSqr();
    }

    @Override
    public boolean m_8036_() {
        return this.moveTarget != null;
    }

    @Override
    public boolean m_8045_() {
        if (this.improvedRecalcCooldown > 0) {
            --this.improvedRecalcCooldown;
            return true;
        }
        this.checkIfStuck();
        if (this.stuckCounter > 60) {
            this.recalculatePath();
            this.stuckCounter = 0;
            this.improvedRecalcCooldown = 20;
            return true;
        }
        if (this.isAtDestination()) {
            if (!this.persistent && !((Unit)this.mob).getHoldPosition()) {
                this.moveTarget = null;
            }
            return false;
        }
        if (this.mob.m_21573_().m_26571_() && this.moveTarget != null) {
            this.recalculatePath();
            this.improvedRecalcCooldown = 20;
            return true;
        }
        return this.moveTarget != null;
    }

    private void checkIfStuck() {
        BlockPos currentPos = this.mob.m_20097_();
        this.stuckCounter = this.lastPosition != null && this.lastPosition.equals((Object)currentPos) ? ++this.stuckCounter : 0;
        this.lastPosition = currentPos;
    }

    private void recalculatePath() {
        if (this.moveTarget != null) {
            this.findAndSetPath();
        }
    }

    @Override
    public void m_8056_() {
        if (this.moveTarget != null) {
            this.findAndSetPath();
        } else {
            this.mob.m_21573_().m_26573_();
        }
    }

    private void findAndSetPath() {
        Path cachedPath;
        if (this.moveTarget == null) {
            return;
        }
        BlockPos startPos = this.mob.m_20097_();
        if (this.pendingPathfinding != null && !this.pendingPathfinding.isDone()) {
            MultiThreadedPathfindingManager manager = MultiThreadedPathfindingManager.getInstance();
            if (manager != null) {
                manager.cancelPathfinding(this.mob.m_19879_());
            }
            this.pendingPathfinding.cancel(false);
        }
        if ((cachedPath = PathfindingCache.getPath(startPos, this.moveTarget, this.moveReachRange)) != null && this.isPathValid(cachedPath)) {
            this.currentPath = cachedPath;
            this.mob.m_21573_().m_26536_(cachedPath, (double)Unit.getSpeedModifier((Unit)this.mob));
            return;
        }
        if (this.useMultiThreaded && this.tryMultiThreadedPathfinding(startPos)) {
            return;
        }
        this.findAndSetPathSync(startPos);
    }

    private boolean tryMultiThreadedPathfinding(BlockPos startPos) {
        Unit unit;
        MultiThreadedPathfindingManager manager = MultiThreadedPathfindingManager.getInstance();
        if (manager == null || !manager.isEnabled()) {
            return false;
        }
        PathfindingTask.Priority priority = PathfindingTask.Priority.NORMAL;
        Mob mob = this.mob;
        if (mob instanceof Unit && (unit = (Unit)mob).getOwnerName() != null && !unit.getOwnerName().isEmpty()) {
            priority = PathfindingTask.Priority.HIGH;
        }
        PathfindingCallback callback = (entityId, start, goal, result, success, errorMessage) -> {
            if (entityId == this.mob.m_19879_() && this.moveTarget != null && this.moveTarget.equals((Object)goal)) {
                if (success && result != null) {
                    this.currentPath = result;
                    this.mob.m_21573_().m_26536_(result, (double)Unit.getSpeedModifier((Unit)this.mob));
                } else {
                    this.findAndSetPathSync(this.mob.m_20097_());
                }
            }
        };
        try {
            this.pendingPathfinding = manager.findPathAsync(this.mob, startPos, this.moveTarget, this.moveReachRange, priority, callback);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void findAndSetPathSync(BlockPos startPos) {
        Path astarPath = this.pathfinder.findPath(startPos, this.moveTarget, this.moveReachRange);
        if (astarPath != null) {
            PathfindingCache.putPath(startPos, this.moveTarget, this.moveReachRange, astarPath);
            this.currentPath = astarPath;
            this.mob.m_21573_().m_26536_(astarPath, (double)Unit.getSpeedModifier((Unit)this.mob));
        } else {
            this.fallbackToVanillaPathfinding();
        }
    }

    private void fallbackToVanillaPathfinding() {
        Path bestPath;
        boolean improvedPathfinding;
        AttributeInstance ai = this.mob.m_21051_(Attributes.f_22277_);
        boolean bl = improvedPathfinding = ai != null && ai.m_22115_() == 64.0;
        if (improvedPathfinding) {
            ai.m_22100_(16.0);
            Path shortPath = this.mob.m_21573_().m_26524_((double)this.moveTarget.m_123341_(), (double)this.moveTarget.m_123342_(), (double)this.moveTarget.m_123343_(), this.moveReachRange);
            BlockPos shortFinalPos = this.getFinalNodePos(shortPath);
            ai.m_22100_(64.0);
            Path longPath = this.mob.m_21573_().m_26524_((double)this.moveTarget.m_123341_(), (double)this.moveTarget.m_123342_(), (double)this.moveTarget.m_123343_(), this.moveReachRange);
            BlockPos longFinalPos = this.getFinalNodePos(longPath);
            bestPath = longPath;
            if (shortFinalPos != null && longFinalPos != null) {
                double longXZDist;
                BlockPos moveTargetXZ = new BlockPos(this.moveTarget.m_123341_(), 0, this.moveTarget.m_123343_());
                double shortXZDist = new BlockPos(shortFinalPos.m_123341_(), 0, shortFinalPos.m_123343_()).m_123331_((Vec3i)moveTargetXZ);
                if (shortXZDist < (longXZDist = new BlockPos(longFinalPos.m_123341_(), 0, longFinalPos.m_123343_()).m_123331_((Vec3i)moveTargetXZ))) {
                    bestPath = shortPath;
                }
            }
        } else {
            bestPath = this.mob.m_21573_().m_26524_((double)this.moveTarget.m_123341_(), (double)this.moveTarget.m_123342_(), (double)this.moveTarget.m_123343_(), this.moveReachRange);
        }
        this.currentPath = bestPath;
        this.mob.m_21573_().m_26536_(bestPath, (double)Unit.getSpeedModifier((Unit)this.mob));
    }

    private boolean isPathValid(Path path) {
        if (path == null || path.f_77362_.isEmpty()) {
            return false;
        }
        BlockPos pathEnd = this.getFinalNodePos(path);
        if (pathEnd == null) {
            return false;
        }
        return pathEnd.m_123331_((Vec3i)this.moveTarget) <= this.getMinDistToRecalculateSqr() * 4.0;
    }

    @Override
    public void setMoveTarget(@Nullable BlockPos bp) {
        if (bp != null) {
            MiscUtil.addUnitCheckpoint((Unit)this.mob, bp, true);
        }
        this.moveTarget = bp;
        this.stuckCounter = 0;
        this.currentPath = null;
        if (!this.mob.m_9236_().m_5776_()) {
            this.m_8056_();
        }
    }

    @Override
    public BlockPos getMoveTarget() {
        return this.moveTarget;
    }

    @Override
    public void stopMoving() {
        Object e;
        this.improvedRecalcCooldown = 0;
        this.moveTarget = null;
        this.currentPath = null;
        this.stuckCounter = 0;
        this.mob.m_21573_().m_26573_();
        if (this.pendingPathfinding != null && !this.pendingPathfinding.isDone()) {
            MultiThreadedPathfindingManager manager = MultiThreadedPathfindingManager.getInstance();
            if (manager != null) {
                manager.cancelPathfinding(this.mob.m_19879_());
            }
            this.pendingPathfinding.cancel(false);
            this.pendingPathfinding = null;
        }
        if (this.mob.m_20160_() && (e = this.mob.m_20197_().get(0)) instanceof Unit) {
            Unit unit = (Unit)e;
            unit.getMoveGoal().stopMoving();
        }
    }

    public void invalidatePath() {
        this.currentPath = null;
        if (this.moveTarget != null) {
            this.findAndSetPath();
        }
    }

    public void setMultiThreadedPathfinding(boolean enabled) {
        this.useMultiThreaded = enabled;
        if (!enabled && this.pendingPathfinding != null && !this.pendingPathfinding.isDone()) {
            MultiThreadedPathfindingManager manager = MultiThreadedPathfindingManager.getInstance();
            if (manager != null) {
                manager.cancelPathfinding(this.mob.m_19879_());
            }
            this.pendingPathfinding.cancel(false);
            this.pendingPathfinding = null;
        }
    }

    public boolean isMultiThreadedPathfindingEnabled() {
        return this.useMultiThreaded;
    }
}

