/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.unit.goals.FlyingMoveToTargetGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.RangedAttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.piglins.GhastUnit;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.TridentItem;

public class UnitBowAttackGoal<T extends Mob>
extends Goal {
    private final Random random = new Random();
    private final T mob;
    private int attackWindupTime = this.random.nextInt(0, 10);
    private int attackCooldown = 0;
    private int attackTime = -1;
    private int seeTime;
    private static final int GARRISON_BONUS_RANGE_TO_GHASTS = 10;

    public UnitBowAttackGoal(T mob) {
        this.mob = mob;
        this.setToMaxAttackCooldown();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void tickAttackCooldown() {
        if (this.attackCooldown > ((AttackerUnit)this.mob).getAttackCooldown()) {
            this.setToMaxAttackCooldown();
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public void setToMaxAttackCooldown() {
        this.attackCooldown = ((AttackerUnit)this.mob).getAttackCooldown();
    }

    public void resetCooldown() {
        this.attackCooldown = 0;
    }

    public boolean m_8036_() {
        return this.mob.m_5448_() != null && this.isHoldingRangedWeapon();
    }

    private boolean isHoldingBow() {
        return this.mob.m_21093_(is -> is.m_41720_() instanceof BowItem);
    }

    private boolean isHoldingTrident() {
        return this.mob.m_21093_(is -> is.m_41720_() instanceof TridentItem);
    }

    public boolean isHoldingRangedWeapon() {
        return this.isHoldingBow() || this.isHoldingTrident();
    }

    public boolean m_8045_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null || !target.m_6084_() || !this.isHoldingRangedWeapon()) {
            return false;
        }
        return this.m_8036_() || !this.isDoneMoving();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.m_5810_();
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null && target.m_6084_()) {
            boolean flag;
            this.mob.m_21563_().m_24946_(target.m_20185_(), target.m_20188_(), target.m_20189_());
            GarrisonableBuilding garr = GarrisonableBuilding.getGarrison((Unit)this.mob);
            GarrisonableBuilding targetGarr = null;
            if (target instanceof Unit) {
                Unit unit = (Unit)target;
                targetGarr = GarrisonableBuilding.getGarrison(unit);
            }
            boolean isGarrisoned = garr != null;
            boolean isTargetGarrisoned = targetGarr != null;
            boolean canSeeTarget = this.mob.m_21574_().m_148306_((Entity)target) || isGarrisoned || isTargetGarrisoned;
            boolean bl = flag = this.seeTime > 0;
            if (canSeeTarget != flag) {
                this.seeTime = 0;
            }
            this.seeTime = canSeeTarget ? ++this.seeTime : --this.seeTime;
            float attackRange = ((AttackerUnit)this.mob).getAttackRange();
            if (!(this.mob instanceof GhastUnit)) {
                if (isGarrisoned) {
                    attackRange = garr.getAttackRange();
                    if (target instanceof GhastUnit) {
                        GhastUnit ghastUnit = (GhastUnit)target;
                        attackRange += 10.0f;
                    }
                } else if (isTargetGarrisoned) {
                    attackRange += (float)targetGarr.getExternalAttackRangeBonus();
                } else if (target instanceof GhastUnit) {
                    GhastUnit ghastUnit = (GhastUnit)target;
                    attackRange += (float)ghastUnit.getAttackerRangeBonus((Mob)this.mob);
                }
            }
            double distToTarget = this.mob.m_20270_((Entity)target);
            if (!this.mob.m_20159_()) {
                if (!(!(distToTarget > (double)(attackRange - 1.0f)) && canSeeTarget || ((Unit)this.mob).getHoldPosition())) {
                    this.moveTo(target);
                } else {
                    this.stopMoving();
                }
            }
            if (this.mob.m_6117_()) {
                int i;
                if (distToTarget > (double)attackRange || !canSeeTarget && this.seeTime < -60) {
                    this.mob.m_5810_();
                } else if (distToTarget <= (double)attackRange && canSeeTarget && (i = this.mob.m_21252_()) >= this.attackWindupTime && this.attackCooldown <= 0) {
                    this.mob.m_5810_();
                    float velocity = 0.0f;
                    if (this.isHoldingBow()) {
                        velocity = BowItem.m_40661_((int)i);
                    } else if (this.isHoldingTrident()) {
                        velocity = 20.0f;
                    }
                    T t = this.mob;
                    if (t instanceof RangedAttackerUnit) {
                        RangedAttackerUnit rangedAttackerUnit = (RangedAttackerUnit)t;
                        rangedAttackerUnit.performUnitRangedAttack(target, velocity);
                    }
                    this.attackTime = this.attackWindupTime;
                    this.attackWindupTime = this.random.nextInt(0, 10);
                    this.setToMaxAttackCooldown();
                }
            } else if (distToTarget <= (double)attackRange && --this.attackTime <= 0 && this.seeTime >= -60) {
                this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof BowItem || item instanceof TridentItem));
            }
        }
    }

    private boolean isDoneMoving() {
        Unit unit = (Unit)this.mob;
        MoveToTargetBlockGoal moveToTargetBlockGoal = unit.getMoveGoal();
        if (moveToTargetBlockGoal instanceof FlyingMoveToTargetGoal) {
            FlyingMoveToTargetGoal flyingMoveGoal = (FlyingMoveToTargetGoal)moveToTargetBlockGoal;
            return flyingMoveGoal.isAtDestination();
        }
        return this.mob.m_21573_().m_26571_();
    }

    private void stopMoving() {
        Unit unit = (Unit)this.mob;
        MoveToTargetBlockGoal moveToTargetBlockGoal = unit.getMoveGoal();
        if (moveToTargetBlockGoal instanceof FlyingMoveToTargetGoal) {
            FlyingMoveToTargetGoal flyingMoveGoal = (FlyingMoveToTargetGoal)moveToTargetBlockGoal;
            flyingMoveGoal.stopMoving();
        } else {
            this.mob.m_21573_().m_26573_();
        }
    }

    private void moveTo(LivingEntity target) {
        Unit unit = (Unit)this.mob;
        MoveToTargetBlockGoal moveToTargetBlockGoal = unit.getMoveGoal();
        if (moveToTargetBlockGoal instanceof FlyingMoveToTargetGoal) {
            FlyingMoveToTargetGoal flyingMoveGoal = (FlyingMoveToTargetGoal)moveToTargetBlockGoal;
            flyingMoveGoal.setMoveTarget(target.m_20097_());
        } else {
            this.mob.m_21573_().m_5624_((Entity)target, 1.0);
        }
    }
}

