/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.interfaces;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.placements.BridgePlacement;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.faction.FactionRegistry;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.nether.NetherBlocks;
import com.solegendary.reignofnether.registrars.MobEffectRegistrar;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.ResourceSource;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.time.NightUtils;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.goals.FlyingUsePortalGoal;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.GatherResourcesGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.packets.UnitAnimationClientboundPacket;
import com.solegendary.reignofnether.unit.packets.UnitSyncClientboundPacket;
import com.solegendary.reignofnether.unit.units.piglins.BruteUnit;
import com.solegendary.reignofnether.unit.units.piglins.GhastUnit;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public interface Unit {
    public static final int ANCHOR_RETREAT_RANGE = 30;
    public static final int PIGLIN_HEALING_TICKS = 160;
    public static final int MONSTER_HEALING_TICKS = 240;
    public static final int FOLLOW_RANGE_IMPROVED = 64;
    public static final int FOLLOW_RANGE = 16;
    public static final float HEAL_PER_NUTRITION = 2.5f;
    public static final List<Keybinding> ABILITY_KEYBINDS = List.of(Keybindings.keyQ, Keybindings.keyW, Keybindings.keyE, Keybindings.keyR, Keybindings.keyT, Keybindings.keyY);
    public static final Random RANDOM = new Random();

    public void setAnchor(BlockPos var1);

    public BlockPos getAnchor();

    public static int getFollowRange() {
        return UnitServerEvents.improvedPathfinding ? 64 : 16;
    }

    public ArrayList<Checkpoint> getCheckpoints();

    public GarrisonGoal getGarrisonGoal();

    public boolean canGarrison();

    public MoveToTargetBlockGoal getUsePortalGoal();

    public boolean canUsePortal();

    @Deprecated
    public Faction getFaction();

    default public FactionType getFactionType() {
        Faction oldFaction = this.getFaction();
        return Unit.convertFactionToFactionType(oldFaction);
    }

    public static FactionType convertFactionToFactionType(Faction faction) {
        if (faction == null) {
            return null;
        }
        switch (faction) {
            case VILLAGERS: {
                return FactionRegistry.getFaction(new ResourceLocation("reignofnether", "villagers"));
            }
            case MONSTERS: {
                return FactionRegistry.getFaction(new ResourceLocation("reignofnether", "monsters"));
            }
            case PIGLINS: {
                return FactionRegistry.getFaction(new ResourceLocation("reignofnether", "piglins"));
            }
        }
        return null;
    }

    public List<AbilityButton> getAbilityButtons();

    public List<Ability> getAbilities();

    public List<ItemStack> getItems();

    public int getMaxResources();

    default public boolean isEatingFood() {
        return this.getEatingTicksLeft() > 0;
    }

    default public boolean isHoldingEdibleFood() {
        for (ItemStack itemStack : this.getItems()) {
            if (!ResourceSources.isPreparedFood(itemStack.m_41720_())) continue;
            return true;
        }
        return false;
    }

    default public Item getFoodBeingEaten() {
        for (ItemStack itemStack : this.getItems()) {
            if (!ResourceSources.isPreparedFood(itemStack.m_41720_())) continue;
            return itemStack.m_41720_();
        }
        return Items.f_41852_;
    }

    public void setEatingTicksLeft(int var1);

    public int getEatingTicksLeft();

    default public void updateAbilityButtons() {
        if (((LivingEntity)this).m_9236_().m_5776_()) {
            this.getAbilityButtons().clear();
            for (int i = 0; i < this.getAbilities().size() && i < ABILITY_KEYBINDS.size(); ++i) {
                this.getAbilityButtons().add(this.getAbilities().get(i).getButton(ABILITY_KEYBINDS.get(i)));
            }
        }
    }

    public MoveToTargetBlockGoal getMoveGoal();

    public SelectedTargetGoal<?> getTargetGoal();

    public ReturnResourcesGoal getReturnResourcesGoal();

    public float getMovementSpeed();

    public float getUnitMaxHealth();

    public ResourceCost getCost();

    public LivingEntity getFollowTarget();

    public boolean getHoldPosition();

    public void setHoldPosition(boolean var1);

    public String getOwnerName();

    public void setOwnerName(String var1);

    default public float getUnitArmorPercentage() {
        Mob mob = (Mob)this;
        return 1.0f - CombatRules.m_19272_((float)1.0f, (float)mob.m_21230_(), (float)((float)mob.m_21133_(Attributes.f_22285_)));
    }

    public static void tick(Unit unit) {
        LivingEntity le;
        Object object;
        Mob unitMob = (Mob)unit;
        if (!unitMob.m_9236_().m_5776_() && (object = unitMob.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            ServerChunkCache chunkProvider = serverLevel.m_7726_();
            BlockPos unitPos = unitMob.m_20183_();
            ChunkPos currentChunkPos = new ChunkPos(unitPos);
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    ChunkPos chunkPos = new ChunkPos(currentChunkPos.f_45578_ + dx, currentChunkPos.f_45579_ + dz);
                    chunkProvider.m_8387_(TicketType.f_9445_, chunkPos, 2, (Object)chunkPos);
                }
            }
        }
        for (Ability ability : unit.getAbilities()) {
            ability.tickCooldown();
        }
        if (unitMob.m_9236_().m_5776_()) {
            unit.getCheckpoints().removeIf(c -> c.isForEntity() && !c.entity.m_6084_() || c.ticksLeft <= 0);
            for (Checkpoint cp : unit.getCheckpoints()) {
                cp.tick();
                boolean buildingIsDone = false;
                if (unit instanceof WorkerUnit) {
                    WorkerUnit workerUnit = (WorkerUnit)((Object)unit);
                    if (!cp.isForEntity() && cp.placement != null && cp.placement.isBuilt && cp.placement.getHealth() >= cp.placement.getMaxHealth()) {
                        buildingIsDone = true;
                    }
                }
                if (!(((Mob)unit).m_20097_().m_203193_((Position)cp.getPos()) < 4.0) && !buildingIsDone) continue;
                cp.startFading();
            }
        } else {
            boolean hasImmunityResearch;
            Unit.checkAndPickupEdibleFood(unit);
            Unit.checkAndPickupResources(unit);
            Unit.checkAndPickupEquipment(unit);
            if (unit.getTargetGoal().getTarget() == null || !unit.getTargetGoal().getTarget().m_6084_() || unitMob.m_5448_() == null || !unitMob.m_5448_().m_6084_()) {
                unitMob.m_6710_(null);
                unit.getTargetGoal().setTarget(null);
            }
            unitMob.f_19802_ = 0;
            if (unit.getFollowTarget() != null && unitMob.f_19797_ % 20 == 0) {
                unit.setMoveTarget(unit.getFollowTarget().m_20183_());
            }
            if ((hasImmunityResearch = ResearchServerEvents.playerHasResearch(unit.getOwnerName(), ProductionItems.RESEARCH_FIRE_RESISTANCE)) && unit.getFaction() == Faction.PIGLINS) {
                unitMob.m_7311_(0);
            }
        }
        if (!(le = (LivingEntity)unit).m_9236_().m_5776_()) {
            if (unit.getFaction() == Faction.MONSTERS && le.f_19797_ % 240 == 0 && !le.m_9236_().m_46461_()) {
                le.m_5634_(1.0f);
            } else if (unit.getFaction() == Faction.MONSTERS && (le.f_19797_ + 120) % 240 == 0 && NightUtils.isInRangeOfNightSource(le.m_20182_(), le.m_9236_().m_5776_())) {
                le.m_5634_(1.0f);
            } else if (unit.getFaction() == Faction.PIGLINS && le.f_19797_ % 160 == 0 && !(unit instanceof Slime) && (le.m_20202_() != null && NetherBlocks.isNetherBlock(le.m_9236_(), le.m_20202_().m_20097_()) || NetherBlocks.isNetherBlock(le.m_9236_(), le.m_20097_()) || unit instanceof GhastUnit)) {
                le.m_5634_(1.0f);
            }
        }
        if (le.m_20069_() && BuildingUtils.findBuilding(le.m_9236_().m_5776_(), le.m_20097_().m_7494_()) instanceof BridgePlacement) {
            le.m_20334_(0.0, 0.2, 0.0);
        }
        if (!le.m_9236_().m_6857_().m_61937_(le.m_20097_())) {
            le.m_6074_();
        }
        if (unitMob.f_19797_ % 50 == 0) {
            Unit.checkAndRetreatToAnchor(unit);
        }
        if (unit.getSunlightEffect() == SunlightEffect.MOVEMENT_SLOWDOWN && unitMob.f_19797_ % 10 == 0 && !unitMob.m_9236_().m_5776_() && unitMob.m_9236_().m_46461_() && !NightUtils.isInRangeOfNightSource(unitMob.m_146892_(), false) && !ResearchServerEvents.playerHasCheat(unit.getOwnerName(), "slipslopslap")) {
            unitMob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 15, 1));
        }
        if (unitMob.f_19797_ % 20 == 0 && unitMob.m_21023_((MobEffect)MobEffectRegistrar.UNCONTROLLABLE.get())) {
            Unit.addParticlesAroundSelf(unit, (ParticleOptions)ParticleTypes.f_123792_);
        }
        if (unit.isEatingFood()) {
            unit.setEatingTicksLeft(unit.getEatingTicksLeft() - 1);
            if (!unit.isEatingFood()) {
                for (ItemStack itemStack : unit.getItems()) {
                    if (!ResourceSources.isPreparedFood(itemStack.m_41720_())) continue;
                    unitMob.m_9236_().m_6263_(null, unitMob.m_20185_(), unitMob.m_20186_(), unitMob.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 0.5f, unitMob.m_217043_().m_188501_() * 0.1f + 0.9f);
                    int nutrition = itemStack.m_41720_().getFoodProperties(itemStack, (LivingEntity)unit).m_38744_();
                    if (itemStack.m_41720_() == Items.f_42437_) {
                        unitMob.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 999999, 5));
                        unitMob.m_7911_(24.0f);
                    } else {
                        unitMob.m_5634_((float)nutrition * 2.5f);
                    }
                    itemStack.m_41764_(itemStack.m_41613_() - 1);
                    break;
                }
            } else if (unit.getEatingTicksLeft() % 4 == 0) {
                unitMob.m_9236_().m_6263_(null, unitMob.m_20185_(), unitMob.m_20186_(), unitMob.m_20189_(), SoundEvents.f_11912_, SoundSource.PLAYERS, 0.5f, unitMob.m_217043_().m_188501_() * 0.1f + 0.9f);
            }
        } else {
            for (ItemStack itemStack : unit.getItems()) {
                if (!ResourceSources.isPreparedFood(itemStack.m_41720_())) continue;
                unit.setEatingTicksLeft(40);
                break;
            }
        }
        if (unitMob.m_21023_(MobEffects.f_19617_) && unitMob.m_6103_() <= 0.0f) {
            unitMob.m_21195_(MobEffects.f_19617_);
        }
    }

    private static void checkAndPickupResources(Unit unit) {
        Mob unitMob = (Mob)unit;
        if (unitMob.m_21531_()) {
            for (ItemEntity itementity : unitMob.m_9236_().m_45976_(ItemEntity.class, unitMob.m_20191_().m_82377_(1.0, 0.0, 1.0))) {
                WorkerUnit workerUnit;
                GatherResourcesGoal goal;
                if (itementity.m_213877_() || itementity.m_32055_().m_41619_() || itementity.m_32063_() || !unitMob.m_6084_() || Unit.atMaxResources(unit)) continue;
                ItemStack itemstack = itementity.m_32055_();
                ResourceSource resBlock = ResourceSources.getFromItem(itemstack.m_41720_());
                if (resBlock != null) {
                    while (!Unit.atMaxResources(unit) && itemstack.m_41613_() > 0) {
                        unitMob.m_21053_(itementity);
                        unitMob.m_7938_((Entity)itementity, 1);
                        unit.getItems().add(new ItemStack((ItemLike)itemstack.m_41720_(), 1));
                        itemstack.m_41764_(itemstack.m_41613_() - 1);
                    }
                    if (itemstack.m_41613_() <= 0) {
                        itementity.m_146870_();
                    }
                    UnitSyncClientboundPacket.sendSyncResourcesPacket(unit);
                }
                if (!Unit.atThresholdResources(unit) || !(unit instanceof WorkerUnit) || (goal = (workerUnit = (WorkerUnit)((Object)unit)).getGatherResourceGoal()) == null || goal.getTargetResourceName() == ResourceName.NONE) continue;
                goal.saveAndReturnResources();
            }
        }
    }

    private static void checkAndPickupEquipment(Unit unit) {
        Mob unitMob = (Mob)unit;
        for (ItemEntity itementity : unitMob.m_9236_().m_45976_(ItemEntity.class, unitMob.m_20191_().m_82377_(1.0, 0.0, 1.0))) {
            Relationship rl = UnitServerEvents.getUnitToEntityRelationship(unit, (Entity)itementity);
            ItemStack itemstack = itementity.m_32055_();
            if (!unit.canPickUpEquipment(itemstack) || itementity.m_213877_() || itemstack.m_41619_() || itementity.m_32063_() || !unitMob.m_6084_() || rl == Relationship.HOSTILE && itementity.f_19797_ <= 100) continue;
            unitMob.m_21053_(itementity);
            unitMob.m_7938_((Entity)itementity, 1);
            unit.onPickupEquipment(itemstack);
            itementity.m_146870_();
            break;
        }
    }

    default public boolean canPickUpEquipment(ItemStack itemStack) {
        return false;
    }

    default public void onPickupEquipment(ItemStack itemStack) {
    }

    private static void checkAndPickupEdibleFood(Unit unit) {
        Mob unitMob = (Mob)unit;
        if (!unit.isHoldingEdibleFood()) {
            for (ItemEntity itementity : unitMob.m_9236_().m_45976_(ItemEntity.class, unitMob.m_20191_().m_82377_(1.0, 0.0, 1.0))) {
                ItemStack itemstack = itementity.m_32055_();
                if (itemstack.m_41720_() == Items.f_42437_ ? unitMob.m_6103_() > 0.0f : unitMob.m_21223_() >= unitMob.m_21233_()) continue;
                Relationship rl = UnitServerEvents.getUnitToEntityRelationship(unit, (Entity)itementity);
                if (itementity.m_213877_() || itemstack.m_41619_() || itementity.m_32063_() || !unitMob.m_6084_() || rl == Relationship.HOSTILE && itementity.f_19797_ <= 100 || !ResourceSources.isPreparedFood(itemstack.m_41720_()) || !ResourceSources.isPreparedFood(itemstack.m_41720_()) || !(unitMob.m_21223_() < unitMob.m_21233_()) && itemstack.m_41720_() != Items.f_42437_) continue;
                unitMob.m_21053_(itementity);
                unitMob.m_7938_((Entity)itementity, 1);
                unit.getItems().add(new ItemStack((ItemLike)itemstack.m_41720_(), 1));
                UnitAnimationClientboundPacket.sendEatFoodPacket((LivingEntity)unitMob, BuiltInRegistries.f_257033_.m_7447_((Object)itemstack.m_41720_()));
                itemstack.m_41764_(itemstack.m_41613_() - 1);
                if (itemstack.m_41613_() > 0) break;
                itementity.m_146870_();
                break;
            }
        }
    }

    default public void addUnitSaveData(@NotNull CompoundTag pCompound) {
        Unit unit;
        pCompound.m_128359_("ownerName", this.getOwnerName());
        if (this.getAnchor() != null) {
            pCompound.m_128405_("anchorPosX", this.getAnchor().m_123341_());
            pCompound.m_128405_("anchorPosY", this.getAnchor().m_123342_());
            pCompound.m_128405_("anchorPosZ", this.getAnchor().m_123343_());
        }
        if ((unit = this) instanceof HeroUnit) {
            HeroUnit heroUnit = (HeroUnit)unit;
            heroUnit.addHeroUnitSaveData(pCompound);
        }
    }

    default public void readUnitSaveData(@NotNull CompoundTag pCompound) {
        Unit unit;
        this.setOwnerName(pCompound.m_128461_("ownerName"));
        BlockPos anchorPos = new BlockPos(pCompound.m_128451_("anchorPosX"), pCompound.m_128451_("anchorPosY"), pCompound.m_128451_("anchorPosZ"));
        if (!anchorPos.equals((Object)new BlockPos(0, 0, 0))) {
            this.setAnchor(anchorPos);
        }
        if ((unit = this) instanceof HeroUnit) {
            HeroUnit heroUnit = (HeroUnit)unit;
            heroUnit.readHeroUnitSaveData(pCompound);
        }
    }

    default public SunlightEffect getSunlightEffect() {
        return SunlightEffect.NONE;
    }

    public static boolean hasAnchor(Unit unit) {
        return unit.getAnchor() != null && !unit.getAnchor().equals((Object)new BlockPos(0, 0, 0));
    }

    private static void checkAndRetreatToAnchor(Unit unit) {
        LivingEntity le = (LivingEntity)unit;
        if (!Unit.hasAnchor(unit) || le.m_9236_().m_5776_()) {
            return;
        }
        if ((unit.isIdle() || le.m_20238_(Vec3.m_82512_((Vec3i)unit.getAnchor())) > 900.0) && !le.m_20097_().equals((Object)unit.getAnchor())) {
            Unit.fullResetBehaviours(unit);
            unit.getMoveGoal().setMoveTarget(unit.getAnchor());
        }
    }

    private static int getThresholdResources(Unit unit) {
        boolean hasCarryBags = ((LivingEntity)unit).m_9236_().m_5776_() ? ResearchClient.hasResearch(ProductionItems.RESEARCH_RESOURCE_CAPACITY) : ResearchServerEvents.playerHasResearch(unit.getOwnerName(), ProductionItems.RESEARCH_RESOURCE_CAPACITY);
        return hasCarryBags ? 100 : 50;
    }

    public static boolean atMaxResources(Unit unit) {
        return Resources.getTotalResourcesFromItems(unit.getItems()).getTotalValue() >= unit.getMaxResources();
    }

    public static boolean atThresholdResources(Unit unit) {
        return Resources.getTotalResourcesFromItems(unit.getItems()).getTotalValue() >= Unit.getThresholdResources(unit);
    }

    default public boolean hasLivingTarget() {
        Mob unitMob = (Mob)this;
        return unitMob.m_5448_() != null && unitMob.m_5448_().m_6084_();
    }

    public static void fullResetBehaviours(Unit unit) {
        if (((Entity)unit).m_9236_().m_5776_() && !Keybindings.shiftMod.isDown()) {
            unit.getCheckpoints().clear();
        }
        unit.resetBehaviours();
        Unit.resetBehaviours(unit);
        if (unit instanceof WorkerUnit) {
            WorkerUnit workerUnit = (WorkerUnit)((Object)unit);
            WorkerUnit.resetBehaviours(workerUnit);
        }
        if (unit instanceof AttackerUnit) {
            AttackerUnit attackerUnit = (AttackerUnit)((Object)unit);
            AttackerUnit.resetBehaviours(attackerUnit);
        }
    }

    public static void resetBehaviours(Unit unit) {
        unit.getTargetGoal().setTarget(null);
        unit.getMoveGoal().stopMoving();
        if (unit.getReturnResourcesGoal() != null) {
            unit.getReturnResourcesGoal().stopReturning();
        }
        unit.setFollowTarget(null);
        unit.setHoldPosition(false);
        if (unit.canGarrison()) {
            unit.getGarrisonGoal().stopGarrisoning();
        }
        if (unit.canUsePortal()) {
            MoveToTargetBlockGoal moveToTargetBlockGoal = unit.getUsePortalGoal();
            if (moveToTargetBlockGoal instanceof FlyingUsePortalGoal) {
                FlyingUsePortalGoal flyingUsePortalGoal = (FlyingUsePortalGoal)moveToTargetBlockGoal;
                flyingUsePortalGoal.stopUsingPortal();
            }
            if ((moveToTargetBlockGoal = unit.getUsePortalGoal()) instanceof UsePortalGoal) {
                UsePortalGoal usePortalGoal = (UsePortalGoal)moveToTargetBlockGoal;
                usePortalGoal.stopUsingPortal();
            }
        }
    }

    default public void resetBehaviours() {
    }

    default public void setMoveTarget(@Nullable BlockPos bp) {
        this.getMoveGoal().setMoveTarget(bp);
    }

    public void setFollowTarget(@Nullable LivingEntity var1);

    public void initialiseGoals();

    default public void setupEquipmentAndUpgradesServer() {
    }

    default public void setupEquipmentAndUpgradesClient() {
    }

    public static float getSpeedModifier(Unit unit) {
        if (unit instanceof BruteUnit) {
            BruteUnit brute = (BruteUnit)unit;
            if (brute.isHoldingUpShield) {
                return 0.5f;
            }
        }
        return 1.0f;
    }

    public static Ability getAbility(Unit unit, UnitAction abilityAction) {
        for (Ability ability : unit.getAbilities()) {
            if (!ability.action.equals((Object)abilityAction)) continue;
            return ability;
        }
        return null;
    }

    default public boolean isIdle() {
        boolean idleAttacker = true;
        boolean idleBuildingAttacker = true;
        Unit unit = this;
        if (unit instanceof AttackerUnit) {
            AttackerUnit attackerUnit = (AttackerUnit)((Object)unit);
            idleAttacker = attackerUnit.getAttackMoveTarget() == null && !((Unit)((Object)attackerUnit)).hasLivingTarget() && !AttackerUnit.isAttackingBuilding(attackerUnit);
        }
        boolean idleWorker = true;
        if (this instanceof WorkerUnit) {
            idleWorker = WorkerUnit.isIdle((WorkerUnit)((Object)this));
        }
        boolean stationaryNearMoveTarget = false;
        if (this.getMoveGoal().getMoveTarget() != null) {
            double distToMoveTarget = ((LivingEntity)this).m_20238_(this.getMoveGoal().getMoveTarget().m_252807_());
            boolean stationary = ((Mob)this).m_20184_().f_82479_ == 0.0 || ((Mob)this).m_20184_().f_82481_ == 0.0;
            stationaryNearMoveTarget = stationary && distToMoveTarget < 4.0;
        }
        return (this.getMoveGoal().getMoveTarget() == null || stationaryNearMoveTarget) && this.getFollowTarget() == null && idleAttacker && idleWorker;
    }

    public static void addParticlesAroundSelf(Unit unit, ParticleOptions pParticleOption) {
        for (int i = 0; i < 5; ++i) {
            double d0 = RANDOM.nextGaussian() * 0.02;
            double d1 = RANDOM.nextGaussian() * 0.02;
            double d2 = RANDOM.nextGaussian() * 0.02;
            Entity entity = (Entity)unit;
            if (entity.m_9236_().f_46443_) continue;
            ((ServerLevel)entity.m_9236_()).m_8767_(pParticleOption, entity.m_20208_(1.0), entity.m_20187_() + 1.0, entity.m_20262_(1.0), 1, d0, d1, d2, 0.0);
        }
    }

    default public boolean isCasting() {
        for (Ability ability : this.getAbilities()) {
            if (!ability.isCasting()) continue;
            return true;
        }
        return false;
    }

    public static enum SunlightEffect {
        NONE,
        MOVEMENT_SLOWDOWN,
        FIRE;

    }
}

