/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.modelling.models;

import com.solegendary.reignofnether.unit.interfaces.ArmSwingingUnit;
import com.solegendary.reignofnether.unit.units.piglins.BruteUnit;
import com.solegendary.reignofnether.unit.units.piglins.HeadhunterUnit;
import java.util.List;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinArmPose;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PiglinUnitModel<T extends Mob>
extends PlayerModel<T> {
    public final ModelPart rightEar;
    private final ModelPart leftEar;
    private final PartPose bodyDefault;
    private final PartPose headDefault;
    private final PartPose leftArmDefault;
    private final PartPose rightArmDefault;

    public PiglinUnitModel(ModelPart p_170810_) {
        super(p_170810_, false);
        this.rightEar = this.f_102808_.m_171324_("right_ear");
        this.leftEar = this.f_102808_.m_171324_("left_ear");
        this.bodyDefault = this.f_102810_.m_171308_();
        this.headDefault = this.f_102808_.m_171308_();
        this.leftArmDefault = this.f_102812_.m_171308_();
        this.rightArmDefault = this.f_102811_.m_171308_();
    }

    public static MeshDefinition createMesh(CubeDeformation pCubeDeformation) {
        MeshDefinition $$1 = PlayerModel.m_170825_((CubeDeformation)pCubeDeformation, (boolean)false);
        PartDefinition $$2 = $$1.m_171576_();
        $$2.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, pCubeDeformation), PartPose.f_171404_);
        PartDefinition $$3 = $$2.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f, pCubeDeformation).m_171514_(31, 1).m_171488_(-2.0f, -4.0f, -5.0f, 4.0f, 4.0f, 1.0f, pCubeDeformation).m_171514_(2, 4).m_171488_(2.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, pCubeDeformation).m_171514_(2, 0).m_171488_(-3.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, pCubeDeformation), PartPose.f_171404_);
        $$3.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(51, 6).m_171488_(0.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, pCubeDeformation), PartPose.m_171423_((float)4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5235988f));
        $$3.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(39, 6).m_171488_(-1.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, pCubeDeformation), PartPose.m_171423_((float)-4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5235988f));
        $$2.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        return $$1;
    }

    public void setupAnim(T entity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        HeadhunterUnit headhunter;
        ArmSwingingUnit armSwinger;
        this.f_102810_.m_171322_(this.bodyDefault);
        this.f_102808_.m_171322_(this.headDefault);
        this.f_102812_.m_171322_(this.leftArmDefault);
        this.f_102811_.m_171322_(this.rightArmDefault);
        super.m_6973_(entity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        float $$6 = 0.5235988f;
        float $$7 = pAgeInTicks * 0.1f + pLimbSwing * 0.5f;
        float $$8 = 0.08f + pLimbSwingAmount * 0.4f;
        this.leftEar.f_104205_ = -0.5235988f - Mth.m_14089_((float)($$7 * 1.2f)) * $$8;
        this.rightEar.f_104205_ = 0.5235988f + Mth.m_14089_((float)$$7) * $$8;
        if (entity instanceof AbstractPiglin) {
            AbstractPiglin $$9 = (AbstractPiglin)entity;
            PiglinArmPose $$10 = $$9.m_6389_();
            if ($$10 == PiglinArmPose.DANCING) {
                float $$11 = pAgeInTicks / 60.0f;
                this.rightEar.f_104205_ = 0.5235988f + (float)Math.PI / 180 * Mth.m_14031_((float)($$11 * 30.0f)) * 10.0f;
                this.leftEar.f_104205_ = -0.5235988f - (float)Math.PI / 180 * Mth.m_14089_((float)($$11 * 30.0f)) * 10.0f;
                this.f_102808_.f_104200_ = Mth.m_14031_((float)($$11 * 10.0f));
                this.f_102808_.f_104201_ = Mth.m_14031_((float)($$11 * 40.0f)) + 0.4f;
                this.f_102811_.f_104205_ = (float)Math.PI / 180 * (70.0f + Mth.m_14089_((float)($$11 * 40.0f)) * 10.0f);
                this.f_102812_.f_104205_ = this.f_102811_.f_104205_ * -1.0f;
                this.f_102811_.f_104201_ = Mth.m_14031_((float)($$11 * 40.0f)) * 0.5f + 1.5f;
                this.f_102812_.f_104201_ = Mth.m_14031_((float)($$11 * 40.0f)) * 0.5f + 1.5f;
                this.f_102810_.f_104201_ = Mth.m_14031_((float)($$11 * 40.0f)) * 0.35f;
            } else if ($$10 == PiglinArmPose.ATTACKING_WITH_MELEE_WEAPON && this.f_102608_ == 0.0f) {
                this.holdWeaponHigh(entity);
            } else if ($$10 == PiglinArmPose.CROSSBOW_HOLD) {
                AnimationUtils.m_102097_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (ModelPart)this.f_102808_, (!entity.m_21526_() ? 1 : 0) != 0);
            } else if ($$10 == PiglinArmPose.CROSSBOW_CHARGE) {
                AnimationUtils.m_102086_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, entity, (!entity.m_21526_() ? 1 : 0) != 0);
            } else if ($$10 == PiglinArmPose.ADMIRING_ITEM) {
                this.f_102808_.f_104203_ = 0.5f;
                this.f_102808_.f_104204_ = 0.0f;
                if (entity.m_21526_()) {
                    this.f_102811_.f_104204_ = -0.5f;
                    this.f_102811_.f_104203_ = -0.9f;
                } else {
                    this.f_102812_.f_104204_ = 0.5f;
                    this.f_102812_.f_104203_ = -0.9f;
                }
            }
        } else if (entity.m_6095_() == EntityType.f_20531_) {
            AnimationUtils.m_102102_((ModelPart)this.f_102812_, (ModelPart)this.f_102811_, (boolean)entity.m_5912_(), (float)this.f_102608_, (float)pAgeInTicks);
        }
        this.f_103376_.m_104315_(this.f_102814_);
        this.f_103377_.m_104315_(this.f_102813_);
        this.f_103374_.m_104315_(this.f_102812_);
        this.f_103375_.m_104315_(this.f_102811_);
        this.f_103378_.m_104315_(this.f_102810_);
        this.f_102809_.m_104315_(this.f_102808_);
        if (entity instanceof ArmSwingingUnit && ((armSwinger = (ArmSwingingUnit)entity).isSwingingArmRepeatedly() || armSwinger.isSwingingArmOnce())) {
            List<Float> armRots = armSwinger.getNextArmRot();
            this.f_102811_.f_104203_ = armRots.get(0).floatValue();
            this.f_102811_.f_104204_ = armRots.get(1).floatValue();
            this.f_102811_.f_104205_ = armRots.get(2).floatValue();
            int swingTime = armSwinger.getSwingTime();
            armSwinger.setSwingTime(swingTime + 1);
            if (swingTime >= 80) {
                armSwinger.setSwingTime(0);
                if (armSwinger.isSwingingArmOnce()) {
                    armSwinger.setSwingingArmOnce(false);
                }
            }
        }
        if (entity instanceof HeadhunterUnit && (headhunter = (HeadhunterUnit)entity).m_5448_() != null) {
            this.f_102811_.f_104203_ = this.f_102811_.f_104203_ * 0.5f - (float)Math.PI;
            this.f_102811_.f_104204_ = 0.0f;
        }
        if (entity instanceof BruteUnit) {
            BruteUnit brute = (BruteUnit)entity;
            if (entity.m_21206_().m_41720_() == Items.f_42740_ && brute.isHoldingUpShield) {
                this.f_102812_.f_104203_ = -1.5f;
            }
        }
    }

    protected void setupAttackAnimation(T pLivingEntity, float pAgeInTicks) {
        if (this.f_102608_ > 0.0f && pLivingEntity instanceof Piglin && ((Piglin)pLivingEntity).m_6389_() == PiglinArmPose.ATTACKING_WITH_MELEE_WEAPON) {
            AnimationUtils.m_102091_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, pLivingEntity, (float)this.f_102608_, (float)pAgeInTicks);
        } else {
            super.m_7884_(pLivingEntity, pAgeInTicks);
        }
    }

    private void holdWeaponHigh(T pMob) {
        if (pMob.m_21526_()) {
            this.f_102812_.f_104203_ = -1.8f;
        } else {
            this.f_102811_.f_104203_ = -1.8f;
        }
    }
}

