/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.packets;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.UnitSyncAction;
import com.solegendary.reignofnether.unit.packets.UnitSyncAbilityClientboundPacket;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class UnitSyncServerboundPacket {
    private final UnitSyncAction syncAction;
    private final int entityId;

    public static void requestSyncAbilities(int unitId) {
        PacketHandler.INSTANCE.sendToServer((Object)new UnitSyncServerboundPacket(UnitSyncAction.REQUEST_SYNC_ABILITIES, unitId));
    }

    public UnitSyncServerboundPacket(UnitSyncAction syncAction, int unitId) {
        this.syncAction = syncAction;
        this.entityId = unitId;
    }

    public UnitSyncServerboundPacket(FriendlyByteBuf buffer) {
        this.syncAction = (UnitSyncAction)buffer.m_130066_(UnitSyncAction.class);
        this.entityId = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.syncAction);
        buffer.writeInt(this.entityId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            if (this.syncAction == UnitSyncAction.REQUEST_SYNC_ABILITIES) {
                for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
                    if (entity.m_19879_() != this.entityId) continue;
                    UnitSyncAbilityClientboundPacket.sendSyncAbilitiesPacket(entity);
                }
            }
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

