/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding;

import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.pathfinding.DestructionPath;
import com.solegendary.reignofnether.unit.pathfinding.PathNode;
import com.solegendary.reignofnether.unit.pathfinding.TerrainDestruction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class AStarPathfinder {
    private static final int MAX_SEARCH_DISTANCE = 128;
    private static final int MAX_ITERATIONS = 2000;
    private static final double DIAGONAL_COST = 1.414;
    private static final double STRAIGHT_COST = 1.0;
    private static final double HEIGHT_PENALTY = 0.5;
    private static final double BUILDING_PENALTY = 2.0;
    private static final double DESTRUCTION_MULTIPLIER = 1.2;
    private static final int[][] NEIGHBORS = new int[][]{{-1, 0, -1}, {0, 0, -1}, {1, 0, -1}, {-1, 0, 0}, {1, 0, 0}, {-1, 0, 1}, {0, 0, 1}, {1, 0, 1}};
    private static final int[][] VERTICAL_NEIGHBORS = new int[][]{{0, 1, 0}, {0, -1, 0}};
    private final Level level;
    private final Mob mob;
    private final Map<BlockPos, Set<BlockPos>> plannedDestructions = new HashMap<BlockPos, Set<BlockPos>>();
    private final Map<BlockPos, Integer> destructionTimes = new HashMap<BlockPos, Integer>();
    private final Map<BlockPos, Set<BlockPos>> plannedLadderPlacements = new HashMap<BlockPos, Set<BlockPos>>();
    private final Map<BlockPos, Integer> ladderPlacementTimes = new HashMap<BlockPos, Integer>();

    public AStarPathfinder(Level level, Mob mob) {
        this.level = level;
        this.mob = mob;
    }

    @Nullable
    public Path findPath(BlockPos start, BlockPos goal, int reachRange) {
        this.plannedDestructions.clear();
        this.destructionTimes.clear();
        this.plannedLadderPlacements.clear();
        this.ladderPlacementTimes.clear();
        if (start.equals((Object)goal) || start.m_123331_((Vec3i)goal) <= (double)(reachRange * reachRange)) {
            return this.createSingleNodePath(start);
        }
        PriorityQueue<PathNode> openSet = new PriorityQueue<PathNode>();
        HashSet<BlockPos> closedSet = new HashSet<BlockPos>();
        HashMap<BlockPos, Double> gScores = new HashMap<BlockPos, Double>();
        PathNode startNode = new PathNode(start, 0.0, this.heuristic(start, goal), null);
        openSet.add(startNode);
        gScores.put(start, 0.0);
        int iterations = 0;
        while (!openSet.isEmpty() && iterations < 2000) {
            PathNode neighborNode;
            double tentativeGScore;
            double moveCost;
            BlockPos neighborPos;
            ++iterations;
            PathNode current = (PathNode)openSet.poll();
            if (closedSet.contains(current.pos)) continue;
            closedSet.add(current.pos);
            if (this.isWithinReachRange(current.pos, goal, reachRange)) {
                return this.reconstructDestructionPath(current, goal);
            }
            for (int[] neighbor : NEIGHBORS) {
                neighborPos = current.pos.m_7918_(neighbor[0], neighbor[1], neighbor[2]);
                if (closedSet.contains(neighborPos) || !this.isValidPosition(neighborPos, current.pos) || current.pos.m_123331_((Vec3i)start) > 16384.0) continue;
                moveCost = this.calculateMoveCost(current.pos, neighborPos);
                tentativeGScore = current.gCost + moveCost;
                if (gScores.containsKey(neighborPos) && tentativeGScore >= (Double)gScores.get(neighborPos)) continue;
                gScores.put(neighborPos, tentativeGScore);
                neighborNode = new PathNode(neighborPos, tentativeGScore, this.heuristic(neighborPos, goal), current);
                openSet.add(neighborNode);
            }
            if (!TerrainDestruction.canUnitClimbLadders(this.mob)) continue;
            for (int[] verticalNeighbor : VERTICAL_NEIGHBORS) {
                neighborPos = current.pos.m_7918_(verticalNeighbor[0], verticalNeighbor[1], verticalNeighbor[2]);
                if (closedSet.contains(neighborPos) || current.pos.m_123331_((Vec3i)start) > 16384.0 || !this.isValidVerticalPosition(neighborPos, current.pos)) continue;
                moveCost = this.calculateVerticalMoveCost(current.pos, neighborPos);
                tentativeGScore = current.gCost + moveCost;
                if (gScores.containsKey(neighborPos) && tentativeGScore >= (Double)gScores.get(neighborPos)) continue;
                gScores.put(neighborPos, tentativeGScore);
                neighborNode = new PathNode(neighborPos, tentativeGScore, this.heuristic(neighborPos, goal), current);
                openSet.add(neighborNode);
            }
        }
        return null;
    }

    private boolean isWithinReachRange(BlockPos pos, BlockPos goal, int reachRange) {
        return pos.m_123331_((Vec3i)goal) <= (double)(reachRange * reachRange);
    }

    private double heuristic(BlockPos from, BlockPos to) {
        int dx = Math.abs(from.m_123341_() - to.m_123341_());
        int dy = Math.abs(from.m_123342_() - to.m_123342_());
        int dz = Math.abs(from.m_123343_() - to.m_123343_());
        int diagonalXZ = Math.min(dx, dz);
        int straightXZ = Math.abs(dx - dz);
        return 1.414 * (double)diagonalXZ + 1.0 * (double)straightXZ + 0.5 * (double)dy;
    }

    private double calculateMoveCost(BlockPos from, BlockPos to) {
        int dx = Math.abs(from.m_123341_() - to.m_123341_());
        int dz = Math.abs(from.m_123343_() - to.m_123343_());
        double baseCost = dx > 0 && dz > 0 ? 1.414 : 1.0;
        int dy = Math.abs(from.m_123342_() - to.m_123342_());
        baseCost += (double)dy * 0.5;
        if (this.isInsideBuilding(to)) {
            baseCost += 2.0;
        }
        baseCost += this.getTerrainCost(to);
        return baseCost += this.getDestructionCost(to);
    }

    private double getTerrainCost(BlockPos pos) {
        BlockState groundState = this.level.m_8055_(pos.m_7495_());
        BlockState blockState = this.level.m_8055_(pos);
        if (blockState.m_278721_()) {
            return 3.0;
        }
        if (groundState.m_60734_().m_7705_().contains("sand") || groundState.m_60734_().m_7705_().contains("gravel")) {
            return 1.5;
        }
        if (groundState.m_60734_().m_7705_().contains("soul_sand")) {
            return 2.0;
        }
        return 0.0;
    }

    private double getDestructionCost(BlockPos pos) {
        BlockState aboveState;
        if (!TerrainDestruction.canUnitDestroy(this.mob)) {
            return 0.0;
        }
        double totalCost = 0.0;
        BlockState blockState = this.level.m_8055_(pos);
        if (!blockState.m_60795_() && TerrainDestruction.isDestructible(blockState)) {
            totalCost = TerrainDestruction.shouldDestroy(blockState) ? (totalCost += TerrainDestruction.getDestructionCost(blockState) * 1.2) : (totalCost += TerrainDestruction.getDestructionCost(blockState) * 1.2 * 2.0);
        }
        if (!(aboveState = this.level.m_8055_(pos.m_7494_())).m_60795_() && TerrainDestruction.isDestructible(aboveState)) {
            totalCost = TerrainDestruction.shouldDestroy(aboveState) ? (totalCost += TerrainDestruction.getDestructionCost(aboveState) * 1.2) : (totalCost += TerrainDestruction.getDestructionCost(aboveState) * 1.2 * 2.0);
        }
        return totalCost;
    }

    private boolean isInsideBuilding(BlockPos pos) {
        BuildingPlacement building = BuildingUtils.findBuilding(this.level.m_5776_(), pos);
        return building != null && !building.ownerName.equals(((Unit)this.mob).getOwnerName());
    }

    private boolean isValidPosition(BlockPos pos, BlockPos from) {
        if (!this.level.m_6857_().m_61937_(pos) || pos.m_123342_() < this.level.m_141937_() || pos.m_123342_() > this.level.m_151558_()) {
            return false;
        }
        if (!this.isPassable(pos)) {
            return false;
        }
        int heightDiff = Math.abs(pos.m_123342_() - from.m_123342_());
        if (heightDiff > 3) {
            return false;
        }
        Mob mob = this.mob;
        if (mob instanceof Unit) {
            Unit unit = (Unit)mob;
            String mobTypeName = this.mob.m_6095_().m_20675_();
            if (mobTypeName.contains("ghast") || mobTypeName.contains("blaze")) {
                return this.isValidFlyingPosition(pos);
            }
        }
        return true;
    }

    private boolean isPassable(BlockPos pos) {
        Mob mob;
        BlockState blockState = this.level.m_8055_(pos);
        BlockState aboveState = this.level.m_8055_(pos.m_7494_());
        BlockState belowState = this.level.m_8055_(pos.m_7495_());
        if (!belowState.m_280296_() && !belowState.m_278721_()) {
            return false;
        }
        if (!blockState.m_60795_() && blockState.m_280296_()) {
            if (TerrainDestruction.isDestructible(blockState) && TerrainDestruction.canUnitDestroy(this.mob) && TerrainDestruction.shouldDestroy(blockState)) {
                this.planDestruction(pos, pos, blockState);
            } else {
                return false;
            }
        }
        if (!aboveState.m_60795_() && aboveState.m_280296_()) {
            if (TerrainDestruction.isDestructible(aboveState) && TerrainDestruction.canUnitDestroy(this.mob) && TerrainDestruction.shouldDestroy(aboveState)) {
                this.planDestruction(pos, pos.m_7494_(), aboveState);
            } else {
                return false;
            }
        }
        if ((blockState.m_278721_() || belowState.m_278721_()) && (mob = this.mob) instanceof Unit) {
            Unit unit = (Unit)mob;
            String mobTypeName = this.mob.m_6095_().m_20675_();
            if (blockState.m_60734_().m_7705_().contains("lava")) {
                return mobTypeName.contains("blaze") || mobTypeName.contains("ghast") || mobTypeName.contains("magma") || mobTypeName.contains("wither");
            }
            if (blockState.m_60734_().m_7705_().contains("water")) {
                return mobTypeName.contains("drowned") || !mobTypeName.contains("enderman");
            }
        }
        return true;
    }

    private boolean isValidFlyingPosition(BlockPos pos) {
        BlockState blockState = this.level.m_8055_(pos);
        return blockState.m_60795_();
    }

    private boolean isValidVerticalPosition(BlockPos to, BlockPos from) {
        boolean movingDown;
        if (!this.level.m_6857_().m_61937_(to) || to.m_123342_() < this.level.m_141937_() || to.m_123342_() > this.level.m_151558_()) {
            return false;
        }
        boolean movingUp = to.m_123342_() > from.m_123342_();
        boolean bl = movingDown = to.m_123342_() < from.m_123342_();
        if (movingDown) {
            int fallDistance;
            boolean hasLadderAtDestination;
            BlockState fromState = this.level.m_8055_(from);
            BlockState toState = this.level.m_8055_(to);
            boolean canUseLadderFromHere = fromState.m_60734_() == Blocks.f_50155_;
            boolean bl2 = hasLadderAtDestination = toState.m_60734_() == Blocks.f_50155_;
            if (canUseLadderFromHere || hasLadderAtDestination) {
                if (toState.m_60795_() || toState.m_60734_() == Blocks.f_50155_) {
                    return true;
                }
                if (TerrainDestruction.isDestructible(toState) && TerrainDestruction.shouldDestroy(toState)) {
                    this.planDestruction(to, to, toState);
                    return true;
                }
            }
            if (!canUseLadderFromHere && TerrainDestruction.canPlaceLadder(this.level, from)) {
                this.planLadderPlacement(from, from);
                return true;
            }
            if (!hasLadderAtDestination && TerrainDestruction.canPlaceLadder(this.level, to)) {
                this.planLadderPlacement(to, to);
                return true;
            }
            BlockState belowState = this.level.m_8055_(to.m_7495_());
            return belowState.m_280296_() && toState.m_60795_() && (fallDistance = from.m_123342_() - to.m_123342_()) <= 3;
        }
        BlockState currentState = this.level.m_8055_(to);
        if (currentState.m_60734_() == Blocks.f_50155_) {
            return true;
        }
        if (TerrainDestruction.canPlaceLadder(this.level, to)) {
            this.planLadderPlacement(to, to);
            return true;
        }
        if (!currentState.m_60795_()) {
            if (TerrainDestruction.isDestructible(currentState) && TerrainDestruction.shouldDestroy(currentState)) {
                this.planDestruction(to, to, currentState);
                if (TerrainDestruction.canPlaceLadder(this.level, to)) {
                    this.planLadderPlacement(to, to);
                    return true;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    private double calculateVerticalMoveCost(BlockPos from, BlockPos to) {
        BlockState currentState;
        boolean movingUp = to.m_123342_() > from.m_123342_();
        boolean movingDown = to.m_123342_() < from.m_123342_();
        double baseCost = TerrainDestruction.getLadderClimbingCost();
        if (movingDown) {
            int fallDistance;
            boolean hasLadderAtDestination;
            BlockState fromState = this.level.m_8055_(from);
            BlockState toState = this.level.m_8055_(to);
            boolean canUseLadderFromHere = fromState.m_60734_() == Blocks.f_50155_;
            boolean bl = hasLadderAtDestination = toState.m_60734_() == Blocks.f_50155_;
            if ((canUseLadderFromHere || hasLadderAtDestination) && (toState.m_60795_() || toState.m_60734_() == Blocks.f_50155_)) {
                return baseCost * 0.8;
            }
            if (!canUseLadderFromHere && TerrainDestruction.canPlaceLadder(this.level, from)) {
                baseCost += TerrainDestruction.getLadderPlacementCost();
            }
            if (!hasLadderAtDestination && TerrainDestruction.canPlaceLadder(this.level, to)) {
                baseCost += TerrainDestruction.getLadderPlacementCost();
            }
            BlockState belowToState = this.level.m_8055_(to.m_7495_());
            if (toState.m_60795_() && belowToState.m_280296_() && (fallDistance = from.m_123342_() - to.m_123342_()) <= 3) {
                return 0.2 + (double)fallDistance * 0.1;
            }
            if (!toState.m_60795_() && TerrainDestruction.isDestructible(toState)) {
                baseCost += TerrainDestruction.getDestructionCost(toState) * 1.2;
            }
        } else if (movingUp && (currentState = this.level.m_8055_(to)).m_60734_() != Blocks.f_50155_) {
            baseCost += TerrainDestruction.getLadderPlacementCost();
            if (!currentState.m_60795_() && TerrainDestruction.isDestructible(currentState)) {
                baseCost += TerrainDestruction.getDestructionCost(currentState) * 1.2;
            }
        }
        return baseCost;
    }

    private void planDestruction(BlockPos pathPos, BlockPos blockPos, BlockState blockState) {
        this.plannedDestructions.computeIfAbsent(pathPos, k -> new HashSet()).add(blockPos);
        this.destructionTimes.put(blockPos, TerrainDestruction.getDestructionTime(blockState));
    }

    private void planLadderPlacement(BlockPos pathPos, BlockPos ladderPos) {
        this.plannedLadderPlacements.computeIfAbsent(pathPos, k -> new HashSet()).add(ladderPos);
        this.ladderPlacementTimes.put(ladderPos, TerrainDestruction.getLadderPlacementTime());
    }

    private Path reconstructDestructionPath(PathNode goalNode, BlockPos target) {
        ArrayList<Node> pathNodes = new ArrayList<Node>();
        PathNode current = goalNode;
        while (current != null) {
            pathNodes.add(0, new Node(current.pos.m_123341_(), current.pos.m_123342_(), current.pos.m_123343_()));
            current = current.parent;
        }
        if (!this.plannedDestructions.isEmpty() || !this.plannedLadderPlacements.isEmpty()) {
            BlockPos pathPos;
            DestructionPath.Builder builder = new DestructionPath.Builder().addNodes(pathNodes).setTarget(target).setReachesTarget(true);
            for (Map.Entry<BlockPos, Set<BlockPos>> entry : this.plannedDestructions.entrySet()) {
                pathPos = entry.getKey();
                for (BlockPos blockPos : entry.getValue()) {
                    int destructionTime = this.destructionTimes.getOrDefault(blockPos, 20);
                    builder.addDestructionCommand(pathPos, blockPos, destructionTime);
                }
            }
            for (Map.Entry<BlockPos, Set<BlockPos>> entry : this.plannedLadderPlacements.entrySet()) {
                pathPos = entry.getKey();
                for (BlockPos ladderPos : entry.getValue()) {
                    int placementTime = this.ladderPlacementTimes.getOrDefault(ladderPos, TerrainDestruction.getLadderPlacementTime());
                    builder.addLadderPlacement(pathPos, ladderPos, placementTime);
                }
            }
            return builder.build();
        }
        return new Path(pathNodes, target, true);
    }

    private Path reconstructPath(PathNode goalNode) {
        return this.reconstructDestructionPath(goalNode, goalNode.pos);
    }

    private Path createSingleNodePath(BlockPos pos) {
        Node node = new Node(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        return new Path(Collections.singletonList(node), pos, true);
    }
}

