/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding;

import com.solegendary.reignofnether.unit.pathfinding.TerrainDestruction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class DestructionPath
extends Path {
    private final Map<BlockPos, Set<BlockPos>> destructionCommands;
    private final Map<BlockPos, Integer> destructionTimes;
    private final Map<BlockPos, Set<BlockPos>> ladderPlacements;
    private final Map<BlockPos, Integer> ladderPlacementTimes;

    public DestructionPath(List<Node> nodes, BlockPos target, boolean reachesTarget, Map<BlockPos, Set<BlockPos>> destructionCommands, Map<BlockPos, Integer> destructionTimes, Map<BlockPos, Set<BlockPos>> ladderPlacements, Map<BlockPos, Integer> ladderPlacementTimes) {
        super(nodes, target, reachesTarget);
        this.destructionCommands = new HashMap<BlockPos, Set<BlockPos>>(destructionCommands);
        this.destructionTimes = new HashMap<BlockPos, Integer>(destructionTimes);
        this.ladderPlacements = new HashMap<BlockPos, Set<BlockPos>>(ladderPlacements);
        this.ladderPlacementTimes = new HashMap<BlockPos, Integer>(ladderPlacementTimes);
    }

    public Set<BlockPos> getDestructionCommandsAt(BlockPos pathPos) {
        return this.destructionCommands.getOrDefault(pathPos, Collections.emptySet());
    }

    public int getDestructionTime(BlockPos blockPos) {
        return this.destructionTimes.getOrDefault(blockPos, 20);
    }

    public Set<BlockPos> getLadderPlacementsAt(BlockPos pathPos) {
        return this.ladderPlacements.getOrDefault(pathPos, Collections.emptySet());
    }

    public int getLadderPlacementTime(BlockPos ladderPos) {
        return this.ladderPlacementTimes.getOrDefault(ladderPos, TerrainDestruction.getLadderPlacementTime());
    }

    public boolean requiresDestruction() {
        return !this.destructionCommands.isEmpty();
    }

    public boolean requiresLadderPlacements() {
        return !this.ladderPlacements.isEmpty();
    }

    public boolean requiresModifications() {
        return this.requiresDestruction() || this.requiresLadderPlacements();
    }

    public Set<BlockPos> getAllDestructionTargets() {
        HashSet<BlockPos> allTargets = new HashSet<BlockPos>();
        for (Set<BlockPos> targets : this.destructionCommands.values()) {
            allTargets.addAll(targets);
        }
        return allTargets;
    }

    public int getTotalDestructionTime() {
        int totalTime = 0;
        for (BlockPos blockPos : this.getAllDestructionTargets()) {
            totalTime += this.getDestructionTime(blockPos);
        }
        return totalTime;
    }

    public Path toRegularPath() {
        return new Path(this.f_77362_, this.m_77406_(), this.m_77403_());
    }

    public static class Builder {
        private final List<Node> nodes = new ArrayList<Node>();
        private final Map<BlockPos, Set<BlockPos>> destructionCommands = new HashMap<BlockPos, Set<BlockPos>>();
        private final Map<BlockPos, Integer> destructionTimes = new HashMap<BlockPos, Integer>();
        private final Map<BlockPos, Set<BlockPos>> ladderPlacements = new HashMap<BlockPos, Set<BlockPos>>();
        private final Map<BlockPos, Integer> ladderPlacementTimes = new HashMap<BlockPos, Integer>();
        private BlockPos target;
        private boolean reachesTarget = true;

        public Builder setTarget(BlockPos target) {
            this.target = target;
            return this;
        }

        public Builder setReachesTarget(boolean reachesTarget) {
            this.reachesTarget = reachesTarget;
            return this;
        }

        public Builder addNode(Node node) {
            this.nodes.add(node);
            return this;
        }

        public Builder addNodes(List<Node> nodes) {
            this.nodes.addAll(nodes);
            return this;
        }

        public Builder addDestructionCommand(BlockPos pathPos, BlockPos blockToDestroy, int destructionTime) {
            this.destructionCommands.computeIfAbsent(pathPos, k -> new HashSet()).add(blockToDestroy);
            this.destructionTimes.put(blockToDestroy, destructionTime);
            return this;
        }

        public Builder addLadderPlacement(BlockPos pathPos, BlockPos ladderPos, int placementTime) {
            this.ladderPlacements.computeIfAbsent(pathPos, k -> new HashSet()).add(ladderPos);
            this.ladderPlacementTimes.put(ladderPos, placementTime);
            return this;
        }

        public DestructionPath build() {
            return new DestructionPath(this.nodes, this.target, this.reachesTarget, this.destructionCommands, this.destructionTimes, this.ladderPlacements, this.ladderPlacementTimes);
        }
    }
}

