/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding;

import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.pathfinding.DestructionPath;
import com.solegendary.reignofnether.unit.pathfinding.TerrainDestruction;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;

public class DestructiveMovementGoal
extends MoveToTargetBlockGoal {
    private DestructionPath destructionPath;
    private BlockPos currentDestructionTarget;
    private int destructionProgress;
    private int totalDestructionTime;
    private boolean isDestroying;
    private double speedModifier;
    private BlockPos currentLadderTarget;
    private int ladderPlacementProgress;
    private int totalLadderPlacementTime;
    private boolean isPlacingLadder;

    public DestructiveMovementGoal(Mob mob, double speedModifier, int moveReachRange, boolean persistent) {
        super(mob, persistent, moveReachRange);
        this.speedModifier = speedModifier;
        this.isDestroying = false;
        this.isPlacingLadder = false;
    }

    public void m_8037_() {
        Path path = this.mob.m_21573_().m_26570_();
        if (path instanceof DestructionPath) {
            DestructionPath dPath;
            this.destructionPath = dPath = (DestructionPath)path;
            this.handleDestructivePath();
        } else {
            super.m_8037_();
        }
    }

    private void handleDestructivePath() {
        if (this.destructionPath == null) {
            super.m_8037_();
            return;
        }
        BlockPos currentPos = this.mob.m_20097_();
        Set<BlockPos> destructionTargets = this.destructionPath.getDestructionCommandsAt(currentPos);
        Set<BlockPos> ladderTargets = this.destructionPath.getLadderPlacementsAt(currentPos);
        if (!(destructionTargets.isEmpty() || this.isDestroying || this.isPlacingLadder)) {
            this.startDestruction(destructionTargets);
        } else if (!(ladderTargets.isEmpty() || this.isPlacingLadder || this.isDestroying)) {
            this.startLadderPlacement(ladderTargets);
        }
        if (this.isDestroying) {
            this.continueDestruction();
        } else if (this.isPlacingLadder) {
            this.continueLadderPlacement();
        } else {
            super.m_8037_();
        }
    }

    private void startDestruction(Set<BlockPos> targets) {
        for (BlockPos target : targets) {
            if (!this.mob.m_9236_().m_8055_(target).m_280296_() || !TerrainDestruction.isDestructible(this.mob.m_9236_().m_8055_(target))) continue;
            this.currentDestructionTarget = target;
            this.totalDestructionTime = this.destructionPath.getDestructionTime(target);
            this.destructionProgress = 0;
            this.isDestroying = true;
            this.mob.m_21573_().m_26573_();
            this.mob.m_21563_().m_24946_((double)target.m_123341_() + 0.5, (double)target.m_123342_() + 0.5, (double)target.m_123343_() + 0.5);
            break;
        }
    }

    private void continueDestruction() {
        if (this.currentDestructionTarget == null) {
            this.isDestroying = false;
            return;
        }
        if (this.mob.m_9236_().m_8055_(this.currentDestructionTarget).m_60795_()) {
            this.finishDestruction();
            return;
        }
        this.mob.m_21563_().m_24946_((double)this.currentDestructionTarget.m_123341_() + 0.5, (double)this.currentDestructionTarget.m_123342_() + 0.5, (double)this.currentDestructionTarget.m_123343_() + 0.5);
        ++this.destructionProgress;
        if (this.destructionProgress % 5 == 0) {
            this.addBreakingParticles();
        }
        if (this.destructionProgress >= this.totalDestructionTime) {
            TerrainDestruction.destroyBlock(this.mob.m_9236_(), this.currentDestructionTarget, this.mob);
            this.finishDestruction();
        }
    }

    private void finishDestruction() {
        this.isDestroying = false;
        this.currentDestructionTarget = null;
        this.destructionProgress = 0;
        this.totalDestructionTime = 0;
        if (this.destructionPath != null) {
            this.mob.m_21573_().m_26536_((Path)this.destructionPath, this.speedModifier);
        }
    }

    private void startLadderPlacement(Set<BlockPos> targets) {
        for (BlockPos target : targets) {
            if (!TerrainDestruction.canPlaceLadder(this.mob.m_9236_(), target)) continue;
            this.currentLadderTarget = target;
            this.totalLadderPlacementTime = this.destructionPath.getLadderPlacementTime(target);
            this.ladderPlacementProgress = 0;
            this.isPlacingLadder = true;
            this.mob.m_21573_().m_26573_();
            this.mob.m_21563_().m_24946_((double)target.m_123341_() + 0.5, (double)target.m_123342_() + 0.5, (double)target.m_123343_() + 0.5);
            break;
        }
    }

    private void continueLadderPlacement() {
        if (this.currentLadderTarget == null) {
            this.isPlacingLadder = false;
            return;
        }
        if (this.mob.m_9236_().m_8055_(this.currentLadderTarget).m_60734_() == Blocks.f_50155_) {
            this.finishLadderPlacement();
            return;
        }
        this.mob.m_21563_().m_24946_((double)this.currentLadderTarget.m_123341_() + 0.5, (double)this.currentLadderTarget.m_123342_() + 0.5, (double)this.currentLadderTarget.m_123343_() + 0.5);
        ++this.ladderPlacementProgress;
        if (this.ladderPlacementProgress % 8 == 0) {
            this.addPlacementParticles();
        }
        if (this.ladderPlacementProgress >= this.totalLadderPlacementTime) {
            TerrainDestruction.placeLadder(this.mob.m_9236_(), this.currentLadderTarget, this.mob);
            this.finishLadderPlacement();
        }
    }

    private void finishLadderPlacement() {
        this.isPlacingLadder = false;
        this.currentLadderTarget = null;
        this.ladderPlacementProgress = 0;
        this.totalLadderPlacementTime = 0;
        if (this.destructionPath != null) {
            this.mob.m_21573_().m_26536_((Path)this.destructionPath, this.speedModifier);
        }
    }

    private void addPlacementParticles() {
        if (this.currentLadderTarget == null || this.mob.m_9236_().f_46443_) {
            return;
        }
        BlockState woodState = Blocks.f_50705_.m_49966_();
        this.mob.m_9236_().m_46796_(2001, this.currentLadderTarget, Block.m_49956_((BlockState)woodState));
    }

    private void addBreakingParticles() {
        if (this.currentDestructionTarget == null || this.mob.m_9236_().f_46443_) {
            return;
        }
        BlockState blockState = this.mob.m_9236_().m_8055_(this.currentDestructionTarget);
        if (!blockState.m_60795_()) {
            int breakingStage = (int)((float)this.destructionProgress / (float)this.totalDestructionTime * 9.0f);
            breakingStage = Math.min(9, Math.max(0, breakingStage));
            this.mob.m_9236_().m_6801_(this.mob.m_19879_(), this.currentDestructionTarget, breakingStage);
        }
    }

    public void m_8041_() {
        super.m_8041_();
        if (this.isDestroying && this.currentDestructionTarget != null) {
            this.mob.m_9236_().m_6801_(this.mob.m_19879_(), this.currentDestructionTarget, -1);
        }
        if (!this.isPlacingLadder || this.currentLadderTarget != null) {
            // empty if block
        }
        this.isDestroying = false;
        this.currentDestructionTarget = null;
        this.destructionProgress = 0;
        this.isPlacingLadder = false;
        this.currentLadderTarget = null;
        this.ladderPlacementProgress = 0;
        this.destructionPath = null;
    }

    public boolean isDestroying() {
        return this.isDestroying;
    }

    public BlockPos getCurrentDestructionTarget() {
        return this.currentDestructionTarget;
    }

    public float getDestructionProgress() {
        if (!this.isDestroying || this.totalDestructionTime <= 0) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)this.destructionProgress / (float)this.totalDestructionTime);
    }

    public boolean isPlacingLadder() {
        return this.isPlacingLadder;
    }

    public BlockPos getCurrentLadderTarget() {
        return this.currentLadderTarget;
    }

    public float getLadderPlacementProgress() {
        if (!this.isPlacingLadder || this.totalLadderPlacementTime <= 0) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)this.ladderPlacementProgress / (float)this.totalLadderPlacementTime);
    }

    public boolean isBusyWithModifications() {
        return this.isDestroying || this.isPlacingLadder;
    }
}

