/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.pathfinder.Path;

public class PathfindingCache {
    private static final int MAX_CACHE_SIZE = 1000;
    private static final long CACHE_TIMEOUT_MS = 15000L;
    private static final int CLEANUP_BATCH_SIZE = 100;
    private static final long CLEANUP_INTERVAL_MS = 5000L;
    private static final ConcurrentHashMap<PathKey, CachedPath> cache = new ConcurrentHashMap();
    private static final ReentrantReadWriteLock cleanupLock = new ReentrantReadWriteLock();
    private static final AtomicLong cacheHits = new AtomicLong(0L);
    private static final AtomicLong cacheMisses = new AtomicLong(0L);
    private static final AtomicLong cacheEvictions = new AtomicLong(0L);
    private static volatile long lastCleanupTime = System.currentTimeMillis();

    public static void putPath(BlockPos start, BlockPos goal, int reachRange, @Nullable Path path) {
        CachedPath cachedPath;
        PathKey key;
        CachedPath existing;
        if (PathfindingCache.shouldCleanup()) {
            PathfindingCache.performMaintenance();
        }
        if ((existing = cache.putIfAbsent(key = new PathKey(start, goal, reachRange), cachedPath = new CachedPath(path, System.currentTimeMillis(), 1L))) != null) {
            existing.incrementUsage();
        }
    }

    @Nullable
    public static Path getPath(BlockPos start, BlockPos goal, int reachRange) {
        PathKey key = new PathKey(start, goal, reachRange);
        CachedPath cached = cache.get(key);
        if (cached == null) {
            cacheMisses.incrementAndGet();
            return null;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - cached.timestamp > 15000L) {
            cache.remove(key);
            cacheEvictions.incrementAndGet();
            cacheMisses.incrementAndGet();
            return null;
        }
        cached.incrementUsage();
        cached.updateAccessTime(currentTime);
        cacheHits.incrementAndGet();
        return cached.path;
    }

    public static void clearCache() {
        cache.clear();
        cacheHits.set(0L);
        cacheMisses.set(0L);
        cacheEvictions.set(0L);
    }

    public static CacheStatistics getStatistics() {
        long hits = cacheHits.get();
        long misses = cacheMisses.get();
        long evictions = cacheEvictions.get();
        return new CacheStatistics(cache.size(), hits, misses, evictions, hits + misses > 0L ? (double)hits / (double)(hits + misses) : 0.0);
    }

    public static void invalidateArea(BlockPos center, int radius) {
        double radiusSquared = radius * radius;
        cache.entrySet().removeIf(entry -> {
            boolean shouldRemove;
            PathKey key = (PathKey)entry.getKey();
            boolean bl = shouldRemove = key.start.m_123331_((Vec3i)center) <= radiusSquared || key.goal.m_123331_((Vec3i)center) <= radiusSquared;
            if (shouldRemove) {
                cacheEvictions.incrementAndGet();
            }
            return shouldRemove;
        });
    }

    private static boolean shouldCleanup() {
        return cache.size() >= 1000 || System.currentTimeMillis() - lastCleanupTime > 5000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performMaintenance() {
        cleanupLock.writeLock().lock();
        try {
            long currentTime;
            if (!PathfindingCache.shouldCleanup()) {
                return;
            }
            lastCleanupTime = currentTime = System.currentTimeMillis();
            int removed = 0;
            Iterator<Map.Entry<PathKey, CachedPath>> iterator = cache.entrySet().iterator();
            while (iterator.hasNext() && removed < 100) {
                Map.Entry<PathKey, CachedPath> entry2 = iterator.next();
                if (currentTime - entry2.getValue().timestamp <= 15000L) continue;
                iterator.remove();
                cacheEvictions.incrementAndGet();
                ++removed;
            }
            if (cache.size() >= 1000) {
                cache.entrySet().stream().sorted((e1, e2) -> Long.compare(((CachedPath)e1.getValue()).lastAccessTime, ((CachedPath)e2.getValue()).lastAccessTime)).limit(250L).forEach(entry -> {
                    cache.remove(entry.getKey());
                    cacheEvictions.incrementAndGet();
                });
            }
        }
        finally {
            cleanupLock.writeLock().unlock();
        }
    }

    private static class PathKey {
        private final BlockPos start;
        private final BlockPos goal;
        private final int reachRange;
        private final int hashCode;

        public PathKey(BlockPos start, BlockPos goal, int reachRange) {
            this.start = start;
            this.goal = goal;
            this.reachRange = reachRange;
            this.hashCode = this.computeHashCode();
        }

        private int computeHashCode() {
            int result = this.start.hashCode();
            result = 31 * result + this.goal.hashCode();
            result = 31 * result + this.reachRange;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PathKey pathKey = (PathKey)obj;
            return this.reachRange == pathKey.reachRange && this.start.equals((Object)pathKey.start) && this.goal.equals((Object)pathKey.goal);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class CachedPath {
        final Path path;
        final long timestamp;
        private volatile long lastAccessTime;
        private final AtomicLong usageCount;

        CachedPath(Path path, long timestamp, long initialUsage) {
            this.path = path;
            this.timestamp = timestamp;
            this.lastAccessTime = timestamp;
            this.usageCount = new AtomicLong(initialUsage);
        }

        void incrementUsage() {
            this.usageCount.incrementAndGet();
        }

        void updateAccessTime(long accessTime) {
            this.lastAccessTime = accessTime;
        }

        long getUsageCount() {
            return this.usageCount.get();
        }
    }

    public static class CacheStatistics {
        public final int currentSize;
        public final long hits;
        public final long misses;
        public final long evictions;
        public final double hitRate;

        public CacheStatistics(int currentSize, long hits, long misses, long evictions, double hitRate) {
            this.currentSize = currentSize;
            this.hits = hits;
            this.misses = misses;
            this.evictions = evictions;
            this.hitRate = hitRate;
        }

        public String toString() {
            return String.format("CacheStats{size=%d, hits=%d, misses=%d, evictions=%d, hitRate=%.2f%%}", this.currentSize, this.hits, this.misses, this.evictions, this.hitRate * 100.0);
        }
    }
}

