/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding;

import com.solegendary.reignofnether.config.ReignOfNetherCommonConfigs;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.pathfinding.PathfindingManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber
public class PathfindingServerEvents {
    @SubscribeEvent
    public static void onConfigLoad(ModConfigEvent.Loading event) {
        PathfindingServerEvents.updatePathfindingSettings();
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent.Reloading event) {
        PathfindingServerEvents.updatePathfindingSettings();
    }

    private static void updatePathfindingSettings() {
        boolean improvedEnabled = (Boolean)ReignOfNetherCommonConfigs.IMPROVED_PATHFINDING.get();
        PathfindingManager.setImprovedPathfindingEnabled(improvedEnabled);
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Mob && (mob = (Mob)entity) instanceof Unit) {
            event.getLevel().m_7654_().execute(() -> PathfindingManager.upgradeMovementGoals(mob));
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        int x = event.getPos().m_123341_();
        int z = event.getPos().m_123343_();
        PathfindingManager.notifyTerrainChange(x, z, 16);
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        int x = event.getPos().m_123341_();
        int z = event.getPos().m_123343_();
        PathfindingManager.notifyTerrainChange(x, z, 16);
    }

    public static void onBuildingChange(int centerX, int centerZ, int radius) {
        PathfindingManager.notifyTerrainChange(centerX, centerZ, radius);
    }
}

