/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding.async;

import com.solegendary.reignofnether.unit.pathfinding.PathNode;
import com.solegendary.reignofnether.unit.pathfinding.async.PathfindingTask;
import com.solegendary.reignofnether.unit.pathfinding.async.WorldSnapshot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class AsyncPathfinder {
    private static final int DEFAULT_MAX_ITERATIONS = 2000;
    private static final int DEFAULT_MAX_NODES = 5000;
    private final int maxIterations;
    private final int maxNodes;

    public AsyncPathfinder() {
        this(2000, 5000);
    }

    public AsyncPathfinder(int maxIterations, int maxNodes) {
        this.maxIterations = maxIterations;
        this.maxNodes = maxNodes;
    }

    public Path findPath(PathfindingTask task) {
        if (task == null || task.isCancelled()) {
            return null;
        }
        try {
            return this.findPathInternal(task);
        }
        catch (Exception e) {
            System.err.printf("AsyncPathfinder error for entity %d: %s%n", task.getEntityId(), e.getMessage());
            return null;
        }
    }

    private Path findPathInternal(PathfindingTask task) {
        WorldSnapshot world = task.getWorldSnapshot();
        BlockPos start = task.getStartPos();
        BlockPos goal = task.getGoalPos();
        int reachRange = task.getReachRange();
        PriorityQueue<PathNode> openSet = new PriorityQueue<PathNode>();
        HashMap<BlockPos, PathNode> allNodes = new HashMap<BlockPos, PathNode>();
        HashSet<BlockPos> closedSet = new HashSet<BlockPos>();
        PathNode startNode = new PathNode(start, 0.0, this.heuristic(start, goal), null);
        openSet.add(startNode);
        allNodes.put(start, startNode);
        int iterations = 0;
        while (!openSet.isEmpty() && iterations < this.maxIterations) {
            if (task.isCancelled()) {
                return null;
            }
            ++iterations;
            PathNode current = (PathNode)openSet.poll();
            closedSet.add(current.pos);
            if (this.isAtGoal(current.pos, goal, reachRange)) {
                return this.constructPath(current, world);
            }
            if (allNodes.size() > this.maxNodes) break;
            for (BlockPos neighbor : this.getNeighbors(current.pos)) {
                if (closedSet.contains(neighbor) || !world.isValidPosition(neighbor) || !this.isPassable(neighbor, world)) continue;
                double newGCost = current.gCost + this.getMovementCost(current.pos, neighbor, world);
                PathNode neighborNode = (PathNode)allNodes.get(neighbor);
                if (neighborNode == null) {
                    neighborNode = new PathNode(neighbor, newGCost, this.heuristic(neighbor, goal), current);
                    allNodes.put(neighbor, neighborNode);
                    openSet.add(neighborNode);
                    continue;
                }
                if (!(newGCost < neighborNode.gCost)) continue;
                openSet.remove(neighborNode);
                PathNode updatedNode = new PathNode(neighbor, newGCost, this.heuristic(neighbor, goal), current);
                allNodes.put(neighbor, updatedNode);
                openSet.add(updatedNode);
            }
        }
        return null;
    }

    private boolean isPassable(BlockPos pos, WorldSnapshot world) {
        return world.isPassable(pos);
    }

    private double getMovementCost(BlockPos from, BlockPos to, WorldSnapshot world) {
        return world.getMovementCost(from, to);
    }

    private List<BlockPos> getNeighbors(BlockPos pos) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0) continue;
                neighbors.add(pos.m_7918_(dx, 0, dz));
            }
        }
        neighbors.add(pos.m_7494_());
        neighbors.add(pos.m_7495_());
        return neighbors;
    }

    private double heuristic(BlockPos from, BlockPos to) {
        return Math.abs(from.m_123341_() - to.m_123341_()) + Math.abs(from.m_123342_() - to.m_123342_()) + Math.abs(from.m_123343_() - to.m_123343_());
    }

    private boolean isAtGoal(BlockPos current, BlockPos goal, int reachRange) {
        return current.m_123331_((Vec3i)goal) <= (double)(reachRange * reachRange);
    }

    private Path constructPath(PathNode goalNode, WorldSnapshot world) {
        ArrayList<Node> pathNodes = new ArrayList<Node>();
        PathNode current = goalNode;
        while (current != null) {
            BlockPos pos = current.pos;
            Node node = new Node(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            pathNodes.add(node);
            current = current.parent;
        }
        Collections.reverse(pathNodes);
        if (pathNodes.isEmpty()) {
            return null;
        }
        Node[] nodeArray = pathNodes.toArray(new Node[0]);
        return new Path(Arrays.asList(nodeArray), goalNode.pos, true);
    }

    public PathfindingStats getStats() {
        return new PathfindingStats(this.maxIterations, this.maxNodes);
    }

    public static class PathfindingStats {
        public final int maxIterations;
        public final int maxNodes;

        public PathfindingStats(int maxIterations, int maxNodes) {
            this.maxIterations = maxIterations;
            this.maxNodes = maxNodes;
        }

        public String toString() {
            return String.format("PathfindingStats{maxIterations=%d, maxNodes=%d}", this.maxIterations, this.maxNodes);
        }
    }
}

