/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding.async;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateSnapshot {
    private final Map<BlockPos, BlockState> blockStates;
    private final BlockPos minCorner;
    private final BlockPos maxCorner;
    private final int minBuildHeight;
    private final int maxBuildHeight;
    private final boolean isWithinWorldBorder;

    private BlockStateSnapshot(Map<BlockPos, BlockState> blockStates, BlockPos minCorner, BlockPos maxCorner, int minBuildHeight, int maxBuildHeight, boolean isWithinWorldBorder) {
        this.blockStates = new ConcurrentHashMap<BlockPos, BlockState>(blockStates);
        this.minCorner = minCorner;
        this.maxCorner = maxCorner;
        this.minBuildHeight = minBuildHeight;
        this.maxBuildHeight = maxBuildHeight;
        this.isWithinWorldBorder = isWithinWorldBorder;
    }

    public static BlockStateSnapshot create(Level level, BlockPos center, int radius) {
        if (level.m_5776_()) {
            throw new IllegalStateException("BlockStateSnapshot should only be created on the server side");
        }
        BlockPos minCorner = center.m_7918_(-radius, -radius, -radius);
        BlockPos maxCorner = center.m_7918_(radius, radius, radius);
        int worldMinY = level.m_141937_();
        int worldMaxY = level.m_151558_();
        minCorner = new BlockPos(minCorner.m_123341_(), Math.max(minCorner.m_123342_(), worldMinY), minCorner.m_123343_());
        maxCorner = new BlockPos(maxCorner.m_123341_(), Math.min(maxCorner.m_123342_(), worldMaxY), maxCorner.m_123343_());
        ConcurrentHashMap<BlockPos, BlockState> blockStates = new ConcurrentHashMap<BlockPos, BlockState>();
        for (int x = minCorner.m_123341_(); x <= maxCorner.m_123341_(); ++x) {
            for (int y = minCorner.m_123342_(); y <= maxCorner.m_123342_(); ++y) {
                for (int z = minCorner.m_123343_(); z <= maxCorner.m_123343_(); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    try {
                        BlockState state = level.m_8055_(pos);
                        blockStates.put(pos, state);
                        continue;
                    }
                    catch (Exception e) {
                        blockStates.put(pos, Blocks.f_50016_.m_49966_());
                    }
                }
            }
        }
        boolean withinBorder = level.m_6857_().m_61937_(center);
        return new BlockStateSnapshot(blockStates, minCorner, maxCorner, worldMinY, worldMaxY, withinBorder);
    }

    public static BlockStateSnapshot createForPath(Level level, BlockPos start, BlockPos goal, int buffer) {
        int minX = Math.min(start.m_123341_(), goal.m_123341_()) - buffer;
        int maxX = Math.max(start.m_123341_(), goal.m_123341_()) + buffer;
        int minY = Math.min(start.m_123342_(), goal.m_123342_()) - buffer;
        int maxY = Math.max(start.m_123342_(), goal.m_123342_()) + buffer;
        int minZ = Math.min(start.m_123343_(), goal.m_123343_()) - buffer;
        int maxZ = Math.max(start.m_123343_(), goal.m_123343_()) + buffer;
        BlockPos center = new BlockPos((minX + maxX) / 2, (minY + maxY) / 2, (minZ + maxZ) / 2);
        int radius = Math.max(Math.max(maxX - minX, maxY - minY), maxZ - minZ) / 2 + 5;
        return BlockStateSnapshot.create(level, center, radius);
    }

    public BlockState getBlockState(BlockPos pos) {
        BlockState state = this.blockStates.get(pos);
        return state != null ? state : Blocks.f_50016_.m_49966_();
    }

    public boolean isValidPosition(BlockPos pos) {
        return pos.m_123342_() >= this.minBuildHeight && pos.m_123342_() <= this.maxBuildHeight && this.isWithinWorldBorder && this.isWithinSnapshot(pos);
    }

    public boolean isWithinSnapshot(BlockPos pos) {
        return pos.m_123341_() >= this.minCorner.m_123341_() && pos.m_123341_() <= this.maxCorner.m_123341_() && pos.m_123342_() >= this.minCorner.m_123342_() && pos.m_123342_() <= this.maxCorner.m_123342_() && pos.m_123343_() >= this.minCorner.m_123343_() && pos.m_123343_() <= this.maxCorner.m_123343_();
    }

    public boolean isSolid(BlockPos pos) {
        BlockState state = this.getBlockState(pos);
        return state.m_280296_();
    }

    public boolean isAir(BlockPos pos) {
        BlockState state = this.getBlockState(pos);
        return state.m_60795_();
    }

    public boolean isLiquid(BlockPos pos) {
        BlockState state = this.getBlockState(pos);
        return state.m_278721_();
    }

    public Block getBlock(BlockPos pos) {
        return this.getBlockState(pos).m_60734_();
    }

    public boolean canBeReplaced(BlockPos pos) {
        BlockState state = this.getBlockState(pos);
        return state.m_247087_();
    }

    public BlockPos getMinCorner() {
        return this.minCorner;
    }

    public BlockPos getMaxCorner() {
        return this.maxCorner;
    }

    public int getBlockCount() {
        return this.blockStates.size();
    }

    public int getMinBuildHeight() {
        return this.minBuildHeight;
    }

    public int getMaxBuildHeight() {
        return this.maxBuildHeight;
    }

    public String toString() {
        return String.format("BlockStateSnapshot{blocks=%d, area=%s to %s}", this.getBlockCount(), this.minCorner, this.maxCorner);
    }
}

