/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding.async;

import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class BuildingSnapshot {
    private final Map<BlockPos, BuildingInfo> buildingsByPosition;
    private final List<BuildingInfo> allBuildings;
    private final AABB snapshotArea;

    private BuildingSnapshot(Map<BlockPos, BuildingInfo> buildingsByPosition, List<BuildingInfo> allBuildings, AABB snapshotArea) {
        this.buildingsByPosition = new ConcurrentHashMap<BlockPos, BuildingInfo>(buildingsByPosition);
        this.allBuildings = new ArrayList<BuildingInfo>(allBuildings);
        this.snapshotArea = snapshotArea;
    }

    public static BuildingSnapshot create(Level level, BlockPos center, int radius) {
        if (level.m_5776_()) {
            throw new IllegalStateException("BuildingSnapshot should only be created on the server side");
        }
        AABB area = new AABB((double)(center.m_123341_() - radius), (double)(center.m_123342_() - radius), (double)(center.m_123343_() - radius), (double)(center.m_123341_() + radius), (double)(center.m_123342_() + radius), (double)(center.m_123343_() + radius));
        ConcurrentHashMap<BlockPos, BuildingInfo> buildingsByPosition = new ConcurrentHashMap<BlockPos, BuildingInfo>();
        ArrayList<BuildingInfo> allBuildings = new ArrayList<BuildingInfo>();
        try {
            ArrayList<BuildingPlacement> buildings = BuildingServerEvents.getBuildings();
            for (BuildingPlacement building : buildings) {
                double distance;
                BlockPos buildingCenter;
                if (building == null || (buildingCenter = building.centrePos) == null || (distance = center.m_123331_((Vec3i)buildingCenter)) > (double)((radius + 50) * (radius + 50))) continue;
                try {
                    BuildingInfo info = BuildingSnapshot.createBuildingInfo(building);
                    if (info == null) continue;
                    allBuildings.add(info);
                    BlockPos min = info.getMinCorner();
                    BlockPos max = info.getMaxCorner();
                    for (int x = min.m_123341_(); x <= max.m_123341_(); ++x) {
                        for (int y = min.m_123342_(); y <= max.m_123342_(); ++y) {
                            for (int z = min.m_123343_(); z <= max.m_123343_(); ++z) {
                                BlockPos pos = new BlockPos(x, y, z);
                                buildingsByPosition.put(pos, info);
                            }
                        }
                    }
                }
                catch (Exception e) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new BuildingSnapshot(buildingsByPosition, allBuildings, area);
    }

    private static BuildingInfo createBuildingInfo(BuildingPlacement building) {
        try {
            BlockPos centerPos = building.centrePos;
            if (centerPos == null) {
                return null;
            }
            BlockPos minCorner = building.minCorner;
            BlockPos maxCorner = building.maxCorner;
            if (minCorner == null || maxCorner == null) {
                minCorner = centerPos.m_7918_(-5, -5, -5);
                maxCorner = centerPos.m_7918_(5, 5, 5);
            }
            String ownerName = building.ownerName != null ? building.ownerName : "";
            String buildingName = "";
            String buildingType = "";
            boolean isCapitol = building.isCapitol;
            try {
                if (building.getBuilding() != null) {
                    buildingName = building.getBuilding().name;
                    buildingType = building.getBuilding().getClass().getSimpleName();
                }
            }
            catch (Exception e) {
                buildingName = "Unknown";
                buildingType = "Unknown";
            }
            boolean isBuilt = building.isBuilt;
            return new BuildingInfo(centerPos, minCorner, maxCorner, ownerName, buildingName, buildingType, isBuilt, isCapitol);
        }
        catch (Exception e) {
            return null;
        }
    }

    public BuildingInfo getBuildingAt(BlockPos pos) {
        return this.buildingsByPosition.get(pos);
    }

    public boolean hasBuilding(BlockPos pos) {
        return this.buildingsByPosition.containsKey(pos);
    }

    public boolean hasBuildingOwnedBy(BlockPos pos, String playerName) {
        BuildingInfo building = this.getBuildingAt(pos);
        return building != null && building.isOwnedBy(playerName);
    }

    public boolean hasEnemyBuilding(BlockPos pos, String playerName) {
        BuildingInfo building = this.getBuildingAt(pos);
        return building != null && !building.isOwnedBy(playerName);
    }

    public List<BuildingInfo> getAllBuildings() {
        return new ArrayList<BuildingInfo>(this.allBuildings);
    }

    public List<BuildingInfo> getBuildingsOwnedBy(String playerName) {
        ArrayList<BuildingInfo> result = new ArrayList<BuildingInfo>();
        for (BuildingInfo building : this.allBuildings) {
            if (!building.isOwnedBy(playerName)) continue;
            result.add(building);
        }
        return result;
    }

    public List<BuildingInfo> getBuildingsNear(BlockPos pos, int radius) {
        ArrayList<BuildingInfo> result = new ArrayList<BuildingInfo>();
        double radiusSquared = radius * radius;
        for (BuildingInfo building : this.allBuildings) {
            if (!(building.getCenterPos().m_123331_((Vec3i)pos) <= radiusSquared)) continue;
            result.add(building);
        }
        return result;
    }

    public AABB getSnapshotArea() {
        return this.snapshotArea;
    }

    public int getBuildingCount() {
        return this.allBuildings.size();
    }

    public String toString() {
        return String.format("BuildingSnapshot{buildings=%d, area=%s}", this.getBuildingCount(), this.snapshotArea);
    }

    public static class BuildingInfo {
        private final BlockPos centerPos;
        private final BlockPos minCorner;
        private final BlockPos maxCorner;
        private final String ownerName;
        private final String buildingName;
        private final String buildingType;
        private final boolean isBuilt;
        private final boolean isCapitol;
        private final AABB boundingBox;

        private BuildingInfo(BlockPos centerPos, BlockPos minCorner, BlockPos maxCorner, String ownerName, String buildingName, String buildingType, boolean isBuilt, boolean isCapitol) {
            this.centerPos = centerPos;
            this.minCorner = minCorner;
            this.maxCorner = maxCorner;
            this.ownerName = ownerName;
            this.buildingName = buildingName;
            this.buildingType = buildingType;
            this.isBuilt = isBuilt;
            this.isCapitol = isCapitol;
            this.boundingBox = new AABB(minCorner, maxCorner.m_7918_(1, 1, 1));
        }

        public BlockPos getCenterPos() {
            return this.centerPos;
        }

        public BlockPos getMinCorner() {
            return this.minCorner;
        }

        public BlockPos getMaxCorner() {
            return this.maxCorner;
        }

        public String getOwnerName() {
            return this.ownerName;
        }

        public String getBuildingName() {
            return this.buildingName;
        }

        public String getBuildingType() {
            return this.buildingType;
        }

        public boolean isBuilt() {
            return this.isBuilt;
        }

        public boolean isCapitol() {
            return this.isCapitol;
        }

        public AABB getBoundingBox() {
            return this.boundingBox;
        }

        public boolean containsPosition(BlockPos pos) {
            return this.boundingBox.m_82393_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        }

        public boolean isOwnedBy(String playerName) {
            return this.ownerName.equals(playerName);
        }

        public String toString() {
            return String.format("BuildingInfo{%s at %s, owner=%s, built=%s}", this.buildingName, this.centerPos, this.ownerName, this.isBuilt);
        }
    }
}

