/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding.async;

import com.solegendary.reignofnether.unit.pathfinding.AStarPathfinder;
import com.solegendary.reignofnether.unit.pathfinding.PathfindingCache;
import com.solegendary.reignofnether.unit.pathfinding.async.PathfindingCallback;
import com.solegendary.reignofnether.unit.pathfinding.async.PathfindingTask;
import com.solegendary.reignofnether.unit.pathfinding.async.PathfindingThreadPool;
import com.solegendary.reignofnether.unit.pathfinding.async.WorldSnapshot;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.pathfinder.Path;

public class MultiThreadedPathfindingManager {
    private static MultiThreadedPathfindingManager INSTANCE;
    private static final long MAX_SNAPSHOT_AGE_MS = 3000L;
    private static final int DEFAULT_MAX_SEARCH_RADIUS = 200;
    private static final boolean ENABLE_FALLBACK = true;
    private final PathfindingThreadPool threadPool;
    private final AStarPathfinder fallbackPathfinder;
    private final MinecraftServer server;
    private volatile boolean enabled = true;
    private volatile long totalAsyncRequests = 0L;
    private volatile long totalSyncFallbacks = 0L;
    private volatile long totalFailures = 0L;

    private MultiThreadedPathfindingManager(MinecraftServer server) {
        this.server = server;
        this.threadPool = new PathfindingThreadPool(server);
        this.fallbackPathfinder = null;
    }

    public static synchronized void initialize(MinecraftServer server) {
        if (INSTANCE == null) {
            INSTANCE = new MultiThreadedPathfindingManager(server);
        }
    }

    public static MultiThreadedPathfindingManager getInstance() {
        return INSTANCE;
    }

    public static synchronized void shutdown() {
        if (INSTANCE != null) {
            MultiThreadedPathfindingManager.INSTANCE.threadPool.shutdown();
            INSTANCE = null;
        }
    }

    public CompletableFuture<Path> findPathAsync(Mob mob, BlockPos start, BlockPos goal, int reachRange, PathfindingTask.Priority priority, PathfindingCallback callback) {
        ++this.totalAsyncRequests;
        if (!this.enabled || this.threadPool == null) {
            return this.fallbackToSync(mob, start, goal, reachRange, callback);
        }
        Path cachedPath = PathfindingCache.getPath(start, goal, reachRange);
        if (cachedPath != null) {
            CompletableFuture<Path> future = CompletableFuture.completedFuture(cachedPath);
            if (callback != null) {
                callback.onPathfindingComplete(mob.m_19879_(), start, goal, cachedPath, true, null);
            }
            return future;
        }
        WorldSnapshot snapshot = WorldSnapshot.create(mob.m_9236_(), mob, start, goal, 200);
        if (snapshot == null || !snapshot.isValid(3000L)) {
            return this.fallbackToSync(mob, start, goal, reachRange, callback);
        }
        CompletableFuture<Path> future = new CompletableFuture<Path>();
        PathfindingCallback wrappedCallback = (entityId, startPos, goalPos, result, success, errorMessage) -> {
            if (success && result != null) {
                future.complete(result);
                PathfindingCache.putPath(startPos, goalPos, reachRange, result);
            } else {
                future.complete(null);
            }
            if (callback != null) {
                callback.onPathfindingComplete(entityId, startPos, goalPos, result, success, errorMessage);
            }
        };
        PathfindingTask task = new PathfindingTask(mob.m_19879_(), start, goal, reachRange, snapshot, priority, wrappedCallback, 200);
        boolean queued = this.threadPool.submitTask(task);
        if (!queued) {
            return this.fallbackToSync(mob, start, goal, reachRange, callback);
        }
        return future;
    }

    public Path findPathSync(Mob mob, BlockPos start, BlockPos goal, int reachRange) {
        Path cachedPath = PathfindingCache.getPath(start, goal, reachRange);
        if (cachedPath != null) {
            return cachedPath;
        }
        AStarPathfinder pathfinder = new AStarPathfinder(mob.m_9236_(), mob);
        Path result = pathfinder.findPath(start, goal, reachRange);
        if (result != null) {
            PathfindingCache.putPath(start, goal, reachRange, result);
        }
        return result;
    }

    public boolean cancelPathfinding(int entityId) {
        if (this.threadPool != null) {
            return this.threadPool.cancelTasksForEntity(entityId);
        }
        return false;
    }

    public void invalidateArea(BlockPos center, int radius) {
        PathfindingCache.invalidateArea(center, radius);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public PathfindingStatistics getStatistics() {
        PathfindingThreadPool.ThreadPoolStatistics poolStats = null;
        if (this.threadPool != null) {
            poolStats = this.threadPool.getStatistics();
        }
        PathfindingCache.CacheStatistics cacheStats = PathfindingCache.getStatistics();
        return new PathfindingStatistics(this.enabled, this.totalAsyncRequests, this.totalSyncFallbacks, this.totalFailures, poolStats, cacheStats);
    }

    private CompletableFuture<Path> fallbackToSync(Mob mob, BlockPos start, BlockPos goal, int reachRange, PathfindingCallback callback) {
        ++this.totalSyncFallbacks;
        CompletableFuture<Path> future = new CompletableFuture<Path>();
        if (this.server != null && this.server.m_130010_()) {
            this.server.execute(() -> {
                block3: {
                    try {
                        Path result = this.findPathSync(mob, start, goal, reachRange);
                        future.complete(result);
                        if (callback != null) {
                            boolean success = result != null;
                            String errorMessage = success ? null : "Synchronous pathfinding failed";
                            callback.onPathfindingComplete(mob.m_19879_(), start, goal, result, success, errorMessage);
                        }
                    }
                    catch (Exception e) {
                        ++this.totalFailures;
                        future.complete(null);
                        if (callback == null) break block3;
                        callback.onPathfindingComplete(mob.m_19879_(), start, goal, null, false, "Synchronous fallback error: " + e.getMessage());
                    }
                }
            });
        } else {
            future.complete(null);
            ++this.totalFailures;
        }
        return future;
    }

    public static class PathfindingStatistics {
        public final boolean enabled;
        public final long totalAsyncRequests;
        public final long totalSyncFallbacks;
        public final long totalFailures;
        public final PathfindingThreadPool.ThreadPoolStatistics threadPoolStats;
        public final PathfindingCache.CacheStatistics cacheStats;

        public PathfindingStatistics(boolean enabled, long totalAsyncRequests, long totalSyncFallbacks, long totalFailures, PathfindingThreadPool.ThreadPoolStatistics threadPoolStats, PathfindingCache.CacheStatistics cacheStats) {
            this.enabled = enabled;
            this.totalAsyncRequests = totalAsyncRequests;
            this.totalSyncFallbacks = totalSyncFallbacks;
            this.totalFailures = totalFailures;
            this.threadPoolStats = threadPoolStats;
            this.cacheStats = cacheStats;
        }

        public double getFallbackRate() {
            return this.totalAsyncRequests > 0L ? (double)this.totalSyncFallbacks / (double)this.totalAsyncRequests : 0.0;
        }

        public double getFailureRate() {
            long total = this.totalAsyncRequests;
            return total > 0L ? (double)this.totalFailures / (double)total : 0.0;
        }

        public String toString() {
            return String.format("PathfindingStats{enabled=%s, async=%d, fallback=%d (%.1f%%), failures=%d (%.1f%%), %s, %s}", this.enabled, this.totalAsyncRequests, this.totalSyncFallbacks, this.getFallbackRate() * 100.0, this.totalFailures, this.getFailureRate() * 100.0, this.threadPoolStats != null ? this.threadPoolStats.toString() : "No ThreadPool", this.cacheStats != null ? this.cacheStats.toString() : "No Cache");
        }
    }
}

