/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.pathfinding.async;

import com.solegendary.reignofnether.unit.pathfinding.async.BlockStateSnapshot;
import com.solegendary.reignofnether.unit.pathfinding.async.BuildingSnapshot;
import com.solegendary.reignofnether.unit.pathfinding.async.EntitySnapshot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class WorldSnapshot {
    private final BlockStateSnapshot blockSnapshot;
    private final EntitySnapshot entitySnapshot;
    private final BuildingSnapshot buildingSnapshot;
    private final long creationTime;
    private final BlockPos pathStart;
    private final BlockPos pathGoal;
    private final int searchRadius;

    private WorldSnapshot(BlockStateSnapshot blockSnapshot, EntitySnapshot entitySnapshot, BuildingSnapshot buildingSnapshot, BlockPos pathStart, BlockPos pathGoal, int searchRadius) {
        this.blockSnapshot = blockSnapshot;
        this.entitySnapshot = entitySnapshot;
        this.buildingSnapshot = buildingSnapshot;
        this.creationTime = System.currentTimeMillis();
        this.pathStart = pathStart;
        this.pathGoal = pathGoal;
        this.searchRadius = searchRadius;
    }

    public static WorldSnapshot create(Level level, Mob mob, BlockPos start, BlockPos goal, int searchRadius) {
        if (level.m_5776_()) {
            throw new IllegalStateException("WorldSnapshot should only be created on the server side");
        }
        try {
            EntitySnapshot entitySnapshot = EntitySnapshot.create(mob);
            int blockRadius = Math.max(searchRadius + 20, 64);
            BlockStateSnapshot blockSnapshot = BlockStateSnapshot.createForPath(level, start, goal, blockRadius);
            BlockPos center = new BlockPos((start.m_123341_() + goal.m_123341_()) / 2, (start.m_123342_() + goal.m_123342_()) / 2, (start.m_123343_() + goal.m_123343_()) / 2);
            int buildingRadius = Math.max(searchRadius + 30, 80);
            BuildingSnapshot buildingSnapshot = BuildingSnapshot.create(level, center, buildingRadius);
            return new WorldSnapshot(blockSnapshot, entitySnapshot, buildingSnapshot, start, goal, searchRadius);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static WorldSnapshot createAround(Level level, Mob mob, BlockPos center, int radius) {
        BlockPos start = mob.m_20097_();
        BlockPos goal = center;
        return WorldSnapshot.create(level, mob, start, goal, radius);
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.blockSnapshot.getBlockState(pos);
    }

    public boolean isValidPosition(BlockPos pos) {
        return this.blockSnapshot.isValidPosition(pos);
    }

    public boolean isSolid(BlockPos pos) {
        return this.blockSnapshot.isSolid(pos);
    }

    public boolean isAir(BlockPos pos) {
        return this.blockSnapshot.isAir(pos);
    }

    public boolean isLiquid(BlockPos pos) {
        return this.blockSnapshot.isLiquid(pos);
    }

    public Block getBlock(BlockPos pos) {
        return this.blockSnapshot.getBlock(pos);
    }

    public boolean canBeReplaced(BlockPos pos) {
        return this.blockSnapshot.canBeReplaced(pos);
    }

    public EntitySnapshot getEntity() {
        return this.entitySnapshot;
    }

    public int getEntityId() {
        return this.entitySnapshot.getEntityId();
    }

    public BlockPos getEntityPosition() {
        return this.entitySnapshot.getPosition();
    }

    public String getEntityOwner() {
        return this.entitySnapshot.getOwnerName();
    }

    public boolean canEntityFly() {
        return this.entitySnapshot.canFly();
    }

    public boolean canEntitySwim() {
        return this.entitySnapshot.canSwim();
    }

    public boolean canEntityDestroyTerrain() {
        return this.entitySnapshot.canDestroyTerrain();
    }

    public boolean canEntityClimbLadders() {
        return this.entitySnapshot.canClimbLadders();
    }

    public BuildingSnapshot.BuildingInfo getBuildingAt(BlockPos pos) {
        return this.buildingSnapshot.getBuildingAt(pos);
    }

    public boolean hasBuilding(BlockPos pos) {
        return this.buildingSnapshot.hasBuilding(pos);
    }

    public boolean hasBuildingOwnedBy(BlockPos pos, String playerName) {
        return this.buildingSnapshot.hasBuildingOwnedBy(pos, playerName);
    }

    public boolean hasEnemyBuilding(BlockPos pos, String playerName) {
        return this.buildingSnapshot.hasEnemyBuilding(pos, playerName);
    }

    public boolean isPassable(BlockPos pos) {
        if (!this.isValidPosition(pos)) {
            return false;
        }
        BlockState blockState = this.getBlockState(pos);
        BlockState aboveState = this.getBlockState(pos.m_7494_());
        BlockState belowState = this.getBlockState(pos.m_7495_());
        if (!(this.canEntityFly() || belowState.m_280296_() || belowState.m_278721_())) {
            return false;
        }
        if (!blockState.m_60795_() && blockState.m_280296_()) {
            if (this.canEntityDestroyTerrain()) {
                return false;
            }
            return false;
        }
        if (!aboveState.m_60795_() && aboveState.m_280296_()) {
            if (this.canEntityDestroyTerrain()) {
                return false;
            }
            return false;
        }
        if (blockState.m_278721_()) {
            String blockName = blockState.m_60734_().m_7705_();
            if (blockName.contains("lava")) {
                return this.entitySnapshot.canTraverseLava();
            }
            if (blockName.contains("water")) {
                return this.entitySnapshot.canTraverseWater();
            }
        }
        return true;
    }

    public double getMovementCost(BlockPos from, BlockPos to) {
        double baseCost = 1.0;
        int dx = Math.abs(from.m_123341_() - to.m_123341_());
        int dz = Math.abs(from.m_123343_() - to.m_123343_());
        if (dx > 0 && dz > 0) {
            baseCost = 1.414;
        }
        int dy = Math.abs(from.m_123342_() - to.m_123342_());
        baseCost += (double)dy * 0.5;
        BlockState groundState = this.getBlockState(to.m_7495_());
        String blockName = groundState.m_60734_().m_7705_();
        if (blockName.contains("sand") || blockName.contains("gravel")) {
            baseCost *= 1.5;
        } else if (blockName.contains("soul_sand")) {
            baseCost *= 2.0;
        }
        BlockState toState = this.getBlockState(to);
        if (toState.m_278721_()) {
            String liquidName = toState.m_60734_().m_7705_();
            baseCost *= this.entitySnapshot.getTerrainPenalty(liquidName);
        }
        if (this.hasEnemyBuilding(to, this.getEntityOwner())) {
            baseCost += 2.0;
        }
        return baseCost;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getAge() {
        return System.currentTimeMillis() - this.creationTime;
    }

    public BlockPos getPathStart() {
        return this.pathStart;
    }

    public BlockPos getPathGoal() {
        return this.pathGoal;
    }

    public int getSearchRadius() {
        return this.searchRadius;
    }

    public boolean isValid(long maxAgeMs) {
        return this.getAge() < maxAgeMs;
    }

    public boolean coversPath(BlockPos start, BlockPos goal, int radius) {
        return this.blockSnapshot.isWithinSnapshot(start) && this.blockSnapshot.isWithinSnapshot(goal) && this.pathStart.m_123331_((Vec3i)start) < (double)(radius * radius) && this.pathGoal.m_123331_((Vec3i)goal) < (double)(radius * radius);
    }

    public String toString() {
        return String.format("WorldSnapshot{entity=%d, blocks=%d, buildings=%d, age=%dms, path=%s->%s}", this.getEntityId(), this.blockSnapshot.getBlockCount(), this.buildingSnapshot.getBuildingCount(), this.getAge(), this.pathStart, this.pathGoal);
    }
}

