/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.monsters;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.Explode;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.goals.CreeperAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.RandomLookAroundUnitGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.pathfinding.PathfindingManager;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class CreeperUnit
extends Creeper
implements Unit,
AttackerUnit {
    private int eatingTicksLeft = 0;
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    GarrisonGoal garrisonGoal;
    UsePortalGoal usePortalGoal;
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    private CreeperAttackUnitGoal attackGoal;
    private ReturnResourcesGoal returnResourcesGoal;
    private BlockPos attackMoveTarget = null;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    public static final EntityDataAccessor<String> ownerDataAccessor = SynchedEntityData.m_135353_(CreeperUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final float attackDamage = 20.0f;
    public static final float attacksPerSecond = 1.0f;
    public static final float maxHealth = 20.0f;
    public static final float armorValue = 0.0f;
    public static final float movementSpeed = 0.28f;
    public static final float attackRange = 2.0f;
    public static final float aggroRange = 10.0f;
    public static final boolean willRetaliate = true;
    public static final boolean aggressiveWhenIdle = false;
    public static final float EXPLOSION_RADIUS = 3.0f;
    public static final float CHARGED_EXPLOSION_RADIUS = 5.0f;
    public static final float CHARGED_DAMAGE_MULT = 1.7f;
    public static final int maxResources = 0;
    private MeleeAttackBuildingGoal attackBuildingGoal;
    private final List<AbilityButton> abilityButtons = new ArrayList<AbilityButton>();
    private final List<Ability> abilities = new ArrayList<Ability>();
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    private boolean forceSwelling = false;

    @Override
    public void setEatingTicksLeft(int amount) {
        this.eatingTicksLeft = amount;
    }

    @Override
    public int getEatingTicksLeft() {
        return this.eatingTicksLeft;
    }

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return this.garrisonGoal;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    @Override
    public List<AbilityButton> getAbilityButtons() {
        return this.abilityButtons;
    }

    @Override
    public List<Ability> getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return this.attackBuildingGoal;
    }

    @Override
    public Goal getAttackGoal() {
        return this.attackGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return 0;
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
    }

    @Override
    public boolean getWillRetaliate() {
        return true;
    }

    @Override
    public int getAttackCooldown() {
        return 20;
    }

    @Override
    public float getAttacksPerSecond() {
        return 1.0f;
    }

    @Override
    public float getAggroRange() {
        return 10.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return false;
    }

    @Override
    public float getAttackRange() {
        return 2.0f;
    }

    @Override
    public float getMovementSpeed() {
        return 0.28f;
    }

    @Override
    public float getUnitAttackDamage() {
        return 20.0f;
    }

    @Override
    public float getUnitMaxHealth() {
        return 20.0f;
    }

    @Override
    @Nullable
    public ResourceCost getCost() {
        return ResourceCosts.CREEPER;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null;
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    public CreeperUnit(EntityType<? extends Creeper> entityType, Level level) {
        super(entityType, level);
        this.abilities.add(new Explode(this));
        this.updateAbilityButtons();
    }

    public void m_32315_() {
        if (!this.m_9236_().f_46443_) {
            Level.ExplosionInteraction explosion$blockinteraction = ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE;
            float radius = this.m_7090_() ? 5.0f : 3.0f;
            this.f_20890_ = true;
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), radius, explosion$blockinteraction);
            this.m_146870_();
            this.m_32316_();
        }
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public boolean canExplodeOnTarget() {
        LivingEntity target = this.m_5448_();
        return target != null && target.m_20182_().m_82554_(this.m_20182_()) <= 2.0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange()).m_22268_(Attributes.f_22284_, 0.0);
    }

    public void m_8119_() {
        this.m_21553_(false);
        super.m_8119_();
        Unit.tick(this);
        AttackerUnit.tick(this);
        if (this.forceSwelling) {
            this.m_32283_(1);
        } else if (!this.canExplodeOnTarget()) {
            this.m_32283_(-1);
        }
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addUnitSaveData(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readUnitSaveData(pCompound);
    }

    @Override
    public Unit.SunlightEffect getSunlightEffect() {
        return Unit.SunlightEffect.MOVEMENT_SLOWDOWN;
    }

    @Override
    public void resetBehaviours() {
        this.forceSwelling = false;
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = PathfindingManager.createGroundMovementGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, true);
        this.garrisonGoal = new GarrisonGoal((Mob)this);
        this.attackGoal = new CreeperAttackUnitGoal(this, this.getAttackCooldown(), false);
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.garrisonGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21345_.m_25352_(3, (Goal)this.moveGoal);
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundUnitGoal((Mob)this));
    }

    public void startToExplode() {
        this.forceSwelling = true;
    }

    public void m_8038_(ServerLevel pLevel, LightningBolt pLightning) {
        super.m_8038_(pLevel, pLightning);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 1200, 0));
    }
}

