/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.villagers;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.CallToArmsUnit;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.goals.AbstractMeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.BuildRepairGoal;
import com.solegendary.reignofnether.unit.goals.CallToArmsGoal;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.GatherResourcesGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.RandomLookAroundUnitGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.ArmSwingingUnit;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.ConvertableUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.packets.UnitConvertClientboundPacket;
import com.solegendary.reignofnether.unit.packets.UnitSyncClientboundPacket;
import com.solegendary.reignofnether.unit.pathfinding.PathfindingManager;
import com.solegendary.reignofnether.unit.units.villagers.MilitiaUnit;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnitProfession;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class VillagerUnit
extends Vindicator
implements Unit,
WorkerUnit,
AttackerUnit,
ArmSwingingUnit,
VillagerDataHolder,
ConvertableUnit {
    private int eatingTicksLeft = 0;
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    GarrisonGoal garrisonGoal;
    UsePortalGoal usePortalGoal;
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    public BuildRepairGoal buildRepairGoal;
    public GatherResourcesGoal gatherResourcesGoal;
    private ReturnResourcesGoal returnResourcesGoal;
    private AbstractMeleeAttackUnitGoal attackGoal;
    public CallToArmsGoal callToArmsGoal;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    private BlockPos attackMoveTarget = null;
    public static final EntityDataAccessor<String> ownerDataAccessor = SynchedEntityData.m_135353_(VillagerUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public boolean converted = false;
    private boolean shouldDiscard = false;
    public static final float attackDamage = 1.0f;
    public static final float attacksPerSecond = 0.5f;
    public static final float attackRange = 2.0f;
    public static final float aggroRange = 0.0f;
    public static final boolean willRetaliate = false;
    public static final boolean aggressiveWhenIdle = false;
    public static final float maxHealth = 25.0f;
    public static final float armorValue = 0.0f;
    public static final float movementSpeed = 0.25f;
    public int maxResources = 100;
    public boolean isVeteran = false;
    public static final int FARMER_EXP_REQ = 80;
    public int farmerExp = 0;
    public static final float LUMBERJACK_SPEED_MULT = 1.25f;
    public static final float LUMBERJACK_SPEED_MULT_VETERAN = 1.5f;
    public static final int LUMBERJACK_EXP_REQ = 30;
    public int lumberjackExp = 0;
    public static final float MINER_SPEED_MULT = 1.25f;
    public static final float MINER_SPEED_MULT_VETERAN = 1.5f;
    public static final int MINER_EXP_REQ = 6;
    public int minerExp = 0;
    public static final int MASON_EXP_REQ = 600;
    public int masonExp = 0;
    public static final int HUNTER_EXP_REQ = 8;
    public int hunterExp = 0;
    private final List<AbilityButton> abilityButtons = new ArrayList<AbilityButton>();
    private final List<Ability> abilities = new ArrayList<Ability>();
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    private boolean isSwingingArmOnce = false;
    private int swingTime = 0;
    private static final EntityDataAccessor<VillagerData> VILLAGER_DATA = SynchedEntityData.m_135353_(VillagerUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135043_);

    @Override
    public void setEatingTicksLeft(int amount) {
        this.eatingTicksLeft = amount;
    }

    @Override
    public int getEatingTicksLeft() {
        return this.eatingTicksLeft;
    }

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return this.garrisonGoal;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.VILLAGERS;
    }

    @Override
    public List<AbilityButton> getAbilityButtons() {
        return this.abilityButtons;
    }

    @Override
    public List<Ability> getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public BuildRepairGoal getBuildRepairGoal() {
        return this.buildRepairGoal;
    }

    @Override
    public GatherResourcesGoal getGatherResourceGoal() {
        return this.gatherResourcesGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    @Override
    public float getMovementSpeed() {
        return 0.25f;
    }

    @Override
    public float getUnitMaxHealth() {
        return 25.0f;
    }

    @Override
    @Nullable
    public ResourceCost getCost() {
        return ResourceCosts.VILLAGER;
    }

    @Override
    public boolean getWillRetaliate() {
        return false;
    }

    @Override
    public int getAttackCooldown() {
        return 40;
    }

    @Override
    public float getAttacksPerSecond() {
        return 0.5f;
    }

    @Override
    public float getAggroRange() {
        return 0.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return false;
    }

    @Override
    public float getAttackRange() {
        return 2.0f;
    }

    @Override
    public float getUnitAttackDamage() {
        return 1.0f;
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null;
    }

    @Override
    public Goal getAttackGoal() {
        return this.attackGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return null;
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    @Override
    public boolean shouldDiscard() {
        return this.shouldDiscard;
    }

    @Override
    public void setShouldDiscard(boolean discard) {
        this.shouldDiscard = discard;
    }

    @Override
    public BlockState getReplantBlockState() {
        if (this.getUnitProfession() == VillagerUnitProfession.FARMER && !this.isVeteran) {
            return Blocks.f_50249_.m_49966_();
        }
        if (this.getUnitProfession() == VillagerUnitProfession.FARMER && this.isVeteran) {
            return Blocks.f_50250_.m_49966_();
        }
        return Blocks.f_50092_.m_49966_();
    }

    public VillagerUnitProfession getUnitProfession() {
        VillagerProfession profession = this.getProfession();
        if (VillagerProfession.f_35590_.equals((Object)profession)) {
            return VillagerUnitProfession.FARMER;
        }
        if (VillagerProfession.f_35592_.equals((Object)profession)) {
            return VillagerUnitProfession.LUMBERJACK;
        }
        if (VillagerProfession.f_35598_.equals((Object)profession)) {
            return VillagerUnitProfession.MINER;
        }
        if (VillagerProfession.f_35595_.equals((Object)profession)) {
            return VillagerUnitProfession.MASON;
        }
        if (VillagerProfession.f_35599_.equals((Object)profession)) {
            return VillagerUnitProfession.HUNTER;
        }
        return VillagerUnitProfession.NONE;
    }

    public boolean isVeteran() {
        return this.isVeteran;
    }

    public void makeVeteran() {
        this.isVeteran = true;
        UnitSyncClientboundPacket.makeVillagerVeteran((LivingEntity)this);
    }

    public boolean hasSpeedCheat() {
        return !this.m_9236_().m_5776_() && ResearchServerEvents.playerHasCheat(this.getOwnerName(), "operationcwal");
    }

    public void incrementFarmerExp() {
        this.farmerExp += this.hasSpeedCheat() ? 10 : 1;
        if (this.farmerExp >= 40 && !this.hasUnitProfession()) {
            this.setProfession(VillagerProfession.f_35590_);
        } else if (this.farmerExp >= 80 && !this.isVeteran && this.getUnitProfession() == VillagerUnitProfession.FARMER) {
            this.makeVeteran();
        }
    }

    public void incrementLumberjackExp() {
        this.lumberjackExp += this.hasSpeedCheat() ? 10 : 1;
        if (this.lumberjackExp >= 15 && !this.hasUnitProfession()) {
            this.setProfession(VillagerProfession.f_35592_);
        } else if (this.lumberjackExp >= 30 && !this.isVeteran && this.getUnitProfession() == VillagerUnitProfession.LUMBERJACK) {
            this.makeVeteran();
        }
    }

    public void incrementMinerExp() {
        this.minerExp += this.hasSpeedCheat() ? 10 : 1;
        if (this.minerExp >= 3 && !this.hasUnitProfession()) {
            this.setProfession(VillagerProfession.f_35598_);
        } else if (this.minerExp >= 6 && !this.isVeteran && this.getUnitProfession() == VillagerUnitProfession.MINER) {
            this.makeVeteran();
        }
    }

    public void incrementMasonExp() {
        this.masonExp += this.hasSpeedCheat() ? 10 : 1;
        if (this.masonExp >= 300 && !this.hasUnitProfession()) {
            this.setProfession(VillagerProfession.f_35595_);
        } else if (this.masonExp >= 600 && !this.isVeteran && this.getUnitProfession() == VillagerUnitProfession.MASON) {
            this.makeVeteran();
        }
    }

    public void incrementHunterExp() {
        this.hunterExp += this.hasSpeedCheat() ? 10 : 1;
        if (this.hunterExp >= 4 && !this.hasUnitProfession()) {
            this.setProfession(VillagerProfession.f_35599_);
        } else if (this.hunterExp >= 8 && !this.isVeteran && this.getUnitProfession() == VillagerUnitProfession.HUNTER) {
            this.makeVeteran();
        }
    }

    @Override
    public int getSwingTime() {
        return this.swingTime;
    }

    @Override
    public void setSwingTime(int time) {
        this.swingTime = time;
    }

    @Override
    public boolean isSwingingArmOnce() {
        return this.isSwingingArmOnce;
    }

    @Override
    public void setSwingingArmOnce(boolean swing) {
        this.isSwingingArmOnce = swing;
    }

    @Override
    public boolean isSwingingArmRepeatedly() {
        return this.getGatherResourceGoal() != null && this.getGatherResourceGoal().isGathering() || this.getBuildRepairGoal() != null && this.getBuildRepairGoal().isBuilding();
    }

    public static List<AbilityButton> getBuildingButtons() {
        return List.of(Buildings.TOWN_CENTRE.getBuildButton(Keybindings.keyQ), Buildings.OAK_STOCKPILE.getBuildButton(Keybindings.keyW), Buildings.VILLAGER_HOUSE.getBuildButton(Keybindings.keyE), Buildings.WHEAT_FARM.getBuildButton(Keybindings.keyR), Buildings.WATCHTOWER.getBuildButton(Keybindings.keyT), Buildings.BARRACKS.getBuildButton(Keybindings.keyY), Buildings.BLACKSMITH.getBuildButton(Keybindings.keyU), Buildings.ARCANE_TOWER.getBuildButton(Keybindings.keyI), Buildings.LIBRARY.getBuildButton(Keybindings.keyO), Buildings.CASTLE.getBuildButton(Keybindings.keyP), Buildings.SHRINE_OF_PROSPERITY.getBuildButton(Keybindings.keyF), Buildings.IRON_GOLEM_BUILDING.getBuildButton(Keybindings.keyL), Buildings.OAK_BRIDGE.getBuildButton(Keybindings.keyC), Buildings.BEACON.getBuildButton(null));
    }

    public VillagerUnit(EntityType<? extends Vindicator> entityType, Level level) {
        super(entityType, level);
        this.abilities.add(new CallToArmsUnit(level));
        this.updateAbilityButtons();
    }

    @Override
    public void updateAbilityButtons() {
        if (this.m_9236_().m_5776_()) {
            this.abilityButtons.clear();
            this.abilityButtons.addAll(VillagerUnit.getBuildingButtons());
            this.abilityButtons.add(this.abilities.get(0).getButton(Keybindings.keyV));
        }
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange()).m_22268_(Attributes.f_22284_, 0.0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12503_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12505_;
    }

    protected SoundEvent m_7975_(DamageSource p_34103_) {
        return SoundEvents.f_12506_;
    }

    public boolean m_21526_() {
        return false;
    }

    protected void m_7581_(ItemEntity pItemEntity) {
    }

    public void m_8119_() {
        if (this.shouldDiscard) {
            this.m_146870_();
        } else {
            this.m_21553_(true);
            super.m_8119_();
            Unit.tick(this);
            AttackerUnit.tick(this);
            WorkerUnit.tick(this);
            this.callToArmsGoal.m_8037_();
        }
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        DataResult var10000 = VillagerData.f_35550_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.m_7141_());
        var10000.resultOrPartial(err -> ReignOfNether.LOGGER.error("Failed to save villager data")).ifPresent(tag -> pCompound.m_128365_("VillagerData", tag));
        pCompound.m_128405_("farmerExp", this.farmerExp);
        pCompound.m_128405_("lumberjackExp", this.lumberjackExp);
        pCompound.m_128405_("minerExp", this.minerExp);
        pCompound.m_128405_("masonExp", this.masonExp);
        pCompound.m_128405_("hunterExp", this.hunterExp);
        pCompound.m_128379_("isVeteran", this.isVeteran);
        this.addUnitSaveData(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("VillagerData", 10)) {
            DataResult dataresult = VillagerData.f_35550_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)pCompound.m_128423_("VillagerData")));
            dataresult.resultOrPartial(err -> ReignOfNether.LOGGER.error("Failed to load villager data")).ifPresent(this::m_34375_);
        }
        this.farmerExp = pCompound.m_128451_("farmerExp");
        this.lumberjackExp = pCompound.m_128451_("lumberjackExp");
        this.minerExp = pCompound.m_128451_("minerExp");
        this.masonExp = pCompound.m_128451_("masonExp");
        this.hunterExp = pCompound.m_128451_("hunterExp");
        if (!this.m_9236_().m_5776_() && pCompound.m_128471_("isVeteran")) {
            this.makeVeteran();
        }
        this.readUnitSaveData(pCompound);
    }

    public void convertToMilitia() {
        LivingEntity newEntity;
        if (!this.converted && (newEntity = this.convertToUnit((EntityType)EntityRegistrar.MILITIA_UNIT.get())) instanceof MilitiaUnit) {
            MilitiaUnit mUnit = (MilitiaUnit)newEntity;
            mUnit.resourcesSaveData = this.gatherResourcesGoal.permSaveData;
            mUnit.profession = this.getProfession();
            mUnit.isVeteran = this.isVeteran;
            mUnit.farmerExp = this.farmerExp;
            mUnit.lumberjackExp = this.lumberjackExp;
            mUnit.minerExp = this.minerExp;
            mUnit.masonExp = this.masonExp;
            mUnit.hunterExp = this.hunterExp;
            UnitConvertClientboundPacket.syncConvertedUnits(this.getOwnerName(), List.of(Integer.valueOf(this.m_19879_())), List.of(Integer.valueOf(newEntity.m_19879_())));
            this.converted = true;
        }
    }

    @Override
    public void resetBehaviours() {
        this.callToArmsGoal.m_8041_();
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = PathfindingManager.createGroundMovementGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, true);
        this.garrisonGoal = new GarrisonGoal((Mob)this);
        this.attackGoal = new MeleeAttackUnitGoal((Mob)this, true);
        this.buildRepairGoal = new BuildRepairGoal((Mob)this);
        this.gatherResourcesGoal = new GatherResourcesGoal((Mob)this);
        this.returnResourcesGoal = new ReturnResourcesGoal((Mob)this);
        this.callToArmsGoal = new CallToArmsGoal((Mob)this);
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.buildRepairGoal);
        this.f_21345_.m_25352_(2, (Goal)this.gatherResourcesGoal);
        this.f_21345_.m_25352_(2, (Goal)this.returnResourcesGoal);
        this.f_21345_.m_25352_(2, (Goal)this.garrisonGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21345_.m_25352_(3, (Goal)this.moveGoal);
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundUnitGoal((Mob)this));
    }

    @Override
    public void setupEquipmentAndUpgradesClient() {
        if (ResearchClient.hasResearch(ProductionItems.RESEARCH_RESOURCE_CAPACITY)) {
            this.maxResources = 200;
        }
    }

    @Override
    public void setupEquipmentAndUpgradesServer() {
        if (ResearchServerEvents.playerHasResearch(this.getOwnerName(), ProductionItems.RESEARCH_RESOURCE_CAPACITY)) {
            this.maxResources = 200;
        }
        if (this.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof BannerItem) {
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_41852_));
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        return pSpawnData;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
        this.f_19804_.m_135372_(VILLAGER_DATA, (Object)new VillagerData(VillagerType.f_35821_, VillagerProfession.f_35585_, 1));
    }

    public VillagerData m_7141_() {
        return (VillagerData)this.f_19804_.m_135370_(VILLAGER_DATA);
    }

    public void m_34375_(@NotNull VillagerData data) {
        VillagerData villagerdata = this.m_7141_();
        this.f_19804_.m_135381_(VILLAGER_DATA, (Object)data);
    }

    public void setProfession(VillagerProfession profession) {
        this.m_34375_(this.m_7141_().m_35565_(profession));
    }

    public VillagerProfession getProfession() {
        return this.m_7141_().m_35571_();
    }

    public boolean hasUnitProfession() {
        return this.getUnitProfession() != VillagerUnitProfession.NONE;
    }
}

