/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.stripmining.event;

import com.google.common.collect.ImmutableList;
import com.invadermonky.stripmining.item.IAreaBrealToolSM;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderEvent {
    public static final RenderEvent INSTANCE = new RenderEvent();
    private final TextureAtlasSprite[] blockDamageIcons = new TextureAtlasSprite[10];

    @SubscribeEvent(priority=EventPriority.LOW)
    public void renderExtraBlockBreak(RenderWorldLastEvent event) {
        IAreaBrealToolSM aoeTool;
        PlayerControllerMP controllerMP = Minecraft.func_71410_x().field_71442_b;
        if (controllerMP == null) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IAreaBrealToolSM) {
            Entity renderEntity = Minecraft.func_71410_x().func_175606_aa();
            if (renderEntity == null) {
                return;
            }
            aoeTool = (IAreaBrealToolSM)stack.func_77973_b();
            double distance = Math.max(controllerMP.func_78757_d(), aoeTool.getReachDistance(stack));
            RayTraceResult traceResult = renderEntity.func_174822_a(distance, event.getPartialTicks());
            if (traceResult != null) {
                ImmutableList<BlockPos> extraBlocks = aoeTool.getAreaBreakBlocks(stack, traceResult.func_178782_a(), (EntityPlayer)player);
                for (BlockPos pos : extraBlocks) {
                    event.getContext().func_72731_b((EntityPlayer)player, new RayTraceResult(new Vec3d(0.0, 0.0, 0.0), null, pos), 0, event.getPartialTicks());
                }
            }
        }
        if (controllerMP.func_181040_m() && !stack.func_190926_b() && stack.func_77973_b() instanceof IAreaBrealToolSM) {
            BlockPos pos = controllerMP.field_178895_c;
            aoeTool = (IAreaBrealToolSM)stack.func_77973_b();
            this.drawBlockDamageTexture(Tessellator.func_178181_a(), Tessellator.func_178181_a().func_178180_c(), (Entity)player, event.getPartialTicks(), player.func_130014_f_(), (List<BlockPos>)aoeTool.getAreaBreakBlocks(stack, pos, (EntityPlayer)player));
        }
    }

    public void drawBlockDamageTexture(Tessellator tessellatorIn, BufferBuilder bufferIn, Entity entityIn, float partialTicks, World world, List<BlockPos> blocks) {
        double d0 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double d1 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double d2 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        TextureManager renderEngine = Minecraft.func_71410_x().field_71446_o;
        PlayerControllerMP controllerMP = Minecraft.func_71410_x().field_71442_b;
        int progress = (int)(controllerMP.field_78770_f * 10.0f) - 1;
        if (progress < 0) {
            return;
        }
        renderEngine.func_110577_a(TextureMap.field_110575_b);
        this.preRenderDamagedBlocks();
        bufferIn.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        bufferIn.func_178969_c(-d0, -d1, -d2);
        bufferIn.func_78914_f();
        for (BlockPos blockPos : blocks) {
            IBlockState state;
            TileEntity tile = world.func_175625_s(blockPos);
            if (tile != null && tile.canRenderBreaking() || (state = world.func_180495_p(blockPos)).func_185904_a() == Material.field_151579_a) continue;
            if (this.blockDamageIcons[0] == null) {
                this.getBlockDamageIcons();
            }
            Minecraft.func_71410_x().func_175602_ab().func_175020_a(state, blockPos, this.blockDamageIcons[progress], (IBlockAccess)world);
        }
        tessellatorIn.func_78381_a();
        bufferIn.func_178969_c(0.0, 0.0, 0.0);
        this.postRenderDamagedBlocks();
    }

    private void preRenderDamagedBlocks() {
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
    }

    private void postRenderDamagedBlocks() {
        GlStateManager.func_179118_c();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    public void getBlockDamageIcons() {
        TextureMap texturemap = Minecraft.func_71410_x().func_147117_R();
        for (int i = 0; i < this.blockDamageIcons.length; ++i) {
            this.blockDamageIcons[i] = texturemap.func_110572_b("minecraft:blocks/destroy_stage_" + i);
        }
    }
}

