/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.stripmining.handlers;

import com.google.common.collect.ImmutableList;
import com.invadermonky.stripmining.item.IAreaBrealToolSM;
import com.invadermonky.stripmining.item.IItemToolSM;
import com.invadermonky.stripmining.util.RayTraceHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BreakHandler {
    public static boolean harvestBlock(ItemTool tool, World world, BlockPos pos, EntityPlayer player) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        if (!(tool instanceof IItemToolSM)) {
            return false;
        }
        IItemToolSM toolSM = (IItemToolSM)tool;
        EntityPlayerMP playerMP = player instanceof EntityPlayerMP ? (EntityPlayerMP)player : null;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!toolSM.getToolClasses().contains((Object)block.getHarvestTool(state)) && !tool.canHarvestBlock(state, player.func_184614_ca())) {
            return false;
        }
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos)) {
            return false;
        }
        int xpToDrop = 0;
        if (playerMP != null) {
            xpToDrop = ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMP, (BlockPos)pos);
            if (xpToDrop == -1) {
                return false;
            }
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        }
        if (!world.field_72995_K) {
            if (block.removedByPlayer(state, world, pos, player, !player.field_71075_bZ.field_75098_d)) {
                block.func_176206_d(world, pos, state);
                if (!player.field_71075_bZ.field_75098_d) {
                    block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
                    if (xpToDrop > 0) {
                        block.func_180637_b(world, pos, xpToDrop);
                    }
                }
            }
        } else {
            if (block.removedByPlayer(state, world, pos, player, !player.field_71075_bZ.field_75098_d)) {
                block.func_176206_d(world, pos, state);
            }
            if (Minecraft.func_71410_x().func_147114_u() != null) {
                Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
            }
        }
        return true;
    }

    public static ImmutableList<BlockPos> getAoEBlocks(ItemStack stack, int height, int width, BlockPos origin, EntityPlayer player) {
        ArrayList<BlockPos> breakarea = new ArrayList<BlockPos>();
        World world = player.field_70170_p;
        Item tool = stack.func_77973_b();
        RayTraceResult traceResult = RayTraceHelper.retrace(player);
        if (traceResult == null || traceResult.field_178784_b == null || !tool.canHarvestBlock(world.func_180495_p(origin), stack) || player.func_70093_af()) {
            return ImmutableList.copyOf(breakarea);
        }
        int posX = origin.func_177958_n();
        int posY = origin.func_177956_o();
        int posZ = origin.func_177952_p();
        switch (traceResult.field_178784_b) {
            case UP: 
            case DOWN: {
                int west;
                int east;
                int south;
                int north;
                Vec3d look = player.func_70040_Z();
                if (Double.compare(Math.abs(look.field_72450_a), Math.abs(look.field_72449_c)) >= 0) {
                    if (Double.compare(look.field_72450_a, 0.0) >= 0) {
                        north = (int)Math.ceil((double)(width - 1) / 2.0);
                        south = (int)Math.floor((double)(width - 1) / 2.0);
                        east = (int)Math.ceil((double)(height - 1) / 2.0);
                        west = (int)Math.floor((double)(height - 1) / 2.0);
                    } else {
                        north = (int)Math.floor((double)(width - 1) / 2.0);
                        south = (int)Math.ceil((double)(width - 1) / 2.0);
                        east = (int)Math.floor((double)(height - 1) / 2.0);
                        west = (int)Math.ceil((double)(height - 1) / 2.0);
                    }
                } else if (Double.compare(look.field_72449_c, 0.0) >= 0) {
                    north = (int)Math.ceil((double)(height - 1) / 2.0);
                    south = (int)Math.floor((double)(height - 1) / 2.0);
                    east = (int)Math.floor((double)(width - 1) / 2.0);
                    west = (int)Math.ceil((double)(width - 1) / 2.0);
                } else {
                    north = (int)Math.floor((double)(height - 1) / 2.0);
                    south = (int)Math.ceil((double)(height - 1) / 2.0);
                    east = (int)Math.ceil((double)(width - 1) / 2.0);
                    west = (int)Math.floor((double)(width - 1) / 2.0);
                }
                for (int x = posX - west; x <= posX + east; ++x) {
                    for (int z = posZ - south; z <= posZ + north; ++z) {
                        BlockPos harvestPos;
                        if (x == posX && z == posZ || !tool.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, posY, z)), stack)) continue;
                        breakarea.add(harvestPos);
                    }
                }
                break;
            }
            case NORTH: {
                int east = (int)Math.floor((double)(width - 1) / 2.0);
                int west = (int)Math.ceil((double)(width - 1) / 2.0);
                int up = height == 1 ? 0 : height - 2;
                int down = height == 1 ? 0 : 1;
                for (int x = posX - west; x <= posX + east; ++x) {
                    for (int y = posY - down; y <= posY + up; ++y) {
                        BlockPos harvestPos;
                        if (x == posX && y == posY || !tool.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, y, posZ)), stack)) continue;
                        breakarea.add(harvestPos);
                    }
                }
                break;
            }
            case SOUTH: {
                int east = (int)Math.ceil((double)(width - 1) / 2.0);
                int west = (int)Math.floor((double)(width - 1) / 2.0);
                int up = height == 1 ? 0 : height - 2;
                int down = height == 1 ? 0 : 1;
                for (int x = posX - west; x <= posX + east; ++x) {
                    for (int y = posY - down; y <= posY + up; ++y) {
                        BlockPos harvestPos;
                        if (x == posX && y == posY || !tool.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, y, posZ)), stack)) continue;
                        breakarea.add(harvestPos);
                    }
                }
                break;
            }
            case EAST: {
                int north = (int)Math.floor((double)(width - 1) / 2.0);
                int south = (int)Math.ceil((double)(width - 1) / 2.0);
                int up = height == 1 ? 0 : height - 2;
                int down = height == 1 ? 0 : 1;
                for (int z = posZ - south; z <= posZ + north; ++z) {
                    for (int y = posY - down; y <= posY + up; ++y) {
                        BlockPos harvestPos;
                        if (y == posY && z == posZ || !tool.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(posX, y, z)), stack)) continue;
                        breakarea.add(harvestPos);
                    }
                }
                break;
            }
            case WEST: {
                int north = (int)Math.ceil((double)(width - 1) / 2.0);
                int south = (int)Math.floor((double)(width - 1) / 2.0);
                int up = height == 1 ? 0 : height - 2;
                int down = height == 1 ? 0 : 1;
                for (int z = posZ - south; z <= posZ + north; ++z) {
                    for (int y = posY - down; y <= posY + up; ++y) {
                        BlockPos harvestPos;
                        if (y == posY && z == posZ || !tool.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(posX, y, z)), stack)) continue;
                        breakarea.add(harvestPos);
                    }
                }
                break;
            }
        }
        return ImmutableList.copyOf(breakarea);
    }

    public static void instantHarvestBlocks(ItemStack stack, BlockPos origin, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(origin);
        Item tool = stack.func_77973_b();
        if (!(tool instanceof IAreaBrealToolSM) || !(tool instanceof ItemTool)) {
            return;
        }
        IAreaBrealToolSM aoeToolSM = (IAreaBrealToolSM)tool;
        if (state.func_185887_b(world, origin) == 0.0f) {
            return;
        }
        if (!tool.canHarvestBlock(state, stack) || player.func_70093_af()) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            return;
        }
        float refHardness = state.func_185903_a(player, world, origin);
        float maxHardness = refHardness / 8.0f;
        if (refHardness != 0.0f) {
            RayTraceResult traceResult = RayTraceHelper.retrace(player);
            if (traceResult == null || traceResult.field_178784_b == null) {
                return;
            }
            ImmutableList<BlockPos> aoeBlockPos = aoeToolSM.getAreaBreakBlocks(stack, origin, player);
            int count = 0;
            for (BlockPos adjPos : aoeBlockPos) {
                IBlockState adjState = world.func_180495_p(adjPos);
                float hardness = adjState.func_185903_a(player, world, adjPos);
                if (!(hardness > 0.0f) || !(hardness >= maxHardness) || !BreakHandler.harvestBlock((ItemTool)tool, world, adjPos, player)) continue;
                ++count;
            }
            if (count >= 0 && !player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(count, (EntityLivingBase)player);
            }
        }
    }

    public static List<BlockPos> surroundingBlocks(BlockPos center) {
        ArrayList<BlockPos> surrounding = new ArrayList<BlockPos>();
        boolean radius = true;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    surrounding.add(center.func_177982_a(x, y, z));
                }
            }
        }
        return surrounding;
    }
}

