/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.stripmining.handlers;

import com.invadermonky.stripmining.handlers.FileHandler;
import com.invadermonky.stripmining.util.LogHelper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.FileUtils;

public class ConfigHandler {
    private static Configuration config = null;
    private static final String CATEGORY_PROSPECTING = "prospecting_settings";
    public static boolean enableExcavators = true;
    public static boolean enableHammers = true;
    public static boolean enableCarpenterAxes = true;
    public static boolean enableProspectingPicks = true;
    public static boolean generateRecipes = true;
    public static boolean loadDefaults = false;
    public static boolean enableDebug = false;
    public static boolean enableGameStageSupport = true;
    public static boolean enableProspectingSound = true;
    public static String[] oreBlacklist = new String[0];
    public static String[] oreWhitelist = new String[]{"type=ore"};
    public static int veinTrace = 4;
    public static int veinSmall = 10;
    public static int veinMedium = 16;
    public static int veinLarge = 24;

    public static void preInit() {
        File configFile = new File(Paths.get(Loader.instance().getConfigDir().toString(), "stripmining", "stripmining.cfg").toString());
        config = new Configuration(configFile);
        config.load();
        enableExcavators = config.getBoolean("enableExcavators", "general", enableExcavators, "Enable area digging tools.");
        enableHammers = config.getBoolean("enableHammers", "general", enableHammers, "Enable area mining tools.");
        enableCarpenterAxes = config.getBoolean("enableCarpenterAxes", "general", enableCarpenterAxes, "Enable area wood chopping tools.");
        enableProspectingPicks = config.getBoolean("enableProspectingPicks", "general", enableProspectingPicks, "Enable ore scanning tools.");
        generateRecipes = config.getBoolean("generateRecipes", "general", generateRecipes, "Generate default recipes for tools.");
        loadDefaults = config.getBoolean("loadDefaults", "general", loadDefaults, "Loads all default tool json files. This config option will default to \"false\" after load is complete.\n\tWARNING: This option will delete and reload all tool config files. Be sure to backup any files you wish to save.");
        enableDebug = config.getBoolean("robustLogging", "general", enableDebug, "Enables robust logging. Used to debug tool json files.");
        enableGameStageSupport = config.getBoolean("enableGameStageSupport", CATEGORY_PROSPECTING, enableGameStageSupport, "Enables Game Stages support. Prospected staged ores will be hidden or have their names obscured if the player does not have the correct game stage.");
        enableProspectingSound = config.getBoolean("enableProspectingSound", CATEGORY_PROSPECTING, enableProspectingSound, "Enables the sound effect when prospecting.");
        oreBlacklist = config.getStringList("oreBlacklist", CATEGORY_PROSPECTING, oreBlacklist, "Blacklisted ores that will not be detected by Prospecting Picks. Additional ores can be blacklisted on a per-tool basis using the individual tool json.\nFormat:\n\tore=oreIron\n\ttype=ore\n\tblock=minecraft:iron_ore\n\tblock=minecraft:iron_ore:0\n");
        oreWhitelist = config.getStringList("oreWhitelist", CATEGORY_PROSPECTING, oreWhitelist, "Additional ores that will be detected by Prospecting Picks. Additional ores can be whitelisted on a per-tool basis using the individual tool json.\nFormat:\n\tore=oreIron\n\ttype=ore\n\tblock=minecraft:iron_ore\n\tblock=minecraft:iron_ore:0\n");
        veinTrace = config.getInt("veinTrace", CATEGORY_PROSPECTING, veinTrace, 1, 100, "The maximum number of ore blocks (as a percentage of nearby stone) that can qualify as a trace amount.");
        veinSmall = config.getInt("veinSmall", CATEGORY_PROSPECTING, veinSmall, 1, 100, "The maximum number of ore blocks (as a percentage of nearby stone) that can qualify as a small sample.");
        veinMedium = config.getInt("veinMedium", CATEGORY_PROSPECTING, veinMedium, 1, 100, "The maximum number of ore blocks (as a percentage of nearby stone) that can qualify as a medium sample.");
        veinLarge = config.getInt("veinLarge", CATEGORY_PROSPECTING, veinLarge, 1, 100, "The maximum number of ore blocks (as a percentage of nearby stone) that can qualify as a large sample.");
        if (loadDefaults) {
            ConfigHandler.loadDefaultExcavators();
            ConfigHandler.loadDefaultHammers();
            ConfigHandler.loadDefaultCarpenterAxes();
            ConfigHandler.loadDefaultProspectingPicks();
            config.getCategory("general").get("loadDefaults").set(false);
        } else {
            if (!ConfigHandler.configFolderExists("excavators") && enableExcavators) {
                ConfigHandler.loadDefaultExcavators();
            }
            if (!ConfigHandler.configFolderExists("hammers") && enableHammers) {
                ConfigHandler.loadDefaultHammers();
            }
            if (!ConfigHandler.configFolderExists("carpenteraxes") && enableCarpenterAxes) {
                ConfigHandler.loadDefaultCarpenterAxes();
            }
            if (!ConfigHandler.configFolderExists("prospectingpicks") && enableProspectingPicks) {
                ConfigHandler.loadDefaultProspectingPicks();
            }
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static boolean configFolderExists(String tool) {
        return Files.exists(Paths.get(Loader.instance().getConfigDir().getAbsolutePath(), "stripmining", tool), new LinkOption[0]);
    }

    private static void loadDefaultExcavators() {
        LogHelper.info("Loading default excavator configs.");
        ConfigHandler.loadFromJar("excavators");
    }

    private static void loadDefaultHammers() {
        LogHelper.info("Loading default hammer configs.");
        ConfigHandler.loadFromJar("hammers");
    }

    private static void loadDefaultCarpenterAxes() {
        LogHelper.info("Loading default carpenter axe configs.");
        ConfigHandler.loadFromJar("carpenteraxes");
    }

    private static void loadDefaultProspectingPicks() {
        LogHelper.info("Loading default prospecting pick configs.");
        ConfigHandler.loadFromJar("prospectingpicks");
    }

    private static void loadFromJar(String tool) {
        try {
            String folderPath = "/assets/stripmining/data/" + tool + "/";
            File configFile = new File(Paths.get(Loader.instance().getConfigDir().getAbsolutePath(), "stripmining", tool).toString());
            if (!ConfigHandler.configFolderExists(tool)) {
                configFile.mkdirs();
                FileHandler.copyFromJar(folderPath, configFile.toPath());
            } else if (loadDefaults) {
                FileUtils.cleanDirectory((File)configFile);
                FileHandler.copyFromJar(folderPath, configFile.toPath());
            }
        }
        catch (Exception e) {
            LogHelper.debug(e);
            e.printStackTrace();
        }
    }
}

