/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.stripmining.handlers;

import com.invadermonky.stripmining.StripMining;
import com.invadermonky.stripmining.util.LogHelper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import net.minecraftforge.fml.common.Loader;

public class FileHandler {
    public static void copyFromJar(String source, final Path target) throws URISyntaxException, IOException {
        URI resourceUri = StripMining.class.getResource("").toURI();
        FileSystem fileSystem = FileSystems.newFileSystem(resourceUri, Collections.emptyMap());
        final Path jarPath = fileSystem.getPath(source, new String[0]);
        Files.walkFileTree(jarPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
            private Path currentTarget;

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                this.currentTarget = target.resolve(jarPath.relativize(dir).toString());
                Files.createDirectories(this.currentTarget, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, target.resolve(jarPath.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
        fileSystem.close();
    }

    public static HashMap<String, String> getToolConfigs(String toolFolder) {
        final HashMap<String, String> fileContents = new HashMap<String, String>();
        final Path configPath = Paths.get(Loader.instance().getConfigDir().getAbsolutePath(), "stripmining", toolFolder);
        try {
            Files.walkFileTree(configPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.toFile().isDirectory() && !dir.equals(configPath)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String name = file.getFileName().toString();
                    if (name.toLowerCase(Locale.ROOT).endsWith(".json")) {
                        fileContents.put(file.getFileName().toString(), FileHandler.getFileContents(file));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            LogHelper.debug(e);
        }
        return fileContents;
    }

    public static String getFileContents(Path path) throws IOException {
        byte[] encoded = Files.readAllBytes(path);
        return new String(encoded, StandardCharsets.UTF_8);
    }
}

