/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.stripmining.handlers;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.invadermonky.stripmining.item.stats.CarpenterAxeStats;
import com.invadermonky.stripmining.item.stats.ExcavatorStats;
import com.invadermonky.stripmining.item.stats.HammerStats;
import com.invadermonky.stripmining.item.stats.ProspectingPickStats;
import com.invadermonky.stripmining.item.stats.ToolStatsBase;
import com.invadermonky.stripmining.util.LogHelper;
import com.invadermonky.stripmining.util.SpriteHelper;
import java.awt.Color;
import java.nio.charset.StandardCharsets;

public class JsonHandler {
    private static JsonObject jsonObject;

    public static ExcavatorStats parseExcavatorJson(String fileName, String fileContents) {
        try {
            LogHelper.userDebug("Parsing File: " + fileName);
            jsonObject = (JsonObject)new Gson().fromJson(fileContents, JsonObject.class);
            ExcavatorStats stats = new ExcavatorStats();
            stats.name = JsonHandler.getStringProperty("name").toLowerCase().trim();
            stats.unlocName = "excavator_" + stats.name;
            LogHelper.userDebug("\tRegistry name set to: " + stats.unlocName);
            stats.displayNameRaw = JsonHandler.getDisplayNameProperty();
            stats.craftingMaterial = JsonHandler.getStringProperty("craftingMaterial");
            LogHelper.userDebug("\tProperty \"craftingMaterial\" set to: " + stats.craftingMaterial);
            int[] breakarea = JsonHandler.getBreakAreaProperty();
            stats.breakareaHeight = breakarea[0];
            stats.breakareaWidth = breakarea[1];
            stats.tier = JsonHandler.getTierProperty();
            stats.color = JsonHandler.getBaseColorProperty();
            stats.harvestLevel = JsonHandler.getIntProperty("harvestLevel", 2);
            stats.durability = JsonHandler.getIntProperty("durability", 500);
            stats.efficiency = JsonHandler.getFloatProperty("efficiency", 6.0f);
            stats.damage = JsonHandler.getFloatProperty("damage", 5.0f);
            stats.attackspeed = JsonHandler.getFloatProperty("attackspeed", -3.1f);
            stats.enchantability = JsonHandler.getIntProperty("enchantability", 14);
            stats.isEnchantable = JsonHandler.getBooleanProperty("enchantable", true);
            stats.isRepairable = JsonHandler.getBooleanProperty("repairable", true);
            JsonHandler.getTemplateColors(stats);
            return stats;
        }
        catch (Exception e) {
            LogHelper.info("Error parsing file: " + fileName);
            LogHelper.info(e);
            return null;
        }
    }

    public static HammerStats parseHammerJson(String fileName, String fileContents) {
        try {
            LogHelper.userDebug("Parsing File: " + fileName);
            jsonObject = (JsonObject)new Gson().fromJson(fileContents, JsonObject.class);
            HammerStats stats = new HammerStats();
            stats.name = JsonHandler.getStringProperty("name").toLowerCase().trim();
            stats.unlocName = "hammer_" + stats.name;
            LogHelper.userDebug("\tRegistry name set to: " + stats.unlocName);
            stats.displayNameRaw = JsonHandler.getDisplayNameProperty();
            stats.craftingMaterial = JsonHandler.getStringProperty("craftingMaterial");
            LogHelper.userDebug("\tProperty \"craftingMaterial\" set to: " + stats.craftingMaterial);
            int[] breakarea = JsonHandler.getBreakAreaProperty();
            stats.breakareaHeight = breakarea[0];
            stats.breakareaWidth = breakarea[1];
            stats.tier = JsonHandler.getTierProperty();
            stats.color = JsonHandler.getBaseColorProperty();
            stats.harvestLevel = JsonHandler.getIntProperty("harvestLevel", 2);
            stats.durability = JsonHandler.getIntProperty("durability", 500);
            stats.efficiency = JsonHandler.getFloatProperty("efficiency", 6.0f);
            stats.damage = JsonHandler.getFloatProperty("damage", 10.0f);
            stats.attackspeed = JsonHandler.getFloatProperty("attackspeed", -3.3f);
            stats.enchantability = JsonHandler.getIntProperty("enchantability", 14);
            stats.isEnchantable = JsonHandler.getBooleanProperty("enchantable", true);
            stats.isRepairable = JsonHandler.getBooleanProperty("repairable", true);
            JsonHandler.getTemplateColors(stats);
            return stats;
        }
        catch (Exception e) {
            LogHelper.info("Error parsing file: " + fileName);
            LogHelper.info(e);
            return null;
        }
    }

    public static CarpenterAxeStats parseCarpenterAxeJson(String fileName, String fileContents) {
        try {
            LogHelper.userDebug("Parsing File: " + fileName);
            jsonObject = (JsonObject)new Gson().fromJson(fileContents, JsonObject.class);
            CarpenterAxeStats stats = new CarpenterAxeStats();
            stats.name = JsonHandler.getStringProperty("name").toLowerCase().trim();
            stats.unlocName = "carpenter_axe_" + stats.name;
            LogHelper.userDebug("\tRegistry name set to: " + stats.unlocName);
            stats.displayNameRaw = JsonHandler.getDisplayNameProperty();
            stats.craftingMaterial = JsonHandler.getStringProperty("craftingMaterial");
            LogHelper.userDebug("\tProperty \"craftingMaterial\" set to: " + stats.craftingMaterial);
            int[] breakarea = JsonHandler.getBreakAreaProperty();
            stats.breakareaHeight = breakarea[0];
            stats.breakareaWidth = breakarea[1];
            stats.tier = 0;
            stats.color = JsonHandler.getBaseColorProperty();
            stats.harvestLevel = JsonHandler.getIntProperty("harvestLevel", 2);
            stats.durability = JsonHandler.getIntProperty("durability", 500);
            stats.efficiency = JsonHandler.getFloatProperty("efficiency", 6.0f);
            stats.damage = JsonHandler.getFloatProperty("damage", 9.0f);
            stats.attackspeed = JsonHandler.getFloatProperty("attackspeed", -3.1f);
            stats.enchantability = JsonHandler.getIntProperty("enchantability", 14);
            stats.isEnchantable = JsonHandler.getBooleanProperty("enchantable", true);
            stats.isRepairable = JsonHandler.getBooleanProperty("repairable", true);
            JsonHandler.getTemplateColors(stats);
            return stats;
        }
        catch (Exception e) {
            LogHelper.info("Error parsing file: " + fileName);
            LogHelper.info(e);
            return null;
        }
    }

    public static ProspectingPickStats parseProspectingPickJson(String fileName, String fileContents) {
        try {
            LogHelper.userDebug("Parsing File: " + fileName);
            jsonObject = (JsonObject)new Gson().fromJson(fileContents, JsonObject.class);
            ProspectingPickStats stats = new ProspectingPickStats();
            stats.name = JsonHandler.getStringProperty("name").toLowerCase().trim();
            stats.unlocName = "prospecting_pick_" + stats.name;
            LogHelper.userDebug("\tRegistry name set to: " + stats.unlocName);
            stats.displayNameRaw = JsonHandler.getDisplayNameProperty();
            stats.craftingMaterial = JsonHandler.getStringProperty("craftingMaterial");
            LogHelper.userDebug("\tProperty \"craftingMaterial\" set to: " + stats.craftingMaterial);
            stats.scanRadius = JsonHandler.getIntProperty("scanradius", 6);
            stats.directionalScan = JsonHandler.getBooleanProperty("directional", true);
            stats.accuracy = JsonHandler.getFloatProperty("accuracy", 1.0f);
            stats.setRawBlacklist(JsonHandler.getStringArrayProperty("oreBlacklist"));
            stats.setRawWhitelist(JsonHandler.getStringArrayProperty("oreWhitelist"));
            stats.tier = 0;
            stats.color = JsonHandler.getBaseColorProperty();
            stats.harvestLevel = JsonHandler.getIntProperty("harvestLevel", 2);
            stats.durability = JsonHandler.getIntProperty("durability", 250);
            stats.efficiency = JsonHandler.getFloatProperty("efficiency", 3.0f);
            stats.damage = JsonHandler.getFloatProperty("damage", 3.0f);
            stats.attackspeed = JsonHandler.getFloatProperty("attackspeed", -2.7f);
            stats.enchantability = JsonHandler.getIntProperty("enchantability", 14);
            stats.isEnchantable = JsonHandler.getBooleanProperty("enchantable", true);
            stats.isRepairable = JsonHandler.getBooleanProperty("repairable", true);
            JsonHandler.getTemplateColors(stats);
            return stats;
        }
        catch (Exception e) {
            LogHelper.info("Error parsing file: " + fileName);
            LogHelper.info(e);
            return null;
        }
    }

    private static void getTemplateColors(ToolStatsBase baseStats) {
        baseStats.borderDark = SpriteHelper.darkenColor(baseStats.color, 0.2f);
        baseStats.borderLight = SpriteHelper.darkenColor(baseStats.color, 0.4f);
        baseStats.shadingDark = SpriteHelper.darkenColor(baseStats.color, 0.6f);
        baseStats.shadingLight = SpriteHelper.darkenColor(baseStats.color, 0.8f);
        baseStats.reflectDark = SpriteHelper.lightenColor(baseStats.color, 0.4f);
        baseStats.reflectLight = SpriteHelper.lightenColor(baseStats.color, 0.6f);
        if (!jsonObject.has("templateColors")) {
            LogHelper.userDebug("\tProperty \"templateColors\" not found. Using default generated template colors.");
        } else {
            LogHelper.userDebug("\tProperty \"templateColors\" found. Reading configured template colors.");
            JsonObject colorObject = jsonObject.getAsJsonObject("templateColors");
            baseStats.borderDark = JsonHandler.getTemplateColorProperty(colorObject, "borderDark", baseStats.borderDark);
            baseStats.borderLight = JsonHandler.getTemplateColorProperty(colorObject, "borderLight", baseStats.borderLight);
            baseStats.shadingDark = JsonHandler.getTemplateColorProperty(colorObject, "shadingDark", baseStats.shadingDark);
            baseStats.shadingLight = JsonHandler.getTemplateColorProperty(colorObject, "shadingLight", baseStats.shadingLight);
            baseStats.reflectDark = JsonHandler.getTemplateColorProperty(colorObject, "reflectDark", baseStats.reflectDark);
            baseStats.reflectLight = JsonHandler.getTemplateColorProperty(colorObject, "reflectLight", baseStats.reflectLight);
        }
    }

    private static String getStringProperty(String prop) throws NullPointerException {
        if (jsonObject.has(prop)) {
            return jsonObject.get(prop).getAsString();
        }
        throw new NullPointerException("Required Property \"" + prop + "\" not found.");
    }

    private static String[] getStringArrayProperty(String prop) {
        if (jsonObject.has(prop)) {
            JsonArray jsonArray = jsonObject.getAsJsonArray(prop);
            String[] oreArray = new String[jsonArray.size()];
            for (int i = 0; i < jsonArray.size(); ++i) {
                oreArray[i] = jsonArray.get(i).getAsString();
            }
            return oreArray;
        }
        return new String[0];
    }

    public static int getIntProperty(String prop, int defaultValue) {
        if (jsonObject.has(prop)) {
            int value = jsonObject.get(prop).getAsInt();
            LogHelper.userDebug("\tProperty \"" + prop + "\" set to: " + value);
            return value;
        }
        LogHelper.userDebug("\tProperty \"" + prop + "\" not found. Using default value: " + defaultValue);
        return defaultValue;
    }

    public static float getFloatProperty(String prop, float defaultValue) {
        if (jsonObject.has(prop)) {
            float value = jsonObject.get(prop).getAsFloat();
            LogHelper.userDebug("\tProperty \"" + prop + "\" set to: " + value);
            return value;
        }
        LogHelper.userDebug("\tProperty \"" + prop + "\" not found. Using default value: " + defaultValue);
        return defaultValue;
    }

    private static boolean getBooleanProperty(String prop, boolean defaultValue) {
        if (jsonObject.has(prop)) {
            boolean value = jsonObject.get(prop).getAsBoolean();
            LogHelper.userDebug("\tProperty \"" + prop + "\" set to: " + value);
            return value;
        }
        LogHelper.userDebug("\tProperty \"" + prop + "\" not found. Using default value: " + defaultValue);
        return defaultValue;
    }

    private static byte[] getDisplayNameProperty() {
        if (jsonObject.has("displayName")) {
            byte[] rawName = jsonObject.get("displayName").getAsString().getBytes(StandardCharsets.UTF_8);
            LogHelper.userDebug("\tProperty \"displayName\" set to: " + new String(rawName, StandardCharsets.UTF_8));
            return rawName;
        }
        LogHelper.userDebug("\tProperty \"displayName\" not found. Display name will default to Minecraft language files.");
        return null;
    }

    private static int getTierProperty() throws NullPointerException, IllegalArgumentException {
        int tier = 2;
        if (jsonObject.has("tier")) {
            tier = jsonObject.get("tier").getAsInt();
            if (tier < 1 || tier > 3) {
                throw new IllegalArgumentException("\tProperty \"tier\" value invalid. Accepted values are 1, 2 or 3.");
            }
            LogHelper.userDebug("\tProperty \"tier\" set to: " + tier);
        } else {
            LogHelper.userDebug("\tProperty \"tier\" not found. Using default value: " + tier);
        }
        return tier;
    }

    private static int[] getBreakAreaProperty() throws Exception {
        if (jsonObject.has("breakarea")) {
            if (!jsonObject.getAsJsonObject("breakarea").has("height")) {
                throw new NullPointerException("Required \"breakarea\" sub-Property \"height\" not found.");
            }
            int height = jsonObject.getAsJsonObject("breakarea").get("height").getAsInt();
            if (!jsonObject.getAsJsonObject("breakarea").has("width")) {
                throw new NullPointerException("Required \"breakarea\" sub-Property \"width\" not found.");
            }
            int width = jsonObject.getAsJsonObject("breakarea").get("width").getAsInt();
            if (height < 1) {
                throw new Exception("Sub-Property \"height\" out of bounds. Value must be greater than 0.");
            }
            if (width < 1) {
                throw new Exception("Sub-Property \"width\" out of bounds. Value must be greater than 0.");
            }
            LogHelper.userDebug("\tBreak Area:");
            LogHelper.userDebug("\t\tHeight: " + height);
            LogHelper.userDebug("\t\tWidth:  " + width);
            return new int[]{height, width};
        }
        throw new NullPointerException("Required Property \"breakarea\" not found.");
    }

    private static Color getBaseColorProperty() throws NullPointerException, IllegalArgumentException {
        if (jsonObject.has("color")) {
            JsonObject colorObject = jsonObject.getAsJsonObject("color");
            Color toolColor = JsonHandler.getColorProperty(colorObject);
            LogHelper.userDebug("\tRGB Base Tool Color set to:");
            LogHelper.userDebug("\t\tRed:   " + toolColor.getRed());
            LogHelper.userDebug("\t\tGreen: " + toolColor.getGreen());
            LogHelper.userDebug("\t\tBlue:  " + toolColor.getBlue());
            return toolColor;
        }
        throw new NullPointerException("Required Property \"color\" missing or invalid.");
    }

    private static Color getTemplateColorProperty(JsonObject colorObject, String prop, Color defaultValue) {
        Color templateColor = defaultValue;
        if (colorObject.has(prop)) {
            try {
                templateColor = JsonHandler.getColorProperty(colorObject.getAsJsonObject(prop));
                LogHelper.userDebug("\tRGB template Color \"" + prop + "\" set to:");
            }
            catch (Exception e) {
                LogHelper.userDebug("\tError parsing \"" + prop + "\" property. Using default value.");
                return templateColor;
            }
        } else {
            LogHelper.userDebug("\tProperty \"" + prop + "\" not found. Using default value:");
        }
        LogHelper.userDebug("\t\tRed:   " + templateColor.getRed());
        LogHelper.userDebug("\t\tGreen: " + templateColor.getGreen());
        LogHelper.userDebug("\t\tBlue:  " + templateColor.getBlue());
        return templateColor;
    }

    private static Color getColorProperty(JsonObject colorObject) throws NullPointerException, IllegalArgumentException {
        if (!colorObject.has("red")) {
            throw new NullPointerException("Required property \"red\" not found.");
        }
        int r = colorObject.get("red").getAsInt();
        if (!colorObject.has("green")) {
            throw new NullPointerException("Required property \"green\" not found.");
        }
        int g = colorObject.get("green").getAsInt();
        if (!colorObject.has("blue")) {
            throw new NullPointerException("Required property \"blue\" not found.");
        }
        int b = colorObject.get("blue").getAsInt();
        return new Color(r, g, b);
    }
}

