/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.stripmining.init;

import com.google.common.collect.ImmutableMap;
import com.invadermonky.stripmining.init.ItemRegistrySM;
import com.invadermonky.stripmining.item.IItemToolSM;
import com.invadermonky.stripmining.util.LogHelper;
import com.invadermonky.stripmining.util.SpriteHelper;
import com.invadermonky.stripmining.util.StringHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ModelRegistrySM {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerItemRenders(ModelRegistryEvent event) {
        for (ItemTool tool : ItemRegistrySM.tools) {
            ModelRegistrySM.registerItemRender((Item)tool);
        }
        LogHelper.debug("Registered all item renders.");
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void modelBake(ModelBakeEvent event) {
        try {
            IModel baseModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("minecraft", "item/handheld"));
            for (ItemTool tool : ItemRegistrySM.tools) {
                LogHelper.debug("Registry Name: " + tool.getRegistryName().toString());
                ResourceLocation toolColor = new ResourceLocation("stripmining", "items/" + tool.getRegistryName().func_110623_a());
                ResourceLocation toolOverlay = new ResourceLocation("stripmining", "items/" + SpriteHelper.getOverlaySpriteName(tool, ((IItemToolSM)tool).getToolBaseStats().tier));
                IModel retexturedModel = baseModel.retexture(ImmutableMap.of((Object)"layer0", (Object)toolColor.toString(), (Object)"layer1", (Object)toolOverlay.toString()));
                IBakedModel bakedModel = retexturedModel.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
                ModelResourceLocation bakedModelLocation = new ModelResourceLocation(tool.delegate.name(), "inventory");
                event.getModelRegistry().func_82595_a((Object)bakedModelLocation, (Object)bakedModel);
            }
            LogHelper.debug("Finished baking models.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerItemRender(Item item) {
        if (item == null) {
            return;
        }
        LogHelper.debug("Registering model for item: " + item.getRegistryName().toString());
        ModelResourceLocation loc = new ModelResourceLocation(StringHelper.stripUnlocalizedName(item.func_77658_a()), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)loc);
    }
}

