/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.stripmining.init;

import com.invadermonky.stripmining.handlers.ConfigHandler;
import com.invadermonky.stripmining.init.ItemRegistrySM;
import com.invadermonky.stripmining.item.tools.ItemCarpenterAxe;
import com.invadermonky.stripmining.item.tools.ItemExcavator;
import com.invadermonky.stripmining.item.tools.ItemHammer;
import com.invadermonky.stripmining.item.tools.ItemProspectingPick;
import com.invadermonky.stripmining.util.ItemHelper;
import com.invadermonky.stripmining.util.LogHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RecipeRegistrySM {
    @SubscribeEvent
    public static void addRecipes(RegistryEvent.Register<IRecipe> event) {
        if (!ConfigHandler.generateRecipes) {
            return;
        }
        IForgeRegistry registry = event.getRegistry();
        for (ItemTool tool : ItemRegistrySM.tools) {
            ItemStack output = new ItemStack((Item)tool);
            ResourceLocation loc = RecipeRegistrySM.getNameForRecipe(output);
            CraftingHelper.ShapedPrimer primer = null;
            if (ItemHelper.isExcavator(tool)) {
                primer = RecipeRegistrySM.getExcavatorPrimer((ItemExcavator)tool);
            } else if (ItemHelper.isHammer(tool)) {
                primer = RecipeRegistrySM.getHammerPrimer((ItemHammer)tool);
            } else if (ItemHelper.isCarpenterAxe(tool)) {
                primer = RecipeRegistrySM.getCarpenterAxePrimer((ItemCarpenterAxe)tool);
            } else if (ItemHelper.isProspectingPick(tool)) {
                primer = RecipeRegistrySM.getProspectingPickPrimer((ItemProspectingPick)tool);
            }
            if (primer == null) continue;
            ShapedRecipes recipe = new ShapedRecipes(output.func_77973_b().getRegistryName().toString(), primer.width, primer.height, primer.input, output);
            recipe.setRegistryName(loc);
            registry.register((IForgeRegistryEntry)recipe);
        }
        LogHelper.info("Recipes added.");
    }

    public static CraftingHelper.ShapedPrimer getExcavatorPrimer(ItemExcavator tool) {
        Object ingot = tool.getCraftingStack() == null ? tool.getCraftingMaterial() : (ItemHelper.stringHasMetaData(tool.getCraftingMaterial()) ? tool.getCraftingStack() : tool.getCraftingStack().func_77973_b());
        return CraftingHelper.parseShaped((Object[])new Object[]{" I ", "IRI", " R ", Character.valueOf('I'), ingot, Character.valueOf('R'), "stickWood"});
    }

    public static CraftingHelper.ShapedPrimer getHammerPrimer(ItemHammer tool) {
        Object ingot = tool.getCraftingStack() == null ? tool.getCraftingMaterial() : (ItemHelper.stringHasMetaData(tool.getCraftingMaterial()) ? tool.getCraftingStack() : tool.getCraftingStack().func_77973_b());
        return CraftingHelper.parseShaped((Object[])new Object[]{"III", "IRI", " R ", Character.valueOf('I'), ingot, Character.valueOf('R'), "stickWood"});
    }

    public static CraftingHelper.ShapedPrimer getCarpenterAxePrimer(ItemCarpenterAxe tool) {
        Object ingot = tool.getCraftingStack() == null ? tool.getCraftingMaterial() : (ItemHelper.stringHasMetaData(tool.getCraftingMaterial()) ? tool.getCraftingStack() : tool.getCraftingStack().func_77973_b());
        return CraftingHelper.parseShaped((Object[])new Object[]{"III", "IR ", " R ", Character.valueOf('I'), ingot, Character.valueOf('R'), "stickWood"});
    }

    public static CraftingHelper.ShapedPrimer getProspectingPickPrimer(ItemProspectingPick tool) {
        Object ingot = tool.getCraftingStack() == null ? tool.getCraftingMaterial() : (ItemHelper.stringHasMetaData(tool.getCraftingMaterial()) ? tool.getCraftingStack() : tool.getCraftingStack().func_77973_b());
        return CraftingHelper.parseShaped((Object[])new Object[]{"II ", " RI", " R ", Character.valueOf('I'), ingot, Character.valueOf('R'), "stickWood"});
    }

    private static ResourceLocation getNameForRecipe(ItemStack output) {
        ResourceLocation baseLoc;
        ResourceLocation recipeLoc = baseLoc = new ResourceLocation(output.func_77973_b().getRegistryName().toString());
        int index = 0;
        while (CraftingManager.field_193380_a.func_148741_d((Object)recipeLoc)) {
            recipeLoc = new ResourceLocation(baseLoc.func_110623_a() + "_" + ++index);
        }
        return recipeLoc;
    }
}

