/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.stripmining.item.sprite;

import com.google.common.collect.ImmutableSet;
import com.invadermonky.stripmining.item.IItemToolSM;
import com.invadermonky.stripmining.item.stats.ToolStatsBase;
import com.invadermonky.stripmining.util.SpriteHelper;
import java.awt.Color;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ResourceLocation;

public class ToolSpriteSM
extends TextureAtlasSprite {
    private final ResourceLocation template;
    private final ResourceLocation overlay;
    private final Color baseColor;
    private final ToolStatsBase baseStats;

    public ToolSpriteSM(String spriteName, ItemTool tool) {
        super(spriteName);
        int toolTier = ((IItemToolSM)tool).getToolBaseStats().tier;
        this.template = new ResourceLocation("stripmining", "items/" + SpriteHelper.getTemplateSpriteName(tool, toolTier));
        this.overlay = new ResourceLocation("stripmining", "items/" + SpriteHelper.getOverlaySpriteName(tool, toolTier));
        this.baseColor = ((IItemToolSM)tool).getToolBaseColor();
        this.baseStats = ((IItemToolSM)tool).getToolBaseStats();
    }

    protected void addFrameTextureData(int[] data) {
        int[][] templateData = new int[Minecraft.func_71410_x().func_147117_R().getMipmapLevels() + 1][];
        templateData[0] = data;
        this.field_110976_a.add(templateData);
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableSet.of((Object)this.template, (Object)this.overlay);
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        TextureAtlasSprite baseTex = SpriteHelper.getSprite(this.template, textureGetter);
        int[] templateData = new int[baseTex.func_94216_b() * baseTex.func_94211_a()];
        int[] templateInput = SpriteHelper.getFrameData(baseTex);
        for (int ix = 0; ix < baseTex.func_94211_a(); ++ix) {
            for (int iy = 0; iy < baseTex.func_94216_b(); ++iy) {
                int ip = iy * baseTex.func_94211_a() + ix;
                if (templateInput[ip] == 0) continue;
                Color pixel = new Color(templateInput[ip]);
                if (pixel.equals(Color.RED)) {
                    templateData[ip] = this.baseStats.borderDark.getRGB() | 0xFF000000;
                    continue;
                }
                if (pixel.equals(Color.GREEN)) {
                    templateData[ip] = this.baseStats.borderLight.getRGB() | 0xFF000000;
                    continue;
                }
                if (pixel.equals(Color.BLUE)) {
                    templateData[ip] = this.baseStats.shadingDark.getRGB() | 0xFF000000;
                    continue;
                }
                if (pixel.equals(Color.YELLOW)) {
                    templateData[ip] = this.baseStats.shadingLight.getRGB() | 0xFF000000;
                    continue;
                }
                if (pixel.equals(Color.MAGENTA)) {
                    templateData[ip] = this.baseStats.reflectDark.getRGB() | 0xFF000000;
                    continue;
                }
                if (pixel.equals(Color.CYAN)) {
                    templateData[ip] = this.baseStats.reflectLight.getRGB() | 0xFF000000;
                    continue;
                }
                if (!pixel.equals(Color.WHITE)) continue;
                templateData[ip] = this.baseColor.getRGB() | 0xFF000000;
            }
        }
        this.func_110966_b(baseTex.func_94211_a());
        this.func_110969_c(baseTex.func_94216_b());
        this.addFrameTextureData(templateData);
        return false;
    }
}

