/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.stripmining.item.stats;

import com.google.common.collect.Sets;
import com.invadermonky.stripmining.handlers.ConfigHandler;
import com.invadermonky.stripmining.item.stats.ToolStatsBase;
import com.invadermonky.stripmining.util.LogHelper;
import gnu.trove.TIntCollection;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Collection;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ProspectingPickStats
extends ToolStatsBase {
    public int scanRadius;
    public boolean directionalScan;
    public float accuracy;
    private String[] rawBlacklist;
    private String[] rawWhitelist;
    public THashSet<String> blacklistedBlocks = new THashSet();
    public THashSet<String> whitelistedBlocks = new THashSet();
    public TIntHashSet blacklistedOres = new TIntHashSet();
    public TIntHashSet whitelistedOres = new TIntHashSet();
    private boolean areListsInitialized = false;
    public THashSet<Material> effectiveMaterials = new THashSet((Collection)Sets.newHashSet((Object[])new Material[]{Material.field_151578_c, Material.field_151576_e}));

    public void setRawBlacklist(String ... rawBlacklist) {
        this.rawBlacklist = rawBlacklist;
    }

    public void setRawWhitelist(String ... rawWhitelist) {
        this.rawWhitelist = rawWhitelist;
    }

    public boolean isWhitelisted(World world, IBlockState state, BlockPos pos) {
        if (!this.areListsInitialized) {
            this.initLists();
        }
        if (state.func_185904_a() instanceof MaterialLiquid) {
            return false;
        }
        String blockName = state.func_177230_c().getRegistryName().toString();
        int meta = state.func_177230_c().func_176201_c(state);
        if (this.whitelistedBlocks.contains((Object)blockName) || this.whitelistedBlocks.contains((Object)(blockName + ":" + meta))) {
            return true;
        }
        if (this.blacklistedBlocks.contains((Object)blockName) || this.blacklistedBlocks.contains((Object)(blockName + ":" + meta))) {
            return false;
        }
        ItemStack stack = state.func_177230_c().getPickBlock(state, null, world, pos, null);
        for (int oreId : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (this.whitelistedOres.contains(oreId)) {
                return true;
            }
            if (!this.blacklistedOres.contains(oreId)) continue;
            return false;
        }
        return false;
    }

    private void initLists() {
        this.addToWhitelist(ConfigHandler.oreWhitelist);
        this.addToBlacklist(ConfigHandler.oreBlacklist);
        this.addToBlacklist(this.rawBlacklist);
        this.addToWhitelist(this.rawWhitelist);
        this.areListsInitialized = true;
    }

    protected void addToBlacklist(String ... rawStrings) {
        ProspectingPickStats.populateSets(this.blacklistedBlocks, this.blacklistedOres, rawStrings);
        this.whitelistedBlocks.removeAll(this.blacklistedBlocks);
        this.whitelistedOres.removeAll((TIntCollection)this.blacklistedOres);
    }

    protected void addToWhitelist(String ... rawStrings) {
        ProspectingPickStats.populateSets(this.whitelistedBlocks, this.whitelistedOres, rawStrings);
    }

    protected static void populateSets(THashSet<String> blockSet, TIntHashSet oreSet, String ... rawStrings) {
        String BLOCK = "^block=";
        String ORE = "^ore=";
        String TYPE = "^type=";
        for (String s : rawStrings) {
            if (s.matches("^type=.+")) {
                for (String oreName : OreDictionary.getOreNames()) {
                    if (!oreName.contains(s.replaceFirst("^type=", ""))) continue;
                    oreSet.add(OreDictionary.getOreID((String)oreName));
                }
                continue;
            }
            if (s.matches("^ore=.+")) {
                oreSet.add(OreDictionary.getOreID((String)s.replaceFirst("^ore=", "")));
                continue;
            }
            if (s.matches("^block=.+")) {
                blockSet.add((Object)s.replaceFirst("^block=", ""));
                continue;
            }
            LogHelper.error("Could not match syntax for Prospecting Pick value: " + s);
        }
    }
}

