/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.stripmining.item.tools;

import com.google.common.collect.ImmutableList;
import com.invadermonky.stripmining.handlers.BreakHandler;
import com.invadermonky.stripmining.item.IAreaBrealToolSM;
import com.invadermonky.stripmining.item.IItemToolSM;
import com.invadermonky.stripmining.item.stats.CarpenterAxeStats;
import com.invadermonky.stripmining.item.stats.ToolStatsBase;
import com.invadermonky.stripmining.util.ItemHelper;
import com.invadermonky.stripmining.util.StringHelper;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TLinkedHashSet;
import java.awt.Color;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCarpenterAxe
extends ItemTool
implements IItemToolSM,
IAreaBrealToolSM {
    protected final TLinkedHashSet<String> toolClasses = new TLinkedHashSet();
    protected final Set<String> immutableClasses = Collections.unmodifiableSet(this.toolClasses);
    protected final CarpenterAxeStats stats;
    protected final ItemStack craftingStack;
    protected final int height;
    protected final int width;

    public ItemCarpenterAxe(CarpenterAxeStats stats) {
        super(stats.getToolMaterial(), stats.effectiveBlocks);
        this.setRegistryName(stats.unlocName);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77655_b(StringHelper.getItemID(stats.unlocName));
        this.addToolClass("carpentersaxe");
        this.func_77656_e(stats.durability);
        this.field_77865_bY = stats.damage - 1.0f;
        this.field_185065_c = stats.attackspeed;
        this.field_77864_a = stats.efficiency;
        this.stats = stats;
        this.craftingStack = ItemHelper.getStackFromString(stats.craftingMaterial);
        this.height = stats.breakareaHeight;
        this.width = stats.breakareaWidth;
    }

    private ItemCarpenterAxe addToolClass(String str) {
        this.toolClasses.add((Object)str);
        return this;
    }

    public String func_77653_i(ItemStack stack) {
        if (this.stats.displayNameRaw == null) {
            return super.func_77653_i(stack);
        }
        return new String(this.stats.displayNameRaw, StandardCharsets.UTF_8);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return this.stats.harvestLevel >= state.func_177230_c().getHarvestLevel(state) && this.func_150893_a(stack, state) > 1.0f;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.isRepairable() && (ItemHelper.isOreNameEqual(repair, this.getCraftingMaterial()) || ItemHelper.isRepairItem(this, repair));
    }

    public boolean isRepairable() {
        return this.stats.isRepairable;
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.stats.isEnchantable;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (GuiScreen.func_146272_n()) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.stripmining:breakarea_carpenteraxe", (Object[])new Object[]{""}));
            tooltip.add(" " + I18n.func_135052_a((String)"tooltip.stripmining:height", (Object[])new Object[]{this.stats.breakareaHeight}));
            tooltip.add(" " + I18n.func_135052_a((String)"tooltip.stripmining:width", (Object[])new Object[]{this.stats.breakareaWidth}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.stripmining:breakarea_carpenteraxe", (Object[])new Object[]{I18n.func_135052_a((String)"tooltip.stripmining:area", (Object[])new Object[]{this.height, this.width})}));
        }
    }

    @Override
    public TLinkedHashSet<String> getToolClasses() {
        return this.toolClasses;
    }

    @Override
    public String getCraftingMaterial() {
        return this.stats.craftingMaterial;
    }

    @Override
    public ItemStack getCraftingStack() {
        return this.craftingStack;
    }

    @Override
    public ToolStatsBase getToolBaseStats() {
        return this.stats;
    }

    @Override
    public Color getToolBaseColor() {
        return this.stats.color;
    }

    @Override
    public float getEfficiency() {
        return this.field_77864_a;
    }

    @Override
    public THashSet<Block> getEffectiveBlocks() {
        return this.stats.effectiveBlocks;
    }

    @Override
    public THashSet<Material> getEffectiveMaterials() {
        return this.stats.effectiveMaterials;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        BreakHandler.instantHarvestBlocks(stack, pos, player);
        return false;
    }

    @Override
    public ImmutableList<BlockPos> getAreaBreakBlocks(ItemStack stack, BlockPos origin, EntityPlayer player) {
        return BreakHandler.getAoEBlocks(stack, this.height, this.width, origin, player);
    }
}

