/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.stripmining.item.tools;

import com.invadermonky.stripmining.handlers.ConfigHandler;
import com.invadermonky.stripmining.init.SoundRegistrySM;
import com.invadermonky.stripmining.item.IItemToolSM;
import com.invadermonky.stripmining.item.stats.ProspectingPickStats;
import com.invadermonky.stripmining.item.stats.ToolStatsBase;
import com.invadermonky.stripmining.util.ChatHelper;
import com.invadermonky.stripmining.util.ItemHelper;
import com.invadermonky.stripmining.util.StageHelper;
import com.invadermonky.stripmining.util.StringHelper;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TLinkedHashSet;
import java.awt.Color;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemProspectingPick
extends ItemPickaxe
implements IItemToolSM {
    protected TLinkedHashSet<String> toolClasses = new TLinkedHashSet();
    protected final Set<String> immutableClasses = Collections.unmodifiableSet(this.toolClasses);
    public final ProspectingPickStats stats;
    public final ItemStack craftingStack;

    public ItemProspectingPick(ProspectingPickStats stats) {
        super(stats.getToolMaterial());
        this.setRegistryName(stats.unlocName);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77655_b(StringHelper.getItemID(stats.unlocName));
        this.addToolClass("prospetingpick");
        this.func_77656_e(stats.durability);
        this.field_77865_bY = stats.damage - 1.0f;
        this.field_185065_c = stats.attackspeed;
        this.field_77864_a = stats.efficiency;
        this.canRepair = stats.isRepairable;
        this.stats = stats;
        this.craftingStack = ItemHelper.getStackFromString(stats.craftingMaterial);
    }

    private ItemProspectingPick addToolClass(String str) {
        this.toolClasses.add((Object)str);
        return this;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return this.immutableClasses;
    }

    public String func_77653_i(ItemStack stack) {
        if (this.stats.displayNameRaw == null) {
            return super.func_77653_i(stack);
        }
        return new String(this.stats.displayNameRaw, StandardCharsets.UTF_8);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return this.stats.harvestLevel >= state.func_177230_c().getHarvestLevel(state) && this.func_150893_a(stack, state) > 1.0f;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.isRepairable() && (ItemHelper.isOreNameEqual(repair, this.getCraftingMaterial()) || ItemHelper.isRepairItem(this, repair));
    }

    public boolean isRepairable() {
        return this.stats.isRepairable;
    }

    public int func_77619_b() {
        return this.stats.enchantability;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (ConfigHandler.enableProspectingSound) {
            world.func_184148_a(player, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundRegistrySM.PROSPECTING, SoundCategory.PLAYERS, 0.8f, 1.0f);
        }
        player.func_184609_a(hand);
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
        THashMap blockCounts = new THashMap();
        int x1 = facing == EnumFacing.WEST && this.stats.directionalScan ? -1 : -this.stats.scanRadius;
        int y1 = facing == EnumFacing.DOWN && this.stats.directionalScan ? -1 : -this.stats.scanRadius;
        int z1 = facing == EnumFacing.NORTH && this.stats.directionalScan ? -1 : -this.stats.scanRadius;
        int x2 = facing == EnumFacing.EAST && this.stats.directionalScan ? 1 : this.stats.scanRadius;
        int y2 = facing == EnumFacing.UP && this.stats.directionalScan ? 1 : this.stats.scanRadius;
        int z2 = facing == EnumFacing.SOUTH && this.stats.directionalScan ? 1 : this.stats.scanRadius;
        int blockCount = 0;
        BlockPos start = pos.func_177982_a(x1, y1, z1);
        BlockPos stop = pos.func_177982_a(x2, y2, z2);
        for (BlockPos checkPos : BlockPos.func_177980_a((BlockPos)start, (BlockPos)stop)) {
            IBlockState checkState;
            if (world.func_175623_d(checkPos)) continue;
            ++blockCount;
            if (this.stats.accuracy < 1.0f && world.field_73012_v.nextFloat() > this.stats.accuracy || !this.stats.isWhitelisted(world, checkState = world.func_180495_p(checkPos), checkPos)) continue;
            ProspectedOre prospectedOre = this.getProspectedOre(player, checkState, checkPos);
            if (!blockCounts.containsKey((Object)prospectedOre)) {
                blockCounts.put((Object)prospectedOre, (Object)0);
            }
            blockCounts.put((Object)prospectedOre, (Object)((Integer)blockCounts.get((Object)prospectedOre) + 1));
        }
        ArrayList<Object> messages = new ArrayList<Object>();
        for (Map.Entry entry : blockCounts.entrySet()) {
            String blockName = ((ProspectedOre)entry.getKey()).getDisplayName();
            if (blockName == null) continue;
            int count = (Integer)entry.getValue();
            String m = "chat.stripmining:";
            m = count <= ConfigHandler.veinTrace ? m + "traces" : (count <= ConfigHandler.veinSmall ? m + "small_sample" : (count <= ConfigHandler.veinMedium ? m + "medium_sample" : (count <= ConfigHandler.veinLarge ? m + "large_sample" : m + "motherload")));
            messages.add(new TextComponentTranslation("  ", new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation(m, new Object[]{blockName})));
        }
        messages.add(0, messages.isEmpty() ? new TextComponentTranslation("chat.stripmining:found_nothing", new Object[0]) : new TextComponentTranslation("chat.stripmining:found", new Object[0]));
        ChatHelper.sendNoSpam(player, messages.toArray(new ITextComponent[0]));
        return EnumActionResult.PASS;
    }

    public ProspectedOre getProspectedOre(EntityPlayer player, IBlockState state, BlockPos pos) {
        if (StageHelper.GAMESTAGES_LOADED) {
            return StageHelper.getProspectedOre(this, player, state, pos);
        }
        return new ProspectedOre(player.field_70170_p, state, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"tooltip.stripmining:scanradius", (Object[])new Object[]{this.stats.scanRadius}));
        if (GuiScreen.func_146272_n()) {
            tooltip.add("  " + I18n.func_135052_a((String)"tooltip.stripmining:accuracy", (Object[])new Object[]{(int)(this.stats.accuracy * 100.0f)}));
            if (this.stats.directionalScan) {
                tooltip.add("  " + I18n.func_135052_a((String)"tooltip.stripmining:scan_directional", (Object[])new Object[0]));
            } else {
                tooltip.add("  " + I18n.func_135052_a((String)"tooltip.stripmining:scan_full", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public TLinkedHashSet<String> getToolClasses() {
        return this.toolClasses;
    }

    @Override
    public String getCraftingMaterial() {
        return this.stats.craftingMaterial;
    }

    @Override
    public ItemStack getCraftingStack() {
        return this.craftingStack;
    }

    @Override
    public ToolStatsBase getToolBaseStats() {
        return this.stats;
    }

    @Override
    public Color getToolBaseColor() {
        return this.stats.color;
    }

    @Override
    public float getEfficiency() {
        return this.field_77864_a;
    }

    @Override
    public THashSet<Block> getEffectiveBlocks() {
        return new THashSet(0);
    }

    @Override
    public THashSet<Material> getEffectiveMaterials() {
        return this.stats.effectiveMaterials;
    }

    public static class ProspectedOre {
        public final IBlockState state;
        public final BlockPos pos;
        public boolean isUnknown;
        private String displayName;

        public ProspectedOre(World world, IBlockState state, BlockPos pos) {
            this.state = state;
            this.pos = pos;
            this.isUnknown = false;
            this.displayName = ItemHelper.getBlockDisplayName(world, state, pos);
        }

        public String getDisplayName() {
            return this.isUnknown ? new TextComponentTranslation("chat.stripmining:staged_ore", new Object[0]).func_150261_e() : this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProspectedOre that = (ProspectedOre)o;
            return Objects.equals(this.displayName, that.displayName);
        }

        public int hashCode() {
            return Objects.hashCode(this.displayName);
        }
    }
}

