/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.stripmining.util;

import com.invadermonky.stripmining.item.IItemToolSM;
import com.invadermonky.stripmining.item.tools.ItemCarpenterAxe;
import com.invadermonky.stripmining.item.tools.ItemExcavator;
import com.invadermonky.stripmining.item.tools.ItemHammer;
import com.invadermonky.stripmining.item.tools.ItemProspectingPick;
import joptsimple.internal.Strings;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemHelper {
    public static boolean isOreNameEqual(ItemStack stack, String oreName) {
        return OreDictionary.getOreName((int)ItemHelper.getOreID(stack)).equals(oreName);
    }

    public static boolean isRepairItem(IItemToolSM tool, ItemStack stack) {
        if (tool.getCraftingStack() == null) {
            return false;
        }
        String stackName = stack.func_77973_b().getRegistryName().toString();
        String repairName = tool.getCraftingStack().func_77973_b().getRegistryName().toString();
        if (ItemHelper.stringHasMetaData(tool.getCraftingMaterial())) {
            return stackName.equals(repairName) && stack.func_77960_j() == tool.getCraftingStack().func_77960_j();
        }
        return stackName.equals(repairName);
    }

    public static int getOreID(ItemStack stack) {
        return ItemHelper.getOreID(ItemHelper.getOreName(stack));
    }

    public static int getOreID(String oreName) {
        return Strings.isNullOrEmpty((String)oreName) ? -1 : OreDictionary.getOreID((String)oreName);
    }

    public static String getOreName(ItemStack stack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        return ids != null && ids.length >= 1 ? OreDictionary.getOreName((int)ids[0]) : "";
    }

    public static boolean stringHasMetaData(String item) {
        return item.split(":").length == 3;
    }

    public static ItemStack getStackFromString(String item) {
        String[] str = item.split(":");
        if (str.length == 2) {
            return new ItemStack(Item.func_111206_d((String)item));
        }
        if (str.length == 3) {
            return new ItemStack(Item.func_111206_d((String)(str[0] + ":" + str[1])), 1, Integer.parseInt(str[2]));
        }
        return null;
    }

    public static String getBlockDisplayName(World world, IBlockState state, BlockPos pos) {
        return state.func_177230_c().getPickBlock(state, null, world, pos, null).func_82833_r();
    }

    public static boolean isExcavator(ItemTool tool) {
        return tool instanceof ItemExcavator;
    }

    public static boolean isHammer(ItemTool tool) {
        return tool instanceof ItemHammer;
    }

    public static boolean isCarpenterAxe(ItemTool tool) {
        return tool instanceof ItemCarpenterAxe;
    }

    public static boolean isProspectingPick(ItemTool tool) {
        return tool instanceof ItemProspectingPick;
    }

    public static String getItemTypeString(ItemTool tool) {
        if (ItemHelper.isExcavator(tool)) {
            return "excavator";
        }
        if (ItemHelper.isHammer(tool)) {
            return "hammer";
        }
        if (ItemHelper.isCarpenterAxe(tool)) {
            return "carpenteraxe";
        }
        if (ItemHelper.isProspectingPick(tool)) {
            return "prospectingpick";
        }
        return "";
    }
}

