/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.stripmining.util;

import com.invadermonky.stripmining.util.ItemHelper;
import com.invadermonky.stripmining.util.LogHelper;
import java.awt.Color;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ResourceLocation;

public class SpriteHelper {
    private static final int[] MISSINGNO_DATA = new int[256];

    public static boolean isMissingno(TextureAtlasSprite sprite) {
        return "missingno".equals(sprite.func_94215_i()) || "minecraft:missingno".equals(sprite.func_94215_i());
    }

    public static TextureAtlasSprite getSprite(ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> getter) {
        TextureAtlasSprite sprite = getter.apply(location);
        if (sprite == null && (sprite = getter.apply(TextureMap.field_174945_f)) == null) {
            throw new RuntimeException("Could not load " + location + " or fallback.");
        }
        if (SpriteHelper.isMissingno(sprite)) {
            LogHelper.error("Could not locate texture: " + location);
        }
        return sprite;
    }

    public static int[] getFrameData(TextureAtlasSprite sprite) {
        if (SpriteHelper.isMissingno(sprite)) {
            return MISSINGNO_DATA;
        }
        int[][] data = null;
        if (sprite.func_110970_k() <= 0) {
            LogHelper.error("Could not read texture data for " + sprite.func_94215_i() + " - Invalid frame count: " + sprite.func_110970_k());
            return MISSINGNO_DATA;
        }
        try {
            data = sprite.func_147965_a(0);
        }
        catch (Exception e) {
            LogHelper.error(e + " Could not read texture data: " + sprite.func_94215_i());
            return MISSINGNO_DATA;
        }
        if (data == null || data.length <= 0 || data[0] == null || data[0].length <= 0) {
            LogHelper.error("Could not read texture data: " + sprite.func_94215_i() + " - frame 0 array missing");
            return MISSINGNO_DATA;
        }
        return data[0];
    }

    public static String getTemplateSpriteName(ItemTool tool, int tier) {
        return "template_" + ItemHelper.getItemTypeString(tool) + "_" + tier;
    }

    public static String getOverlaySpriteName(ItemTool tool, int tier) {
        return "overlay_" + ItemHelper.getItemTypeString(tool) + "_" + tier;
    }

    public static Color darkenColor(Color color, float factor) {
        return new Color(Math.min(255, Math.round((float)color.getRed() * factor)), Math.min(255, Math.round((float)color.getGreen() * factor)), Math.min(255, Math.round((float)color.getBlue() * factor)));
    }

    public static Color lightenColor(Color color, float factor) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        r = Math.min(255, Math.round((255.0f - (float)r) * factor + (float)r));
        g = Math.min(255, Math.round((255.0f - (float)g) * factor + (float)g));
        b = Math.min(255, Math.round((255.0f - (float)b) * factor + (float)b));
        return new Color(r, g, b);
    }
}

