/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.stripmining.util;

import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextComponentTranslation;

public class StringHelper {
    public static String getItemUnlocalizedName(String locName) {
        return StringHelper.getItemUnlocalizedName(locName, "stripmining");
    }

    public static String getItemUnlocalizedName(String locName, String modId) {
        return String.format("item.%s:%s", modId.toLowerCase(), StringHelper.stripUnlocalizedName(locName));
    }

    public static String getItemID(String locName) {
        return StringHelper.getItemID(locName, "stripmining");
    }

    public static String getItemID(String locName, String modId) {
        return String.format("%s:%s", modId, locName);
    }

    public static String stripUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    public static String translateString(String unlocalizedStr, String type) {
        return StringHelper.translateString(unlocalizedStr, type, "stripmining");
    }

    public static String translateString(String unlocalizedStr, String type, String modIdStr) {
        String modId = modIdStr;
        if (modId == null || modId.equals("")) {
            modId = "stripmining";
        }
        if (type == null || type.equals("")) {
            return new TextComponentTranslation(modId.toLowerCase() + ":" + unlocalizedStr, new Object[0]).func_150254_d();
        }
        return new TextComponentTranslation(String.format("%s.%s:%s", type, modId.toLowerCase(), unlocalizedStr), new Object[0]).func_150254_d();
    }

    public static String translateFormattedSTring(String unlocalizedStr, String type, Object ... parameters) {
        return StringHelper.translateFormattedString(unlocalizedStr, type, "stripmining", parameters);
    }

    public static String translateFormattedString(String unlocalizedStr, String type, String modIdStr, Object ... parameters) {
        String modId = modIdStr;
        if (modId == null || modId.equals("")) {
            modId = "stripmining";
        }
        if (type == null || type.equals("")) {
            return new TextComponentTranslation(String.format(modId.toLowerCase() + ":" + unlocalizedStr, parameters), new Object[0]).func_150254_d();
        }
        return new TextComponentTranslation(String.format(String.format("%s.%s:%s", type, modId.toLowerCase(), unlocalizedStr), parameters), new Object[0]).func_150254_d();
    }

    public static String[] localizeAll(String[] input) {
        String[] ret = new String[input.length];
        for (int i = 0; i < input.length; ++i) {
            ret[i] = I18n.func_135052_a((String)input[i], (Object[])new Object[0]);
        }
        return ret;
    }
}

