/*
 * Decompiled with CFR 0.152.
 */
package com.burrows.easaddon;

import com.burrows.easaddon.AlertPolygon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlertPolygonManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"EASAddon");
    private static final Map<BlockPos, List<AlertPolygon>> polygonMap = new ConcurrentHashMap<BlockPos, List<AlertPolygon>>();

    public static void addPolygon(BlockPos pos, AlertPolygon polygon) {
        LOGGER.info("AlertPolygonManager: Adding polygon for storm {} at position {}", (Object)polygon.stormId, (Object)pos);
        List list = polygonMap.computeIfAbsent(pos, k -> new ArrayList());
        list.removeIf(existing -> existing.stormId == polygon.stormId);
        list.add(polygon);
        LOGGER.info("AlertPolygonManager: Total polygons at {}: {}", (Object)pos, (Object)polygonMap.get(pos).size());
    }

    public static Collection<AlertPolygon> getPolygonsAt(BlockPos pos) {
        Collection polys = polygonMap.getOrDefault(pos, Collections.emptyList());
        return polys;
    }

    public static void clearPolygons(BlockPos pos) {
        LOGGER.info("AlertPolygonManager: Clearing polygons at position {}", (Object)pos);
        polygonMap.remove(pos);
    }

    public static void retainPolygons(BlockPos pos, Set<Long> keepIds) {
        List<AlertPolygon> list = polygonMap.get(pos);
        if (list == null) {
            return;
        }
        boolean changed = list.removeIf(poly -> !keepIds.contains(poly.stormId));
        if (changed) {
            LOGGER.info("AlertPolygonManager: Pruned to {} polygons at {}", (Object)list.size(), (Object)pos);
        }
    }

    public static void writePolygons(BlockPos pos, CompoundTag tag) {
        List<AlertPolygon> polygons = polygonMap.get(pos);
        LOGGER.info("AlertPolygonManager: writePolygons called for position {}, found {} polygons", (Object)pos, (Object)(polygons != null ? polygons.size() : 0));
        if (polygons == null || polygons.isEmpty()) {
            LOGGER.info("AlertPolygonManager: No polygons to write for position {}", (Object)pos);
            return;
        }
        ListTag list = new ListTag();
        for (AlertPolygon poly : polygons) {
            CompoundTag polyTag = new CompoundTag();
            polyTag.putLong("stormId", poly.stormId);
            polyTag.putDouble("centerX", poly.centerX);
            polyTag.putDouble("centerZ", poly.centerZ);
            polyTag.putFloat("halfWidth", poly.halfWidth);
            polyTag.putFloat("halfHeight", poly.halfHeight);
            polyTag.putFloat("rotation", poly.rotationDeg);
            polyTag.putInt("stormType", poly.stormType);
            polyTag.putInt("stormStage", poly.stormStage);
            polyTag.putInt("level", poly.level);
            list.add((Object)polyTag);
            LOGGER.info("AlertPolygonManager: Written polygon - stormId: {}, center: ({}, {}), level: {}", (Object)poly.stormId, (Object)poly.centerX, (Object)poly.centerZ, (Object)poly.level);
        }
        tag.put("polygons", (Tag)list);
        LOGGER.info("AlertPolygonManager: Finished writing {} polygons to NBT for position {}", (Object)list.size(), (Object)pos);
    }

    public static void readPolygons(BlockPos pos, CompoundTag tag) {
        LOGGER.info("AlertPolygonManager: readPolygons called for position {}", (Object)pos);
        if (!tag.contains("polygons")) {
            LOGGER.info("AlertPolygonManager: No 'polygons' tag found in NBT for position {}", (Object)pos);
            return;
        }
        ListTag list = tag.getList("polygons", 10);
        LOGGER.info("AlertPolygonManager: Found {} polygons in NBT for position {}", (Object)list.size(), (Object)pos);
        ArrayList<AlertPolygon> polygons = new ArrayList<AlertPolygon>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag polyTag = list.getCompound(i);
            AlertPolygon poly = new AlertPolygon(polyTag.getLong("stormId"), polyTag.getDouble("centerX"), polyTag.getDouble("centerZ"), polyTag.getFloat("halfWidth"), polyTag.getFloat("halfHeight"), polyTag.getFloat("rotation"), polyTag.getInt("stormType"), polyTag.getInt("stormStage"), polyTag.getInt("level"));
            polygons.add(poly);
            LOGGER.info("AlertPolygonManager: Read polygon - stormId: {}, center: ({}, {}), level: {}", (Object)poly.stormId, (Object)poly.centerX, (Object)poly.centerZ, (Object)poly.level);
        }
        if (!polygons.isEmpty()) {
            polygonMap.put(pos, polygons);
            LOGGER.info("AlertPolygonManager: Stored {} polygons for position {}", (Object)polygons.size(), (Object)pos);
        } else {
            LOGGER.warn("AlertPolygonManager: No polygons were read from NBT for position {}", (Object)pos);
        }
    }

    public static void debugPrintState() {
        LOGGER.info("AlertPolygonManager: Current state - {} positions with polygons:", (Object)polygonMap.size());
        for (Map.Entry<BlockPos, List<AlertPolygon>> entry : polygonMap.entrySet()) {
            LOGGER.info("  Position {}: {} polygons", (Object)entry.getKey(), (Object)entry.getValue().size());
        }
    }
}

