/*
 * Decompiled with CFR 0.152.
 */
package com.burrows.easaddon;

import com.burrows.easaddon.RegistryHandler;
import com.burrows.easaddon.client.RadarOverlayRenderer;
import com.mojang.logging.LogUtils;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import org.slf4j.Logger;

@Mod(value="easaddon")
public class EASAddon {
    public static final String MODID = "easaddon";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static boolean pmweatherAvailable = false;

    public EASAddon(IEventBus modEventBus, ModContainer modContainer) {
        this.verifyPMWeatherPresence();
        RegistryHandler.register(modEventBus);
        modEventBus.addListener(EntityRenderersEvent.RegisterRenderers.class, this::onRegisterRenderers);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        LOGGER.info("Initialized for Minecraft {} with NeoForge");
        LOGGER.info("PMWeather integration: {}", (Object)(pmweatherAvailable ? "\u00a7aACTIVE" : "\u00a7cUNAVAILABLE"));
    }

    private void verifyPMWeatherPresence() {
        boolean bl = pmweatherAvailable = ModList.get().isLoaded("pmweather") && this.classExists("dev.protomanly.pmweather.block.TornadoSensorBlock");
        if (!pmweatherAvailable) {
            LOGGER.warn("PMWeather not found - tornado detection disabled");
        }
    }

    private boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers evt) {
        LOGGER.info("[EASAddon] \u2192 Registering RadarOverlayRenderer");
        evt.registerBlockEntityRenderer((BlockEntityType)RegistryHandler.RADAR_OVERLAY_BE.get(), RadarOverlayRenderer::new);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common setup complete");
        LOGGER.debug("NeoForge API version: {}");
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Client setup complete");
    }

    public static boolean isPMWeatherAvailable() {
        return pmweatherAvailable;
    }
}

